/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import io.branch.referral.Base64;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.BranchLinkData;
import io.branch.referral.Defines;
import io.branch.referral.ExtendedAnswerProvider;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerResponse;
import java.util.Collection;
import org.json.JSONException;
import org.json.JSONObject;

class ServerRequestCreateUrl
extends ServerRequest {
    private BranchLinkData linkPost_;
    private boolean isAsync_ = true;
    private Branch.BranchLinkCreateListener callback_;
    private static final String DEF_BASE_URL = "https://bnc.lt/a/";
    private boolean isReqStartedFromBranchShareSheet_;
    private boolean defaultToLongUrl_ = true;

    public ServerRequestCreateUrl(Context context, String alias, int type, int duration, Collection<String> tags, String channel, String feature, String stage, String campaign, String params, Branch.BranchLinkCreateListener callback, boolean async, boolean defaultToLongUrl) {
        super(context, Defines.RequestPath.GetURL.getPath());
        this.callback_ = callback;
        this.isAsync_ = async;
        this.defaultToLongUrl_ = defaultToLongUrl;
        this.linkPost_ = new BranchLinkData();
        try {
            this.linkPost_.put(Defines.Jsonkey.IdentityID.getKey(), this.prefHelper_.getIdentityID());
            this.linkPost_.put(Defines.Jsonkey.DeviceFingerprintID.getKey(), this.prefHelper_.getDeviceFingerPrintID());
            this.linkPost_.put(Defines.Jsonkey.SessionID.getKey(), this.prefHelper_.getSessionID());
            if (!this.prefHelper_.getLinkClickID().equals("bnc_no_value")) {
                this.linkPost_.put(Defines.Jsonkey.LinkClickID.getKey(), this.prefHelper_.getLinkClickID());
            }
            this.linkPost_.putType(type);
            this.linkPost_.putDuration(duration);
            this.linkPost_.putTags(tags);
            this.linkPost_.putAlias(alias);
            this.linkPost_.putChannel(channel);
            this.linkPost_.putFeature(feature);
            this.linkPost_.putStage(stage);
            this.linkPost_.putCampaign(campaign);
            this.linkPost_.putParams(params);
            this.setPost(this.linkPost_);
        }
        catch (JSONException ex) {
            ex.printStackTrace();
            this.constructError_ = true;
        }
    }

    public ServerRequestCreateUrl(String requestPath, JSONObject post, Context context) {
        super(requestPath, post, context);
    }

    public BranchLinkData getLinkPost() {
        return this.linkPost_;
    }

    boolean isDefaultToLongUrl() {
        return this.defaultToLongUrl_;
    }

    @Override
    public boolean handleErrors(Context context) {
        if (!super.doesAppHasInternetPermission(context)) {
            if (this.callback_ != null) {
                this.callback_.onLinkCreate(null, new BranchError("Trouble creating a URL.", -102));
            }
            return true;
        }
        return !this.isAsync_ && !this.hasUser();
    }

    @Override
    public void onRequestSucceeded(ServerResponse resp, Branch branch) {
        try {
            String url = resp.getObject().getString("url");
            if (this.callback_ != null) {
                this.callback_.onLinkCreate(url, null);
            }
            this.updateShareEventToFabric(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onUrlAvailable(String url) {
        if (this.callback_ != null) {
            this.callback_.onLinkCreate(url, null);
        }
        this.updateShareEventToFabric(url);
    }

    @Override
    public void handleFailure(int statusCode, String causeMsg) {
        if (this.callback_ != null) {
            String failedUrl = null;
            if (this.defaultToLongUrl_) {
                failedUrl = this.getLongUrl();
            }
            this.callback_.onLinkCreate(failedUrl, new BranchError("Trouble creating a URL. " + causeMsg, statusCode));
        }
    }

    public String getLongUrl() {
        String longUrl = !this.prefHelper_.getUserURL().equals("bnc_no_value") ? this.generateLongUrlWithParams(this.prefHelper_.getUserURL()) : this.generateLongUrlWithParams(DEF_BASE_URL + this.prefHelper_.getBranchKey());
        return longUrl;
    }

    public void handleDuplicateURLError() {
        if (this.callback_ != null) {
            this.callback_.onLinkCreate(null, new BranchError("Trouble creating a URL.", -105));
        }
    }

    private boolean hasUser() {
        return !this.prefHelper_.getIdentityID().equals("bnc_no_value");
    }

    @Override
    public boolean isGetRequest() {
        return false;
    }

    @Override
    public void clearCallbacks() {
        this.callback_ = null;
    }

    public boolean isAsync() {
        return this.isAsync_;
    }

    private String generateLongUrlWithParams(String baseUrl) {
        String campaign;
        String stage;
        String feature;
        String channel;
        String alias;
        String longUrl = baseUrl + "?";
        Collection<String> tags = this.linkPost_.getTags();
        if (tags != null) {
            for (String tag : tags) {
                if (tag == null || tag.length() <= 0) continue;
                longUrl = longUrl + (Object)((Object)Defines.LinkParam.Tags) + "=" + tag + "&";
            }
        }
        if ((alias = this.linkPost_.getAlias()) != null && alias.length() > 0) {
            longUrl = longUrl + (Object)((Object)Defines.LinkParam.Alias) + "=" + alias + "&";
        }
        if ((channel = this.linkPost_.getChannel()) != null && channel.length() > 0) {
            longUrl = longUrl + (Object)((Object)Defines.LinkParam.Channel) + "=" + channel + "&";
        }
        if ((feature = this.linkPost_.getFeature()) != null && feature.length() > 0) {
            longUrl = longUrl + (Object)((Object)Defines.LinkParam.Feature) + "=" + feature + "&";
        }
        if ((stage = this.linkPost_.getStage()) != null && stage.length() > 0) {
            longUrl = longUrl + (Object)((Object)Defines.LinkParam.Stage) + "=" + stage + "&";
        }
        if ((campaign = this.linkPost_.getCampaign()) != null && campaign.length() > 0) {
            longUrl = longUrl + (Object)((Object)Defines.LinkParam.Campaign) + "=" + campaign + "&";
        }
        long type = this.linkPost_.getType();
        longUrl = longUrl + (Object)((Object)Defines.LinkParam.Type) + "=" + type + "&";
        long duration = this.linkPost_.getDuration();
        longUrl = longUrl + (Object)((Object)Defines.LinkParam.Duration) + "=" + duration + "&";
        String params = this.linkPost_.getParams();
        if (params != null && params.length() > 0) {
            byte[] data = params.getBytes();
            String base64Data = Base64.encodeToString(data, 2);
            longUrl = longUrl + "source=android&data=" + base64Data;
        }
        return longUrl;
    }

    void setIsReqStartedFromBranchShareSheet(boolean startedByShareSheet) {
        this.isReqStartedFromBranchShareSheet_ = startedByShareSheet;
    }

    boolean isReqStartedFromBranchShareSheet() {
        return this.isReqStartedFromBranchShareSheet_;
    }

    private void updateShareEventToFabric(String url) {
        JSONObject linkDataJsonObj = this.linkPost_.getLinkDataJsonObject();
        if (this.isReqStartedFromBranchShareSheet() && linkDataJsonObj != null) {
            new ExtendedAnswerProvider().provideData("Branch Share", linkDataJsonObj, this.prefHelper_.getIdentityID());
        }
    }
}

