/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;
import io.branch.referral.Branch;
import io.branch.referral.Defines;
import io.branch.referral.DeviceInfo;
import io.branch.referral.PrefHelper;
import io.branch.referral.ServerRequestActionCompleted;
import io.branch.referral.ServerRequestCreateUrl;
import io.branch.referral.ServerRequestGetRewardHistory;
import io.branch.referral.ServerRequestGetRewards;
import io.branch.referral.ServerRequestIdentifyUserRequest;
import io.branch.referral.ServerRequestLogout;
import io.branch.referral.ServerRequestRedeemRewards;
import io.branch.referral.ServerRequestRegisterClose;
import io.branch.referral.ServerRequestRegisterInstall;
import io.branch.referral.ServerRequestRegisterOpen;
import io.branch.referral.ServerRequestSendAppList;
import io.branch.referral.ServerResponse;
import io.branch.referral.SystemObserver;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ServerRequest {
    private static final String POST_KEY = "REQ_POST";
    private static final String POST_PATH_KEY = "REQ_POST_PATH";
    private JSONObject params_;
    protected String requestPath_;
    protected PrefHelper prefHelper_;
    private final SystemObserver systemObserver_;
    long queueWaitTime_ = 0L;
    private boolean disableAndroidIDFetch_;
    private int waitLockCnt = 0;
    final Set<PROCESS_WAIT_LOCK> locks_;
    public boolean constructError_ = false;
    boolean skipOnTimeOut = false;

    public ServerRequest(Context context, String requestPath) {
        this.requestPath_ = requestPath;
        this.prefHelper_ = PrefHelper.getInstance(context);
        this.systemObserver_ = new SystemObserver(context);
        this.params_ = new JSONObject();
        this.disableAndroidIDFetch_ = Branch.isDeviceIDFetchDisabled();
        this.locks_ = new HashSet<PROCESS_WAIT_LOCK>();
    }

    protected ServerRequest(String requestPath, JSONObject post, Context context) {
        this.requestPath_ = requestPath;
        this.params_ = post;
        this.prefHelper_ = PrefHelper.getInstance(context);
        this.systemObserver_ = new SystemObserver(context);
        this.disableAndroidIDFetch_ = Branch.isDeviceIDFetchDisabled();
        this.locks_ = new HashSet<PROCESS_WAIT_LOCK>();
    }

    public abstract boolean handleErrors(Context var1);

    public abstract void onRequestSucceeded(ServerResponse var1, Branch var2);

    public abstract void handleFailure(int var1, String var2);

    public abstract boolean isGetRequest();

    public abstract void clearCallbacks();

    public boolean shouldRetryOnFail() {
        return false;
    }

    public final String getRequestPath() {
        return this.requestPath_;
    }

    public String getRequestUrl() {
        return this.prefHelper_.getAPIBaseUrl() + this.requestPath_;
    }

    protected void setPost(JSONObject post) {
        try {
            JSONObject metadata = new JSONObject();
            Iterator i = this.prefHelper_.getRequestMetadata().keys();
            while (i.hasNext()) {
                String k = (String)i.next();
                metadata.put(k, this.prefHelper_.getRequestMetadata().get(k));
            }
            if (post.has(Defines.Jsonkey.Metadata.getKey())) {
                Iterator postIter = post.getJSONObject(Defines.Jsonkey.Metadata.getKey()).keys();
                while (postIter.hasNext()) {
                    String key = (String)postIter.next();
                    metadata.put(key, post.getJSONObject(Defines.Jsonkey.Metadata.getKey()).get(key));
                }
            }
            post.put(Defines.Jsonkey.Metadata.getKey(), (Object)metadata);
        }
        catch (JSONException e) {
            Log.e((String)"BranchSDK", (String)"Could not merge metadata, ignoring user metadata.");
        }
        this.params_ = post;
        DeviceInfo.getInstance(this.prefHelper_.getExternDebug(), this.systemObserver_, this.disableAndroidIDFetch_).updateRequestWithDeviceParams(this.params_);
    }

    public JSONObject getPost() {
        return this.params_;
    }

    public boolean isGAdsParamsRequired() {
        return false;
    }

    public JSONObject getPostWithInstrumentationValues(ConcurrentHashMap<String, String> instrumentationData) {
        JSONObject extendedPost = new JSONObject();
        try {
            Object keys;
            if (this.params_ != null) {
                JSONObject originalParams = new JSONObject(this.params_.toString());
                keys = originalParams.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    extendedPost.put(key, originalParams.get(key));
                }
            }
            if (instrumentationData.size() > 0) {
                JSONObject instrObj = new JSONObject();
                keys = instrumentationData.keySet();
                try {
                    Iterator iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        instrObj.put(key, (Object)instrumentationData.get(key));
                        instrumentationData.remove(key);
                    }
                    extendedPost.put(Defines.Jsonkey.Branch_Instrumentation.getKey(), (Object)instrObj);
                }
                catch (JSONException jSONException) {}
            }
        }
        catch (JSONException instrObj) {
        }
        catch (ConcurrentModificationException ex) {
            extendedPost = this.params_;
        }
        return extendedPost;
    }

    public JSONObject getGetParams() {
        return this.params_;
    }

    protected void addGetParam(String paramKey, String paramValue) {
        try {
            this.params_.put(paramKey, (Object)paramValue);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        try {
            json.put(POST_KEY, (Object)this.params_);
            json.put(POST_PATH_KEY, (Object)this.requestPath_);
        }
        catch (JSONException e) {
            return null;
        }
        return json;
    }

    public static ServerRequest fromJSON(JSONObject json, Context context) {
        JSONObject post = null;
        String requestPath = "";
        try {
            if (json.has(POST_KEY)) {
                post = json.getJSONObject(POST_KEY);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            if (json.has(POST_PATH_KEY)) {
                requestPath = json.getString(POST_PATH_KEY);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (requestPath != null && requestPath.length() > 0) {
            return ServerRequest.getExtendedServerRequest(requestPath, post, context);
        }
        return null;
    }

    private static ServerRequest getExtendedServerRequest(String requestPath, JSONObject post, Context context) {
        ServerRequest extendedReq = null;
        if (requestPath.equalsIgnoreCase(Defines.RequestPath.CompletedAction.getPath())) {
            extendedReq = new ServerRequestActionCompleted(requestPath, post, context);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.GetURL.getPath())) {
            extendedReq = new ServerRequestCreateUrl(requestPath, post, context);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.GetCreditHistory.getPath())) {
            extendedReq = new ServerRequestGetRewardHistory(requestPath, post, context);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.GetCredits.getPath())) {
            extendedReq = new ServerRequestGetRewards(requestPath, post, context);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.IdentifyUser.getPath())) {
            extendedReq = new ServerRequestIdentifyUserRequest(requestPath, post, context);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.Logout.getPath())) {
            extendedReq = new ServerRequestLogout(requestPath, post, context);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.RedeemRewards.getPath())) {
            extendedReq = new ServerRequestRedeemRewards(requestPath, post, context);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.RegisterClose.getPath())) {
            extendedReq = new ServerRequestRegisterClose(requestPath, post, context);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.RegisterInstall.getPath())) {
            extendedReq = new ServerRequestRegisterInstall(requestPath, post, context);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.RegisterOpen.getPath())) {
            extendedReq = new ServerRequestRegisterOpen(requestPath, post, context);
        } else if (requestPath.equalsIgnoreCase(Defines.RequestPath.SendAPPList.getPath())) {
            extendedReq = new ServerRequestSendAppList(requestPath, post, context);
        }
        return extendedReq;
    }

    public void updateGAdsParams(SystemObserver sysObserver) {
        if (!TextUtils.isEmpty((CharSequence)sysObserver.GAIDString_)) {
            try {
                this.params_.put(Defines.Jsonkey.GoogleAdvertisingID.getKey(), (Object)sysObserver.GAIDString_);
                this.params_.put(Defines.Jsonkey.LATVal.getKey(), sysObserver.LATVal_);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean doesAppHasInternetPermission(Context context) {
        int result = context.checkCallingOrSelfPermission("android.permission.INTERNET");
        return result == 0;
    }

    public void onRequestQueued() {
        this.queueWaitTime_ = System.currentTimeMillis();
    }

    public long getQueueWaitTime() {
        long waitTime = 0L;
        if (this.queueWaitTime_ > 0L) {
            waitTime = System.currentTimeMillis() - this.queueWaitTime_;
        }
        return waitTime;
    }

    public void addProcessWaitLock(PROCESS_WAIT_LOCK lock) {
        if (lock != null) {
            this.locks_.add(lock);
        }
    }

    public void removeProcessWaitLock(PROCESS_WAIT_LOCK lock) {
        this.locks_.remove((Object)lock);
    }

    public boolean isWaitingOnProcessToFinish() {
        return this.locks_.size() > 0;
    }

    public void onPreExecute() {
    }

    protected void updateEnvironment(Context context, JSONObject post) {
        try {
            String environment = ServerRequest.isPackageInstalled(context) ? Defines.Jsonkey.NativeApp.getKey() : Defines.Jsonkey.InstantApp.getKey();
            post.put(Defines.Jsonkey.Environment.getKey(), (Object)environment);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isPackageInstalled(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = packageManager.getLaunchIntentForPackage(context.getPackageName());
        if (intent == null) {
            return false;
        }
        List list = packageManager.queryIntentActivities(intent, 65536);
        return list != null && list.size() > 0;
    }

    static enum PROCESS_WAIT_LOCK {
        FB_APP_LINK_WAIT_LOCK,
        GAID_FETCH_WAIT_LOCK,
        INTENT_PENDING_WAIT_LOCK,
        STRONG_MATCH_PENDING_WAIT_LOCK,
        INSTALL_REFERRER_FETCH_WAIT_LOCK;

    }
}

