/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.text.TextUtils;
import com.crashlytics.android.answers.shim.AnswersOptionalLogger;
import com.crashlytics.android.answers.shim.KitEvent;
import io.branch.referral.Defines;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ExtendedAnswerProvider {
    public static final String KIT_EVENT_INSTALL = "Branch Install";
    public static final String KIT_EVENT_OPEN = "Branch Open";
    public static final String KIT_EVENT_SHARE = "Branch Share";
    private static final String EXTRA_PARAM_NOTATION = "+";
    private static final String CTRL_PARAM_NOTATION = "~";
    private static final String INNER_PARAM_NOTATION = ".";

    ExtendedAnswerProvider() {
    }

    public void provideData(String eventName, JSONObject eventData, String identityID) {
        try {
            KitEvent kitEvent = new KitEvent(eventName);
            if (eventData != null) {
                this.addJsonObjectToKitEvent(kitEvent, eventData, "");
                kitEvent.putAttribute(Defines.Jsonkey.BranchIdentity.getKey(), identityID);
                AnswersOptionalLogger.get().logKitEvent(kitEvent);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addJsonObjectToKitEvent(KitEvent kitEvent, JSONObject jsonData, String keyPathPrepend) throws JSONException {
        Iterator keyIterator = jsonData.keys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = jsonData.get(key);
            if (key.startsWith(EXTRA_PARAM_NOTATION)) continue;
            if (value instanceof JSONObject) {
                this.addJsonObjectToKitEvent(kitEvent, (JSONObject)value, keyPathPrepend + key + INNER_PARAM_NOTATION);
                continue;
            }
            if (value instanceof JSONArray) {
                this.addJsonArrayToKitEvent(kitEvent, (JSONArray)value, key + INNER_PARAM_NOTATION);
                continue;
            }
            this.addBranchAttributes(kitEvent, keyPathPrepend, key, jsonData.getString(key));
        }
    }

    private void addJsonArrayToKitEvent(KitEvent kitEvent, JSONArray jsonArray, String keyPathPrepend) throws JSONException {
        for (int i = 0; i < jsonArray.length(); ++i) {
            this.addBranchAttributes(kitEvent, keyPathPrepend, CTRL_PARAM_NOTATION + Integer.toString(i), jsonArray.getString(i));
        }
    }

    private void addBranchAttributes(KitEvent kitEvent, String keyPathPrepend, String key, String value) {
        if (!TextUtils.isEmpty((CharSequence)value)) {
            if (key.startsWith(CTRL_PARAM_NOTATION)) {
                String modifiedKey = keyPathPrepend.replaceFirst(CTRL_PARAM_NOTATION, "") + key.replaceFirst(CTRL_PARAM_NOTATION, "");
                kitEvent.putAttribute(modifiedKey, value);
            } else if (key.equals("$" + Defines.Jsonkey.IdentityID.getKey())) {
                kitEvent.putAttribute(Defines.Jsonkey.ReferringBranchIdentity.getKey(), value);
            }
        }
    }
}

