/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.text.TextUtils;
import android.util.DisplayMetrics;
import io.branch.referral.Defines;
import io.branch.referral.SystemObserver;
import org.json.JSONException;
import org.json.JSONObject;

class DeviceInfo {
    private final String hardwareID_;
    private final boolean isHardwareIDReal_;
    private final String brandName_;
    private final String modelName_;
    private final int screenDensity_;
    private final int screenHeight_;
    private final int screenWidth_;
    private final boolean isWifiConnected_;
    private final String localIpAddr_;
    private final String osName_;
    private final int osVersion_;
    private final String packageName_;
    private final String appVersion_;
    private final String countryCode_;
    private final String languageCode_;
    private static DeviceInfo thisInstance_ = null;

    public static DeviceInfo getInstance(boolean isExternalDebug, SystemObserver sysObserver, boolean disableAndroidIDFetch) {
        if (thisInstance_ == null) {
            thisInstance_ = new DeviceInfo(isExternalDebug, sysObserver, disableAndroidIDFetch);
        }
        return thisInstance_;
    }

    public static DeviceInfo getInstance() {
        return thisInstance_;
    }

    private DeviceInfo(boolean isExternalDebug, SystemObserver sysObserver, boolean disableAndroidIDFetch) {
        this.hardwareID_ = disableAndroidIDFetch ? sysObserver.getUniqueID(true) : sysObserver.getUniqueID(isExternalDebug);
        this.isHardwareIDReal_ = sysObserver.hasRealHardwareId();
        this.brandName_ = sysObserver.getPhoneBrand();
        this.modelName_ = sysObserver.getPhoneModel();
        DisplayMetrics dMetrics = sysObserver.getScreenDisplay();
        this.screenDensity_ = dMetrics.densityDpi;
        this.screenHeight_ = dMetrics.heightPixels;
        this.screenWidth_ = dMetrics.widthPixels;
        this.isWifiConnected_ = sysObserver.getWifiConnected();
        this.localIpAddr_ = sysObserver.getLocalIPAddress();
        this.osName_ = sysObserver.getOS();
        this.osVersion_ = sysObserver.getOSVersion();
        this.packageName_ = sysObserver.getPackageName();
        this.appVersion_ = sysObserver.getAppVersion();
        this.countryCode_ = sysObserver.getISO2CountryCode();
        this.languageCode_ = sysObserver.getISO2LanguageCode();
    }

    public void updateRequestWithDeviceParams(JSONObject requestObj) {
        try {
            if (!this.hardwareID_.equals("bnc_no_value")) {
                requestObj.put(Defines.Jsonkey.HardwareID.getKey(), (Object)this.hardwareID_);
                requestObj.put(Defines.Jsonkey.IsHardwareIDReal.getKey(), this.isHardwareIDReal_);
            }
            if (!this.brandName_.equals("bnc_no_value")) {
                requestObj.put(Defines.Jsonkey.Brand.getKey(), (Object)this.brandName_);
            }
            if (!this.modelName_.equals("bnc_no_value")) {
                requestObj.put(Defines.Jsonkey.Model.getKey(), (Object)this.modelName_);
            }
            requestObj.put(Defines.Jsonkey.ScreenDpi.getKey(), this.screenDensity_);
            requestObj.put(Defines.Jsonkey.ScreenHeight.getKey(), this.screenHeight_);
            requestObj.put(Defines.Jsonkey.ScreenWidth.getKey(), this.screenWidth_);
            requestObj.put(Defines.Jsonkey.WiFi.getKey(), this.isWifiConnected_);
            if (!this.osName_.equals("bnc_no_value")) {
                requestObj.put(Defines.Jsonkey.OS.getKey(), (Object)this.osName_);
            }
            requestObj.put(Defines.Jsonkey.OSVersion.getKey(), this.osVersion_);
            if (!TextUtils.isEmpty((CharSequence)this.countryCode_)) {
                requestObj.put(Defines.Jsonkey.Country.getKey(), (Object)this.countryCode_);
            }
            if (!TextUtils.isEmpty((CharSequence)this.languageCode_)) {
                requestObj.put(Defines.Jsonkey.Language.getKey(), (Object)this.languageCode_);
            }
            if (!TextUtils.isEmpty((CharSequence)this.localIpAddr_)) {
                requestObj.put(Defines.Jsonkey.LocalIP.getKey(), (Object)this.localIpAddr_);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public String getPackageName() {
        return this.packageName_;
    }

    public String getAppVersion() {
        return this.appVersion_;
    }

    public boolean isHardwareIDReal() {
        return this.isHardwareIDReal_;
    }

    public String getHardwareID() {
        return this.hardwareID_.equals("bnc_no_value") ? null : this.hardwareID_;
    }

    public String getOsName() {
        return this.osName_;
    }
}

