/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class DeferredAppLinkDataHandler {
    private static final String NATIVE_URL_KEY = "com.facebook.platform.APPLINK_NATIVE_URL";

    DeferredAppLinkDataHandler() {
    }

    public static Boolean fetchDeferredAppLinkData(Context context, final AppLinkFetchEvents callback) {
        boolean isRequestSucceeded = true;
        try {
            Class<?> FacebookSdkClass = Class.forName("com.facebook.FacebookSdk");
            Method initSdkMethod = FacebookSdkClass.getMethod("sdkInitialize", Context.class);
            initSdkMethod.invoke(null, context);
            final Class<?> AppLinkDataClass = Class.forName("com.facebook.applinks.AppLinkData");
            Class<?> AppLinkDataCompletionHandlerClass = Class.forName("com.facebook.applinks.AppLinkData$CompletionHandler");
            Method fetchDeferredAppLinkDataMethod = AppLinkDataClass.getMethod("fetchDeferredAppLinkData", Context.class, String.class, AppLinkDataCompletionHandlerClass);
            InvocationHandler ALDataCompletionHandler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("onDeferredAppLinkDataFetched") && args[0] != null) {
                        String appLinkUrl = null;
                        Object appLinkDataClass = AppLinkDataClass.cast(args[0]);
                        Method getArgumentBundleMethod = AppLinkDataClass.getMethod("getArgumentBundle", new Class[0]);
                        Bundle appLinkDataBundle = (Bundle)Bundle.class.cast(getArgumentBundleMethod.invoke(appLinkDataClass, new Object[0]));
                        if (appLinkDataBundle != null) {
                            appLinkUrl = appLinkDataBundle.getString(DeferredAppLinkDataHandler.NATIVE_URL_KEY);
                        }
                        if (callback != null) {
                            callback.onAppLinkFetchFinished(appLinkUrl);
                        }
                    } else if (callback != null) {
                        callback.onAppLinkFetchFinished(null);
                    }
                    return null;
                }
            };
            Object completionListenerInterface = Proxy.newProxyInstance(AppLinkDataCompletionHandlerClass.getClassLoader(), new Class[]{AppLinkDataCompletionHandlerClass}, ALDataCompletionHandler);
            String fbAppID = context.getString(context.getResources().getIdentifier("facebook_app_id", "string", context.getPackageName()));
            if (TextUtils.isEmpty((CharSequence)fbAppID)) {
                isRequestSucceeded = false;
            } else {
                fetchDeferredAppLinkDataMethod.invoke(null, context, fbAppID, completionListenerInterface);
            }
        }
        catch (Throwable ex) {
            isRequestSucceeded = false;
        }
        return isRequestSucceeded;
    }

    public static interface AppLinkFetchEvents {
        public void onAppLinkFetchFinished(String var1);
    }
}

