/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class BranchUtil {
    static boolean isCustomDebugEnabled_ = false;

    BranchUtil() {
    }

    public static boolean isTestModeEnabled(Context context) {
        if (isCustomDebugEnabled_) {
            return isCustomDebugEnabled_;
        }
        boolean isTestMode_ = false;
        String testModeKey = "io.branch.sdk.TestMode";
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (ai.metaData != null && ai.metaData.containsKey(testModeKey)) {
                isTestMode_ = ai.metaData.getBoolean(testModeKey, false);
            } else {
                Resources resources = context.getResources();
                isTestMode_ = Boolean.parseBoolean(resources.getString(resources.getIdentifier(testModeKey, "string", context.getPackageName())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isTestMode_;
    }

    public static String formatAndStringifyLinkParam(JSONObject params) {
        return BranchUtil.stringifyAndAddSource(BranchUtil.filterOutBadCharacters(params));
    }

    public static String stringifyAndAddSource(JSONObject params) {
        if (params == null) {
            params = new JSONObject();
        }
        try {
            params.put("source", (Object)"android");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return params.toString();
    }

    public static JSONObject filterOutBadCharacters(JSONObject inputObj) {
        JSONObject filteredObj = new JSONObject();
        if (inputObj != null) {
            Iterator keys = inputObj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    if (inputObj.has(key) && inputObj.get(key).getClass().equals(String.class)) {
                        filteredObj.put(key, (Object)inputObj.getString(key).replace("\n", "\\n").replace("\r", "\\r").replace("\"", "\\\""));
                        continue;
                    }
                    if (!inputObj.has(key)) continue;
                    filteredObj.put(key, inputObj.get(key));
                }
                catch (JSONException jSONException) {}
            }
        }
        return filteredObj;
    }

    public static Drawable getDrawable(@NonNull Context context, @DrawableRes int drawableID) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(drawableID, context.getTheme());
        }
        return context.getResources().getDrawable(drawableID);
    }
}

