/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.Context;
import android.util.Log;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.BranchUtil;
import io.branch.referral.ServerRequestCreateUrl;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class BranchUrlBuilder<T extends BranchUrlBuilder> {
    protected JSONObject params_;
    protected String channel_;
    protected String feature_;
    protected String stage_;
    protected String campaign_;
    protected String alias_;
    protected int type_ = 0;
    protected int duration_ = 0;
    protected ArrayList<String> tags_;
    protected Branch branchReferral_ = Branch.getInstance();
    private boolean defaultToLongUrl_;
    private final Context context_;

    protected BranchUrlBuilder(Context context) {
        this.context_ = context.getApplicationContext();
        this.defaultToLongUrl_ = true;
    }

    public T addTag(String tag) {
        if (this.tags_ == null) {
            this.tags_ = new ArrayList();
        }
        this.tags_.add(tag);
        return (T)this;
    }

    public T addTags(List<String> tags) {
        if (this.tags_ == null) {
            this.tags_ = new ArrayList();
        }
        this.tags_.addAll(tags);
        return (T)this;
    }

    public T addParameters(String key, String value) {
        try {
            if (this.params_ == null) {
                this.params_ = new JSONObject();
            }
            this.params_.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return (T)this;
    }

    public T addParameters(String key, JSONArray value) {
        try {
            if (this.params_ == null) {
                this.params_ = new JSONObject();
            }
            this.params_.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return (T)this;
    }

    public T setDefaultToLongUrl(boolean defaultToLongUrl) {
        this.defaultToLongUrl_ = defaultToLongUrl;
        return (T)this;
    }

    protected String getUrl() {
        String shortUrl = null;
        if (this.branchReferral_ != null) {
            ServerRequestCreateUrl req = new ServerRequestCreateUrl(this.context_, this.alias_, this.type_, this.duration_, this.tags_, this.channel_, this.feature_, this.stage_, this.campaign_, BranchUtil.formatAndStringifyLinkParam(this.params_), null, false, this.defaultToLongUrl_);
            shortUrl = this.branchReferral_.generateShortLinkInternal(req);
        }
        return shortUrl;
    }

    protected void generateUrl(Branch.BranchLinkCreateListener callback) {
        this.generateUrlInternal(callback, false);
    }

    protected void generateUrlInternal(Branch.BranchLinkCreateListener callback, boolean isFromShareSheet) {
        if (this.branchReferral_ != null) {
            ServerRequestCreateUrl req = new ServerRequestCreateUrl(this.context_, this.alias_, this.type_, this.duration_, this.tags_, this.channel_, this.feature_, this.stage_, this.campaign_, BranchUtil.formatAndStringifyLinkParam(this.params_), callback, true, this.defaultToLongUrl_);
            req.setIsReqStartedFromBranchShareSheet(isFromShareSheet);
            this.branchReferral_.generateShortLinkInternal(req);
        } else {
            if (callback != null) {
                callback.onLinkCreate(null, new BranchError("session has not been initialized", -101));
            }
            Log.i((String)"BranchSDK", (String)"Branch Warning: User session has not been initialized");
        }
    }
}

