/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;
import io.branch.referral.BranchUtil;
import io.branch.referral.Defines;
import io.branch.referral.DeviceInfo;
import io.branch.referral.PrefHelper;
import io.branch.referral.SystemObserver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;

class BranchStrongMatchHelper {
    private static BranchStrongMatchHelper branchStrongMatchHelper_;
    Object mClient_ = null;
    private static final int STRONG_MATCH_CHECK_TIME_OUT = 500;
    public static final int STRONG_MATCH_URL_HIT_DELAY = 750;
    private static final long THIRTY_DAYS_EPOCH_MILLI_SEC = 2592000000L;
    private final Handler timeOutHandler_;
    private static int StrongMatchUrlHitDelay;
    private boolean isCustomTabsAvailable_ = true;
    boolean isStrongMatchUrlLaunched = false;
    Class<?> CustomTabsClientClass;
    Class<?> CustomServiceTabConnectionClass;
    Class<?> CustomTabsCallbackClass;
    Class<?> CustomTabsSessionClass;
    Class<?> ICustomTabsServiceClass;

    private BranchStrongMatchHelper() {
        try {
            this.CustomTabsClientClass = Class.forName("android.support.customtabs.CustomTabsClient");
            this.CustomServiceTabConnectionClass = Class.forName("android.support.customtabs.CustomTabsServiceConnection");
            this.CustomTabsCallbackClass = Class.forName("android.support.customtabs.CustomTabsCallback");
            this.CustomTabsSessionClass = Class.forName("android.support.customtabs.CustomTabsSession");
            this.ICustomTabsServiceClass = Class.forName("android.support.customtabs.ICustomTabsService");
        }
        catch (Throwable t) {
            this.isCustomTabsAvailable_ = false;
        }
        this.timeOutHandler_ = new Handler();
    }

    public static BranchStrongMatchHelper getInstance() {
        if (branchStrongMatchHelper_ == null) {
            branchStrongMatchHelper_ = new BranchStrongMatchHelper();
        }
        return branchStrongMatchHelper_;
    }

    public void setStrongMatchUrlHitDelay(int delay) {
        StrongMatchUrlHitDelay = delay;
    }

    public void checkForStrongMatch(Context context, String cookieMatchDomain, DeviceInfo deviceInfo, final PrefHelper prefHelper, SystemObserver systemObserver, final StrongMatchCheckEvents callback) {
        this.isStrongMatchUrlLaunched = false;
        if (System.currentTimeMillis() - prefHelper.getLastStrongMatchTime() < 2592000000L) {
            this.updateStrongMatchCheckFinished(callback, this.isStrongMatchUrlLaunched);
        } else if (!this.isCustomTabsAvailable_) {
            this.updateStrongMatchCheckFinished(callback, this.isStrongMatchUrlLaunched);
        } else {
            try {
                if (deviceInfo.getHardwareID() != null) {
                    final Uri strongMatchUri = this.buildStrongMatchUrl(cookieMatchDomain, deviceInfo, prefHelper, systemObserver, context);
                    if (strongMatchUri != null) {
                        this.timeOutHandler_.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                BranchStrongMatchHelper.this.updateStrongMatchCheckFinished(callback, BranchStrongMatchHelper.this.isStrongMatchUrlLaunched);
                            }
                        }, 500L);
                        Method bindCustomTabsServiceMethod = this.CustomTabsClientClass.getMethod("bindCustomTabsService", Context.class, String.class, this.CustomServiceTabConnectionClass);
                        final Method warmupMethod = this.CustomTabsClientClass.getMethod("warmup", Long.TYPE);
                        final Method newSessionMethod = this.CustomTabsClientClass.getMethod("newSession", this.CustomTabsCallbackClass);
                        final Method mayLaunchUrlMethod = this.CustomTabsSessionClass.getMethod("mayLaunchUrl", Uri.class, Bundle.class, List.class);
                        Intent intent = new Intent("android.support.customtabs.action.CustomTabsService");
                        intent.setPackage("com.android.chrome");
                        context.bindService(intent, (ServiceConnection)new MockCustomTabServiceConnection(){

                            @Override
                            public void onCustomTabsServiceConnected(ComponentName var1, Object clientObj) {
                                BranchStrongMatchHelper.this.mClient_ = BranchStrongMatchHelper.this.CustomTabsClientClass.cast(clientObj);
                                if (BranchStrongMatchHelper.this.mClient_ != null) {
                                    try {
                                        warmupMethod.invoke(BranchStrongMatchHelper.this.mClient_, 0);
                                        Object customTabsSessionObj = newSessionMethod.invoke(BranchStrongMatchHelper.this.mClient_, new Object[]{null});
                                        if (customTabsSessionObj != null) {
                                            PrefHelper.Debug("BranchSDK", "Strong match request " + strongMatchUri);
                                            mayLaunchUrlMethod.invoke(customTabsSessionObj, strongMatchUri, null, null);
                                            prefHelper.saveLastStrongMatchTime(System.currentTimeMillis());
                                            BranchStrongMatchHelper.this.isStrongMatchUrlLaunched = true;
                                        }
                                    }
                                    catch (Throwable t) {
                                        BranchStrongMatchHelper.this.mClient_ = null;
                                        BranchStrongMatchHelper.this.updateStrongMatchCheckFinished(callback, BranchStrongMatchHelper.this.isStrongMatchUrlLaunched);
                                    }
                                }
                            }

                            public void onServiceDisconnected(ComponentName name) {
                                BranchStrongMatchHelper.this.mClient_ = null;
                                BranchStrongMatchHelper.this.updateStrongMatchCheckFinished(callback, BranchStrongMatchHelper.this.isStrongMatchUrlLaunched);
                            }
                        }, 33);
                    } else {
                        this.updateStrongMatchCheckFinished(callback, this.isStrongMatchUrlLaunched);
                    }
                } else {
                    this.updateStrongMatchCheckFinished(callback, this.isStrongMatchUrlLaunched);
                    Log.d((String)"BranchSDK", (String)"Cannot use cookie-based matching since device id is not available");
                }
            }
            catch (Throwable ignore) {
                this.updateStrongMatchCheckFinished(callback, this.isStrongMatchUrlLaunched);
            }
        }
    }

    private void updateStrongMatchCheckFinished(final StrongMatchCheckEvents callback, boolean isStrongMatchUriLaunched) {
        if (callback != null) {
            if (isStrongMatchUriLaunched) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        callback.onStrongMatchCheckFinished();
                    }
                }, (long)StrongMatchUrlHitDelay);
            } else {
                callback.onStrongMatchCheckFinished();
            }
        }
    }

    private Uri buildStrongMatchUrl(String matchDomain, DeviceInfo deviceInfo, PrefHelper prefHelper, SystemObserver systemObserver, Context context) {
        Uri strongMatchUri = null;
        if (!TextUtils.isEmpty((CharSequence)matchDomain)) {
            String uriString = "https://" + matchDomain + "/_strong_match?os=" + deviceInfo.getOsName();
            uriString = uriString + "&" + Defines.Jsonkey.HardwareID.getKey() + "=" + deviceInfo.getHardwareID();
            String hardwareIDTypeVal = deviceInfo.isHardwareIDReal() ? Defines.Jsonkey.HardwareIDTypeVendor.getKey() : Defines.Jsonkey.HardwareIDTypeRandom.getKey();
            uriString = uriString + "&" + Defines.Jsonkey.HardwareIDType.getKey() + "=" + hardwareIDTypeVal;
            if (systemObserver.GAIDString_ != null && !BranchUtil.isTestModeEnabled(context)) {
                uriString = uriString + "&" + Defines.Jsonkey.GoogleAdvertisingID.getKey() + "=" + systemObserver.GAIDString_;
            }
            if (!prefHelper.getDeviceFingerPrintID().equals("bnc_no_value")) {
                uriString = uriString + "&" + Defines.Jsonkey.DeviceFingerprintID.getKey() + "=" + prefHelper.getDeviceFingerPrintID();
            }
            if (!deviceInfo.getAppVersion().equals("bnc_no_value")) {
                uriString = uriString + "&" + Defines.Jsonkey.AppVersion.getKey() + "=" + deviceInfo.getAppVersion();
            }
            if (!prefHelper.getBranchKey().equals("bnc_no_value")) {
                uriString = uriString + "&" + Defines.Jsonkey.BranchKey.getKey() + "=" + prefHelper.getBranchKey();
            }
            uriString = uriString + "&sdk=android2.9.1";
            strongMatchUri = Uri.parse((String)uriString);
        }
        return strongMatchUri;
    }

    static {
        StrongMatchUrlHitDelay = 750;
    }

    private abstract class MockCustomTabServiceConnection
    implements ServiceConnection {
        public final void onServiceConnected(ComponentName name, IBinder service) {
            try {
                Constructor<?> customTabClientConstructor = BranchStrongMatchHelper.this.CustomTabsClientClass.getDeclaredConstructor(BranchStrongMatchHelper.this.ICustomTabsServiceClass, ComponentName.class);
                customTabClientConstructor.setAccessible(true);
                Class<?> ICustomTabServiceStubClass = Class.forName("android.support.customtabs.ICustomTabsService$Stub");
                Method asInterfaceMethod = ICustomTabServiceStubClass.getMethod("asInterface", IBinder.class);
                Object customTabClientObject = customTabClientConstructor.newInstance(asInterfaceMethod.invoke(null, service), name);
                this.onCustomTabsServiceConnected(name, customTabClientObject);
            }
            catch (Throwable t) {
                this.onCustomTabsServiceConnected(null, null);
            }
        }

        public abstract void onCustomTabsServiceConnected(ComponentName var1, Object var2);
    }

    static interface StrongMatchCheckEvents {
        public void onStrongMatchCheckFinished();
    }
}

