/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

public class BranchError {
    String errorMessage_ = "";
    int errorCode_ = -113;
    public static final int ERR_NO_SESSION = -101;
    public static final int ERR_NO_INTERNET_PERMISSION = -102;
    public static final int ERR_INVALID_REFERRAL_CODE = -103;
    public static final int ERR_BRANCH_INIT_FAILED = -104;
    public static final int ERR_BRANCH_DUPLICATE_URL = -105;
    public static final int ERR_BRANCH_DUPLICATE_REFERRAL_CODE = -106;
    public static final int ERR_BRANCH_REDEEM_REWARD = -107;
    public static final int ERR_API_LVL_14_NEEDED = -108;
    public static final int ERR_BRANCH_NOT_INSTANTIATED = -109;
    public static final int ERR_BRANCH_NO_SHARE_OPTION = -110;
    public static final int ERR_BRANCH_REQ_TIMED_OUT = -111;
    public static final int ERR_BRANCH_UNABLE_TO_REACH_SERVERS = -112;
    public static final int ERR_BRANCH_NO_CONNECTIVITY = -113;
    public static final int ERR_BRANCH_KEY_INVALID = -114;
    public static final int ERR_BRANCH_RESOURCE_CONFLICT = -115;
    public static final int ERR_BRANCH_INVALID_REQUEST = -116;

    public String getMessage() {
        return this.errorMessage_;
    }

    public int getErrorCode() {
        return this.errorCode_;
    }

    public String toString() {
        return this.getMessage();
    }

    public BranchError(String failMsg, int statusCode) {
        this.errorMessage_ = failMsg + this.initErrorCodeAndGetLocalisedMessage(statusCode);
    }

    private String initErrorCodeAndGetLocalisedMessage(int statusCode) {
        String errMsg;
        if (statusCode == -113) {
            this.errorCode_ = -113;
            errMsg = " Branch API Error: poor network connectivity. Please try again later.";
        } else if (statusCode == -114) {
            this.errorCode_ = -114;
            errMsg = " Branch API Error: Please enter your branch_key in your project's manifest file first.";
        } else if (statusCode == -104) {
            this.errorCode_ = -104;
            errMsg = " Did you forget to call init? Make sure you init the session before making Branch calls.";
        } else if (statusCode == -101) {
            this.errorCode_ = -101;
            errMsg = " Unable to initialize Branch. Check network connectivity or that your branch key is valid.";
        } else if (statusCode == -102) {
            this.errorCode_ = -102;
            errMsg = " Please add 'android.permission.INTERNET' in your applications manifest file.";
        } else if (statusCode == -105) {
            this.errorCode_ = -105;
            errMsg = " Unable to create a URL with that alias. If you want to reuse the alias, make sure to submit the same properties for all arguments and that the user is the same owner.";
        } else if (statusCode == -106) {
            this.errorCode_ = -106;
            errMsg = " That Branch referral code is already in use.";
        } else if (statusCode == -107) {
            this.errorCode_ = -107;
            errMsg = " Unable to redeem rewards. Please make sure you have credits available to redeem.";
        } else if (statusCode == -108) {
            this.errorCode_ = -108;
            errMsg = "BranchApp class can be used only with API level 14 or above. Please make sure your minimum API level supported is 14. If you wish to use API level below 14 consider calling getInstance(Context) instead.";
        } else if (statusCode == -109) {
            this.errorCode_ = -109;
            errMsg = "Branch instance is not created. Make  sure your Application class is an instance of BranchLikedApp.";
        } else if (statusCode == -110) {
            this.errorCode_ = -110;
            errMsg = " Unable create share options. Couldn't find applications on device to share the link.";
        } else if (statusCode == -111) {
            this.errorCode_ = -111;
            errMsg = " Request to Branch server timed out. Please check your internet connectivity";
        } else if (statusCode >= 500 || statusCode == -112) {
            this.errorCode_ = -112;
            errMsg = " Unable to reach the Branch servers, please try again shortly.";
        } else if (statusCode == 409 || statusCode == -115) {
            this.errorCode_ = -115;
            errMsg = " A resource with this identifier already exists.";
        } else if (statusCode >= 400 || statusCode == -116) {
            this.errorCode_ = -116;
            errMsg = " The request was invalid.";
        } else {
            this.errorCode_ = -113;
            errMsg = " Check network connectivity and that you properly initialized.";
        }
        return errMsg;
    }
}

