/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.View;
import io.branch.indexing.BranchUniversalObject;
import io.branch.indexing.ContentDiscoverer;
import io.branch.referral.Base64;
import io.branch.referral.BranchAsyncTask;
import io.branch.referral.BranchError;
import io.branch.referral.BranchLinkData;
import io.branch.referral.BranchShortLinkBuilder;
import io.branch.referral.BranchStrongMatchHelper;
import io.branch.referral.BranchUniversalReferralInitWrapper;
import io.branch.referral.BranchUtil;
import io.branch.referral.BranchViewHandler;
import io.branch.referral.DeferredAppLinkDataHandler;
import io.branch.referral.Defines;
import io.branch.referral.DeviceInfo;
import io.branch.referral.InstallListener;
import io.branch.referral.PrefHelper;
import io.branch.referral.ServerRequest;
import io.branch.referral.ServerRequestActionCompleted;
import io.branch.referral.ServerRequestCreateUrl;
import io.branch.referral.ServerRequestGetRewardHistory;
import io.branch.referral.ServerRequestGetRewards;
import io.branch.referral.ServerRequestIdentifyUserRequest;
import io.branch.referral.ServerRequestInitSession;
import io.branch.referral.ServerRequestLogout;
import io.branch.referral.ServerRequestQueue;
import io.branch.referral.ServerRequestRActionCompleted;
import io.branch.referral.ServerRequestRedeemRewards;
import io.branch.referral.ServerRequestRegisterClose;
import io.branch.referral.ServerRequestRegisterInstall;
import io.branch.referral.ServerRequestRegisterOpen;
import io.branch.referral.ServerRequestRegisterView;
import io.branch.referral.ServerRequestSendAppList;
import io.branch.referral.ServerResponse;
import io.branch.referral.ShareLinkManager;
import io.branch.referral.SharingHelper;
import io.branch.referral.SystemObserver;
import io.branch.referral.network.BranchRemoteInterface;
import io.branch.referral.util.CommerceEvent;
import io.branch.referral.util.LinkProperties;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Branch
implements BranchViewHandler.IBranchViewEvents,
SystemObserver.GAdsParamsFetchEvents,
InstallListener.IInstallReferrerEvents {
    private static final String TAG = "BranchSDK";
    public static final String FEATURE_TAG_SHARE = "share";
    public static final String FEATURE_TAG_REFERRAL = "referral";
    public static final String FEATURE_TAG_INVITE = "invite";
    public static final String FEATURE_TAG_DEAL = "deal";
    public static final String FEATURE_TAG_GIFT = "gift";
    public static final String REDEEM_CODE = "$redeem_code";
    public static final String REFERRAL_BUCKET_DEFAULT = "default";
    public static final String REFERRAL_CODE_TYPE = "credit";
    public static final int REFERRAL_CREATION_SOURCE_SDK = 2;
    public static final String REFERRAL_CODE = "referral_code";
    public static final String REDIRECT_DESKTOP_URL = "$desktop_url";
    public static final String REDIRECT_ANDROID_URL = "$android_url";
    public static final String REDIRECT_IOS_URL = "$ios_url";
    public static final String REDIRECT_IPAD_URL = "$ipad_url";
    public static final String REDIRECT_FIRE_URL = "$fire_url";
    public static final String REDIRECT_BLACKBERRY_URL = "$blackberry_url";
    public static final String REDIRECT_WINDOWS_PHONE_URL = "$windows_phone_url";
    public static final String OG_TITLE = "$og_title";
    public static final String OG_DESC = "$og_description";
    public static final String OG_IMAGE_URL = "$og_image_url";
    public static final String OG_VIDEO = "$og_video";
    public static final String OG_URL = "$og_url";
    public static final String OG_APP_ID = "$og_app_id";
    public static final String DEEPLINK_PATH = "$deeplink_path";
    public static final String ALWAYS_DEEPLINK = "$always_deeplink";
    public static final int REFERRAL_CODE_LOCATION_REFERREE = 0;
    public static final int REFERRAL_CODE_LOCATION_REFERRING_USER = 2;
    public static final int REFERRAL_CODE_LOCATION_BOTH = 3;
    public static final int REFERRAL_CODE_AWARD_UNLIMITED = 1;
    public static final int REFERRAL_CODE_AWARD_UNIQUE = 0;
    public static final int LINK_TYPE_UNLIMITED_USE = 0;
    public static final int LINK_TYPE_ONE_TIME_USE = 1;
    private static final int SESSION_KEEPALIVE = 2000;
    private static final int PREVENT_CLOSE_TIMEOUT = 500;
    private JSONObject deeplinkDebugParams_;
    private static boolean disableDeviceIDFetch_;
    private boolean enableFacebookAppLinkCheck_ = false;
    private static boolean isSimulatingInstalls_;
    private static boolean isLogging_;
    private static boolean checkInstallReferrer_;
    private static long PLAYSTORE_REFERRAL_FETCH_WAIT_FOR;
    private static Branch branchReferral_;
    private BranchRemoteInterface branchRemoteInterface_;
    private PrefHelper prefHelper_;
    private final SystemObserver systemObserver_;
    private Context context_;
    final Object lock;
    private Semaphore serverSema_;
    private ServerRequestQueue requestQueue_;
    private int networkCount_;
    private boolean hasNetwork_;
    private Map<BranchLinkData, String> linkCache_;
    private ScheduledFuture<?> appListingSchedule_;
    private static boolean isAutoSessionMode_;
    private static boolean isActivityLifeCycleCallbackRegistered_;
    private INTENT_STATE intentState_ = INTENT_STATE.PENDING;
    private boolean handleDelayedNewIntents_ = false;
    private SESSION_STATE initState_ = SESSION_STATE.UNINITIALISED;
    private ShareLinkManager shareLinkManager_;
    WeakReference<Activity> currentActivityReference_;
    private static CUSTOM_REFERRABLE_SETTINGS customReferrableSettings_;
    private static final String AUTO_DEEP_LINKED = "io.branch.sdk.auto_linked";
    private static final String AUTO_DEEP_LINK_KEY = "io.branch.sdk.auto_link_keys";
    private static final String AUTO_DEEP_LINK_PATH = "io.branch.sdk.auto_link_path";
    private static final String AUTO_DEEP_LINK_DISABLE = "io.branch.sdk.auto_link_disable";
    private static final String AUTO_DEEP_LINK_REQ_CODE = "io.branch.sdk.auto_link_request_code";
    private static final int DEF_AUTO_DEEP_LINK_REQ_CODE = 1501;
    private boolean isInitReportedThroughCallBack = false;
    private final ConcurrentHashMap<String, String> instrumentationExtraData_;
    private static final String FABRIC_BRANCH_API_KEY = "io.branch.apiKey";
    private boolean isGAParamsFetchInProgress_ = false;
    private List<String> externalUriWhiteList_;
    private List<String> skipExternalUriHosts_;
    String sessionReferredLink_;
    private static String cookieBasedMatchDomain_;
    private static int LATCH_WAIT_UNTIL;
    private static final String[] EXTERNAL_INTENT_EXTRA_KEY_WHITE_LIST;
    private CountDownLatch getFirstReferringParamsLatch = null;
    private CountDownLatch getLatestReferringParamsLatch = null;
    private boolean performCookieBasedStrongMatchingOnGAIDAvailable = false;
    private static Context lastApplicationContext;
    private static Boolean isInstantApp;

    private Branch(@NonNull Context context) {
        this.prefHelper_ = PrefHelper.getInstance(context);
        this.branchRemoteInterface_ = BranchRemoteInterface.getDefaultBranchRemoteInterface(context);
        this.systemObserver_ = new SystemObserver(context);
        this.requestQueue_ = ServerRequestQueue.getInstance(context);
        this.serverSema_ = new Semaphore(1);
        this.lock = new Object();
        this.networkCount_ = 0;
        this.hasNetwork_ = true;
        this.linkCache_ = new HashMap<BranchLinkData, String>();
        this.instrumentationExtraData_ = new ConcurrentHashMap();
        this.isGAParamsFetchInProgress_ = this.systemObserver_.prefetchGAdsParams(this);
        InstallListener.setListener(this);
        if (Build.VERSION.SDK_INT >= 15) {
            this.handleDelayedNewIntents_ = true;
            this.intentState_ = INTENT_STATE.PENDING;
        } else {
            this.handleDelayedNewIntents_ = false;
            this.intentState_ = INTENT_STATE.READY;
        }
        this.externalUriWhiteList_ = new ArrayList<String>();
        this.skipExternalUriHosts_ = new ArrayList<String>();
    }

    public void setBranchRemoteInterface(BranchRemoteInterface remoteInterface) {
        this.branchRemoteInterface_ = remoteInterface;
    }

    public static void enableTestMode() {
        BranchUtil.isCustomDebugEnabled_ = true;
    }

    public static void disableTestMode() {
        BranchUtil.isCustomDebugEnabled_ = false;
    }

    public void setDebug() {
        Branch.enableTestMode();
    }

    public static void enablePlayStoreReferrer(long delay) {
        checkInstallReferrer_ = true;
        PLAYSTORE_REFERRAL_FETCH_WAIT_FOR = delay;
    }

    static boolean checkPlayStoreReferrer() {
        return checkInstallReferrer_;
    }

    public static long getReferralFetchWaitTime() {
        return PLAYSTORE_REFERRAL_FETCH_WAIT_FOR;
    }

    @TargetApi(value=14)
    public static Branch getInstance() {
        if (branchReferral_ == null) {
            Log.e((String)TAG, (String)"Branch instance is not created yet. Make sure you have initialised Branch. [Consider Calling getInstance(Context ctx) if you still have issue.]");
        } else if (isAutoSessionMode_ && !isActivityLifeCycleCallbackRegistered_) {
            Log.e((String)TAG, (String)"Branch instance is not properly initialised. Make sure your Application class is extending BranchApp class. If you are not extending BranchApp class make sure you are initialising Branch in your Applications onCreate()");
        }
        return branchReferral_;
    }

    public static Branch getInstance(@NonNull Context context, @NonNull String branchKey) {
        if (branchReferral_ == null) {
            branchReferral_ = Branch.initInstance(context);
        }
        Branch.branchReferral_.context_ = context.getApplicationContext();
        if (branchKey.startsWith("key_")) {
            boolean isNewBranchKeySet = Branch.branchReferral_.prefHelper_.setBranchKey(branchKey);
            if (isNewBranchKeySet) {
                Branch.branchReferral_.linkCache_.clear();
                Branch.branchReferral_.requestQueue_.clear();
            }
        } else {
            Log.e((String)TAG, (String)"Branch Key is invalid.Please check your BranchKey");
        }
        return branchReferral_;
    }

    private static Branch getBranchInstance(@NonNull Context context, boolean isLive) {
        if (branchReferral_ == null) {
            boolean isNewBranchKeySet;
            branchReferral_ = Branch.initInstance(context);
            String branchKey = Branch.branchReferral_.prefHelper_.readBranchKey(isLive);
            if (branchKey == null || branchKey.equalsIgnoreCase("bnc_no_value")) {
                String fabricBranchApiKey = null;
                try {
                    Resources resources = context.getResources();
                    fabricBranchApiKey = resources.getString(resources.getIdentifier(FABRIC_BRANCH_API_KEY, "string", context.getPackageName()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!TextUtils.isEmpty(fabricBranchApiKey)) {
                    isNewBranchKeySet = Branch.branchReferral_.prefHelper_.setBranchKey(fabricBranchApiKey);
                } else {
                    Log.i((String)TAG, (String)"Branch Warning: Please enter your branch_key in your project's Manifest file!");
                    isNewBranchKeySet = Branch.branchReferral_.prefHelper_.setBranchKey("bnc_no_value");
                }
            } else {
                isNewBranchKeySet = Branch.branchReferral_.prefHelper_.setBranchKey(branchKey);
            }
            if (isNewBranchKeySet) {
                Branch.branchReferral_.linkCache_.clear();
                Branch.branchReferral_.requestQueue_.clear();
            }
            Branch.branchReferral_.context_ = context.getApplicationContext();
            if (context instanceof Application) {
                isAutoSessionMode_ = true;
                branchReferral_.setActivityLifeCycleObserver((Application)context);
            }
        }
        return branchReferral_;
    }

    public static Branch getInstance(@NonNull Context context) {
        return Branch.getBranchInstance(context, true);
    }

    public static Branch getTestInstance(@NonNull Context context) {
        return Branch.getBranchInstance(context, false);
    }

    @TargetApi(value=14)
    public static Branch getAutoInstance(@NonNull Context context) {
        isAutoSessionMode_ = true;
        customReferrableSettings_ = CUSTOM_REFERRABLE_SETTINGS.USE_DEFAULT;
        boolean isLive = !BranchUtil.isTestModeEnabled(context);
        Branch.getBranchInstance(context, isLive);
        return branchReferral_;
    }

    @TargetApi(value=14)
    public static Branch getAutoInstance(@NonNull Context context, boolean isReferrable) {
        isAutoSessionMode_ = true;
        customReferrableSettings_ = isReferrable ? CUSTOM_REFERRABLE_SETTINGS.REFERRABLE : CUSTOM_REFERRABLE_SETTINGS.NON_REFERRABLE;
        boolean isDebug = BranchUtil.isTestModeEnabled(context);
        Branch.getBranchInstance(context, !isDebug);
        return branchReferral_;
    }

    @TargetApi(value=14)
    public static Branch getAutoInstance(@NonNull Context context, @NonNull String branchKey) {
        isAutoSessionMode_ = true;
        customReferrableSettings_ = CUSTOM_REFERRABLE_SETTINGS.USE_DEFAULT;
        boolean isLive = !BranchUtil.isTestModeEnabled(context);
        Branch.getBranchInstance(context, isLive);
        if (branchKey.startsWith("key_")) {
            boolean isNewBranchKeySet = Branch.branchReferral_.prefHelper_.setBranchKey(branchKey);
            if (isNewBranchKeySet) {
                Branch.branchReferral_.linkCache_.clear();
                Branch.branchReferral_.requestQueue_.clear();
            }
        } else {
            Log.e((String)TAG, (String)"Branch Key is invalid.Please check your BranchKey");
        }
        return branchReferral_;
    }

    @TargetApi(value=14)
    public static Branch getAutoTestInstance(@NonNull Context context) {
        isAutoSessionMode_ = true;
        customReferrableSettings_ = CUSTOM_REFERRABLE_SETTINGS.USE_DEFAULT;
        Branch.getBranchInstance(context, false);
        return branchReferral_;
    }

    @TargetApi(value=14)
    public static Branch getAutoTestInstance(@NonNull Context context, boolean isReferrable) {
        isAutoSessionMode_ = true;
        customReferrableSettings_ = isReferrable ? CUSTOM_REFERRABLE_SETTINGS.REFERRABLE : CUSTOM_REFERRABLE_SETTINGS.NON_REFERRABLE;
        Branch.getBranchInstance(context, false);
        return branchReferral_;
    }

    private static Branch initInstance(@NonNull Context context) {
        return new Branch(context.getApplicationContext());
    }

    public void resetUserSession() {
        this.initState_ = SESSION_STATE.UNINITIALISED;
    }

    public void setRetryCount(int retryCount) {
        if (this.prefHelper_ != null && retryCount >= 0) {
            this.prefHelper_.setRetryCount(retryCount);
        }
    }

    public void setRetryInterval(int retryInterval) {
        if (this.prefHelper_ != null && retryInterval > 0) {
            this.prefHelper_.setRetryInterval(retryInterval);
        }
    }

    public void setNetworkTimeout(int timeout) {
        if (this.prefHelper_ != null && timeout > 0) {
            this.prefHelper_.setTimeout(timeout);
        }
    }

    public static void disableDeviceIDFetch(Boolean deviceIdFetch) {
        disableDeviceIDFetch_ = deviceIdFetch;
    }

    public static boolean isDeviceIDFetchDisabled() {
        return disableDeviceIDFetch_;
    }

    public void setDeepLinkDebugMode(JSONObject debugParams) {
        this.deeplinkDebugParams_ = debugParams;
    }

    public void disableAppList() {
        this.prefHelper_.disableExternAppListing();
    }

    public void enableFacebookAppLinkCheck() {
        this.enableFacebookAppLinkCheck_ = true;
    }

    public void setRequestMetadata(@NonNull String key, @NonNull String value) {
        this.prefHelper_.setRequestMetadata(key, value);
    }

    public boolean initSession(BranchUniversalReferralInitListener callback) {
        return this.initSession(callback, (Activity)null);
    }

    public boolean initSession(BranchReferralInitListener callback) {
        return this.initSession(callback, (Activity)null);
    }

    public boolean initSession(BranchUniversalReferralInitListener callback, Activity activity) {
        if (customReferrableSettings_ == CUSTOM_REFERRABLE_SETTINGS.USE_DEFAULT) {
            this.initUserSessionInternal(callback, activity, true);
        } else {
            boolean isReferrable = customReferrableSettings_ == CUSTOM_REFERRABLE_SETTINGS.REFERRABLE;
            this.initUserSessionInternal(callback, activity, isReferrable);
        }
        return true;
    }

    public boolean initSession(BranchReferralInitListener callback, Activity activity) {
        if (customReferrableSettings_ == CUSTOM_REFERRABLE_SETTINGS.USE_DEFAULT) {
            this.initUserSessionInternal(callback, activity, true);
        } else {
            boolean isReferrable = customReferrableSettings_ == CUSTOM_REFERRABLE_SETTINGS.REFERRABLE;
            this.initUserSessionInternal(callback, activity, isReferrable);
        }
        return true;
    }

    public boolean initSession(BranchUniversalReferralInitListener callback, @NonNull Uri data) {
        return this.initSession(callback, data, null);
    }

    public boolean initSession(BranchReferralInitListener callback, @NonNull Uri data) {
        return this.initSession(callback, data, null);
    }

    public boolean initSession(BranchUniversalReferralInitListener callback, @NonNull Uri data, Activity activity) {
        this.readAndStripParam(data, activity);
        this.initSession(callback, activity);
        return true;
    }

    public boolean initSession(BranchReferralInitListener callback, @NonNull Uri data, Activity activity) {
        this.readAndStripParam(data, activity);
        return this.initSession(callback, activity);
    }

    public boolean initSession() {
        return this.initSession((Activity)null);
    }

    public boolean initSession(Activity activity) {
        return this.initSession((BranchReferralInitListener)null, activity);
    }

    public boolean initSessionWithData(@NonNull Uri data) {
        return this.initSessionWithData(data, null);
    }

    public boolean initSessionWithData(Uri data, Activity activity) {
        this.readAndStripParam(data, activity);
        return this.initSession((BranchReferralInitListener)null, activity);
    }

    public boolean initSession(boolean isReferrable) {
        return this.initSession((BranchReferralInitListener)null, isReferrable, (Activity)null);
    }

    public boolean initSession(boolean isReferrable, @NonNull Activity activity) {
        return this.initSession((BranchReferralInitListener)null, isReferrable, activity);
    }

    public boolean initSession(BranchUniversalReferralInitListener callback, boolean isReferrable, Uri data) {
        return this.initSession(callback, isReferrable, data, null);
    }

    public boolean initSession(BranchReferralInitListener callback, boolean isReferrable, @NonNull Uri data) {
        return this.initSession(callback, isReferrable, data, null);
    }

    public boolean initSession(BranchUniversalReferralInitListener callback, boolean isReferrable, @NonNull Uri data, Activity activity) {
        this.readAndStripParam(data, activity);
        return this.initSession(callback, isReferrable, activity);
    }

    public boolean initSession(BranchReferralInitListener callback, boolean isReferrable, @NonNull Uri data, Activity activity) {
        this.readAndStripParam(data, activity);
        return this.initSession(callback, isReferrable, activity);
    }

    public boolean initSession(BranchUniversalReferralInitListener callback, boolean isReferrable) {
        return this.initSession(callback, isReferrable, (Activity)null);
    }

    public boolean initSession(BranchReferralInitListener callback, boolean isReferrable) {
        return this.initSession(callback, isReferrable, (Activity)null);
    }

    public boolean initSession(BranchUniversalReferralInitListener callback, boolean isReferrable, Activity activity) {
        this.initUserSessionInternal(callback, activity, isReferrable);
        return true;
    }

    public boolean initSession(BranchReferralInitListener callback, boolean isReferrable, Activity activity) {
        this.initUserSessionInternal(callback, activity, isReferrable);
        return true;
    }

    private void initUserSessionInternal(BranchUniversalReferralInitListener callback, Activity activity, boolean isReferrable) {
        BranchUniversalReferralInitWrapper branchUniversalReferralInitWrapper = new BranchUniversalReferralInitWrapper(callback);
        this.initUserSessionInternal(branchUniversalReferralInitWrapper, activity, isReferrable);
    }

    private void initUserSessionInternal(BranchReferralInitListener callback, Activity activity, boolean isReferrable) {
        if (activity != null) {
            this.currentActivityReference_ = new WeakReference<Activity>(activity);
        }
        if (this.hasUser() && this.hasSession() && this.initState_ == SESSION_STATE.INITIALISED) {
            if (callback != null) {
                if (isAutoSessionMode_) {
                    if (!this.isInitReportedThroughCallBack) {
                        callback.onInitFinished(this.getLatestReferringParams(), null);
                        this.isInitReportedThroughCallBack = true;
                    } else {
                        callback.onInitFinished(new JSONObject(), null);
                    }
                } else {
                    callback.onInitFinished(new JSONObject(), null);
                }
            }
        } else {
            if (isReferrable) {
                this.prefHelper_.setIsReferrable();
            } else {
                this.prefHelper_.clearIsReferrable();
            }
            if (this.initState_ == SESSION_STATE.INITIALISING) {
                if (callback != null) {
                    this.requestQueue_.setInstallOrOpenCallback(callback);
                }
            } else {
                this.initState_ = SESSION_STATE.INITIALISING;
                this.initializeSession(callback);
            }
        }
    }

    public void closeSession() {
        Log.w((String)TAG, (String)"closeSession() method is deprecated from SDK v1.14.6.Session is  automatically handled by Branch.In case you need to handle sessions manually inorder to support minimum sdk version less than 14 please consider using  SDK version 1.14.5");
    }

    private void closeSessionInternal() {
        this.executeClose();
        this.sessionReferredLink_ = null;
        if (this.prefHelper_.getExternAppListing() && this.appListingSchedule_ == null) {
            this.scheduleListOfApps();
        }
    }

    public static void enableCookieBasedMatching(String cookieMatchDomain) {
        cookieBasedMatchDomain_ = cookieMatchDomain;
    }

    public static void enableCookieBasedMatching(String cookieMatchDomain, int delay) {
        cookieBasedMatchDomain_ = cookieMatchDomain;
        BranchStrongMatchHelper.getInstance().setStrongMatchUrlHitDelay(delay);
    }

    private void executeClose() {
        if (this.initState_ != SESSION_STATE.UNINITIALISED) {
            if (!this.hasNetwork_) {
                ServerRequest req = this.requestQueue_.peek();
                if (req != null && req instanceof ServerRequestRegisterInstall || req instanceof ServerRequestRegisterOpen) {
                    this.requestQueue_.dequeue();
                }
            } else if (!this.requestQueue_.containsClose()) {
                ServerRequestRegisterClose req = new ServerRequestRegisterClose(this.context_);
                this.handleNewRequest(req);
            }
            this.initState_ = SESSION_STATE.UNINITIALISED;
        }
    }

    private boolean readAndStripParam(Uri data, Activity activity) {
        if (this.intentState_ == INTENT_STATE.READY) {
            try {
                if (data != null) {
                    boolean skipThisHost = false;
                    boolean foundSchemeMatch = this.externalUriWhiteList_.size() > 0 ? this.externalUriWhiteList_.contains(data.getScheme()) : true;
                    if (this.skipExternalUriHosts_.size() > 0) {
                        for (String host : this.skipExternalUriHosts_) {
                            String externalHost = data.getHost();
                            if (externalHost == null || !externalHost.equals(host)) continue;
                            skipThisHost = true;
                            break;
                        }
                    }
                    if (foundSchemeMatch && !skipThisHost) {
                        Bundle bundle;
                        Set extraKeys;
                        this.sessionReferredLink_ = data.toString();
                        this.prefHelper_.setExternalIntentUri(data.toString());
                        if (activity != null && activity.getIntent() != null && activity.getIntent().getExtras() != null && (extraKeys = (bundle = activity.getIntent().getExtras()).keySet()).size() > 0) {
                            JSONObject extrasJson = new JSONObject();
                            for (String key : EXTERNAL_INTENT_EXTRA_KEY_WHITE_LIST) {
                                if (!extraKeys.contains(key)) continue;
                                extrasJson.put(key, bundle.get(key));
                            }
                            if (extrasJson.length() > 0) {
                                this.prefHelper_.setExternalIntentExtra(extrasJson.toString());
                            }
                        }
                    }
                }
            }
            catch (Exception foundSchemeMatch) {
                // empty catch block
            }
            try {
                String pushIdentifier;
                if (activity != null && activity.getIntent() != null && activity.getIntent().getExtras() != null && !activity.getIntent().getExtras().getBoolean(Defines.Jsonkey.BranchLinkUsed.getKey()) && (pushIdentifier = activity.getIntent().getExtras().getString(Defines.Jsonkey.AndroidPushNotificationKey.getKey())) != null && pushIdentifier.length() > 0) {
                    this.prefHelper_.setPushIdentifier(pushIdentifier);
                    Intent thisIntent = activity.getIntent();
                    thisIntent.putExtra(Defines.Jsonkey.BranchLinkUsed.getKey(), true);
                    activity.setIntent(thisIntent);
                    return false;
                }
            }
            catch (Exception pushIdentifier) {
                // empty catch block
            }
            if (data != null && data.isHierarchical() && activity != null) {
                try {
                    if (data.getQueryParameter(Defines.Jsonkey.LinkClickID.getKey()) != null) {
                        this.prefHelper_.setLinkClickIdentifier(data.getQueryParameter(Defines.Jsonkey.LinkClickID.getKey()));
                        String paramString = "link_click_id=" + data.getQueryParameter(Defines.Jsonkey.LinkClickID.getKey());
                        String uriString = null;
                        if (activity.getIntent() != null) {
                            uriString = activity.getIntent().getDataString();
                        }
                        paramString = data.getQuery().length() == paramString.length() ? "\\?" + paramString : (uriString != null && uriString.length() - paramString.length() == uriString.indexOf(paramString) ? "&" + paramString : paramString + "&");
                        if (uriString != null) {
                            Uri newData = Uri.parse((String)uriString.replaceFirst(paramString, ""));
                            activity.getIntent().setData(newData);
                        } else {
                            Log.w((String)TAG, (String)"Branch Warning. URI for the launcher activity is null. Please make sure that intent data is not set to null before calling Branch#InitSession ");
                        }
                        return true;
                    }
                    String scheme = data.getScheme();
                    Intent intent = activity.getIntent();
                    if (scheme != null && intent != null && (intent.getFlags() & 0x100000) == 0 && (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https")) && data.getHost() != null && data.getHost().length() > 0 && !intent.getBooleanExtra(Defines.Jsonkey.BranchLinkUsed.getKey(), false)) {
                        this.prefHelper_.setAppLink(data.toString());
                        intent.putExtra(Defines.Jsonkey.BranchLinkUsed.getKey(), true);
                        activity.setIntent(intent);
                        return false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public void onGAdsFetchFinished() {
        this.isGAParamsFetchInProgress_ = false;
        this.requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.GAID_FETCH_WAIT_LOCK);
        if (this.performCookieBasedStrongMatchingOnGAIDAvailable) {
            this.performCookieBasedStrongMatch();
            this.performCookieBasedStrongMatchingOnGAIDAvailable = false;
        } else {
            this.processNextQueueItem();
        }
    }

    @Override
    public void onInstallReferrerEventsFinished() {
        this.requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.INSTALL_REFERRER_FETCH_WAIT_LOCK);
        this.processNextQueueItem();
    }

    public Branch addWhiteListedScheme(String uriScheme) {
        if (uriScheme == null) {
            return this;
        }
        uriScheme = uriScheme.replace("://", "");
        this.externalUriWhiteList_.add(uriScheme);
        return this;
    }

    public Branch setWhiteListedSchemes(List<String> uriSchemes) {
        this.externalUriWhiteList_ = uriSchemes;
        return this;
    }

    public Branch addUriHostsToSkip(String hostName) {
        if (hostName != null && !hostName.equals("")) {
            this.skipExternalUriHosts_.add(hostName);
        }
        return this;
    }

    public void setIdentity(@NonNull String userId) {
        this.setIdentity(userId, null);
    }

    public void setIdentity(@NonNull String userId, @Nullable BranchReferralInitListener callback) {
        ServerRequestIdentifyUserRequest req = new ServerRequestIdentifyUserRequest(this.context_, callback, userId);
        if (!req.constructError_ && !((ServerRequest)req).handleErrors(this.context_)) {
            this.handleNewRequest(req);
        } else if (req.isExistingID()) {
            req.handleUserExist(branchReferral_);
        }
    }

    public boolean isUserIdentified() {
        return !this.prefHelper_.getIdentity().equals("bnc_no_value");
    }

    public void logout() {
        this.logout(null);
    }

    public void logout(LogoutStatusListener callback) {
        ServerRequestLogout req = new ServerRequestLogout(this.context_, callback);
        if (!req.constructError_ && !((ServerRequest)req).handleErrors(this.context_)) {
            this.handleNewRequest(req);
        }
    }

    public void loadRewards() {
        this.loadRewards(null);
    }

    public void loadRewards(BranchReferralStateChangedListener callback) {
        ServerRequestGetRewards req = new ServerRequestGetRewards(this.context_, callback);
        if (!req.constructError_ && !((ServerRequest)req).handleErrors(this.context_)) {
            this.handleNewRequest(req);
        }
    }

    public int getCredits() {
        return this.prefHelper_.getCreditCount();
    }

    public int getCreditsForBucket(String bucket) {
        return this.prefHelper_.getCreditCount(bucket);
    }

    public void redeemRewards(int count) {
        this.redeemRewards(Defines.Jsonkey.DefaultBucket.getKey(), count, null);
    }

    public void redeemRewards(int count, BranchReferralStateChangedListener callback) {
        this.redeemRewards(Defines.Jsonkey.DefaultBucket.getKey(), count, callback);
    }

    public void redeemRewards(@NonNull String bucket, int count) {
        this.redeemRewards(bucket, count, null);
    }

    public void redeemRewards(@NonNull String bucket, int count, BranchReferralStateChangedListener callback) {
        ServerRequestRedeemRewards req = new ServerRequestRedeemRewards(this.context_, bucket, count, callback);
        if (!req.constructError_ && !req.handleErrors(this.context_)) {
            this.handleNewRequest(req);
        }
    }

    public void getCreditHistory(BranchListResponseListener callback) {
        this.getCreditHistory(null, null, 100, CreditHistoryOrder.kMostRecentFirst, callback);
    }

    public void getCreditHistory(@NonNull String bucket, BranchListResponseListener callback) {
        this.getCreditHistory(bucket, null, 100, CreditHistoryOrder.kMostRecentFirst, callback);
    }

    public void getCreditHistory(@NonNull String afterId, int length, @NonNull CreditHistoryOrder order, BranchListResponseListener callback) {
        this.getCreditHistory(null, afterId, length, order, callback);
    }

    public void getCreditHistory(String bucket, String afterId, int length, @NonNull CreditHistoryOrder order, BranchListResponseListener callback) {
        ServerRequestGetRewardHistory req = new ServerRequestGetRewardHistory(this.context_, bucket, afterId, length, order, callback);
        if (!req.constructError_ && !((ServerRequest)req).handleErrors(this.context_)) {
            this.handleNewRequest(req);
        }
    }

    public void userCompletedAction(@NonNull String action, JSONObject metadata) {
        this.userCompletedAction(action, metadata, null);
    }

    public void userCompletedAction(String action) {
        this.userCompletedAction(action, null, null);
    }

    public void userCompletedAction(String action, BranchViewHandler.IBranchViewEvents callback) {
        this.userCompletedAction(action, null, callback);
    }

    public void userCompletedAction(@NonNull String action, JSONObject metadata, BranchViewHandler.IBranchViewEvents callback) {
        if (metadata != null) {
            metadata = BranchUtil.filterOutBadCharacters(metadata);
        }
        ServerRequestActionCompleted req = new ServerRequestActionCompleted(this.context_, action, metadata, callback);
        if (!req.constructError_ && !((ServerRequest)req).handleErrors(this.context_)) {
            this.handleNewRequest(req);
        }
    }

    public void sendCommerceEvent(@NonNull CommerceEvent commerceEvent, JSONObject metadata, BranchViewHandler.IBranchViewEvents callback) {
        if (metadata != null) {
            metadata = BranchUtil.filterOutBadCharacters(metadata);
        }
        ServerRequestRActionCompleted req = new ServerRequestRActionCompleted(this.context_, commerceEvent, metadata, callback);
        if (!req.constructError_ && !((ServerRequest)req).handleErrors(this.context_)) {
            this.handleNewRequest(req);
        }
    }

    public void sendCommerceEvent(@NonNull CommerceEvent commerceEvent) {
        this.sendCommerceEvent(commerceEvent, null, null);
    }

    public JSONObject getFirstReferringParams() {
        String storedParam = this.prefHelper_.getInstallParams();
        JSONObject firstReferringParams = this.convertParamsStringToDictionary(storedParam);
        firstReferringParams = this.appendDebugParams(firstReferringParams);
        return firstReferringParams;
    }

    public JSONObject getFirstReferringParamsSync() {
        this.getFirstReferringParamsLatch = new CountDownLatch(1);
        if (this.prefHelper_.getInstallParams().equals("bnc_no_value")) {
            try {
                this.getFirstReferringParamsLatch.await(LATCH_WAIT_UNTIL, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String storedParam = this.prefHelper_.getInstallParams();
        JSONObject firstReferringParams = this.convertParamsStringToDictionary(storedParam);
        firstReferringParams = this.appendDebugParams(firstReferringParams);
        this.getFirstReferringParamsLatch = null;
        return firstReferringParams;
    }

    public JSONObject getLatestReferringParams() {
        String storedParam = this.prefHelper_.getSessionParams();
        JSONObject latestParams = this.convertParamsStringToDictionary(storedParam);
        latestParams = this.appendDebugParams(latestParams);
        return latestParams;
    }

    public JSONObject getLatestReferringParamsSync() {
        this.getLatestReferringParamsLatch = new CountDownLatch(1);
        try {
            if (this.initState_ != SESSION_STATE.INITIALISED) {
                this.getLatestReferringParamsLatch.await(LATCH_WAIT_UNTIL, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String storedParam = this.prefHelper_.getSessionParams();
        JSONObject latestParams = this.convertParamsStringToDictionary(storedParam);
        latestParams = this.appendDebugParams(latestParams);
        this.getLatestReferringParamsLatch = null;
        return latestParams;
    }

    private JSONObject appendDebugParams(JSONObject originalParams) {
        try {
            if (originalParams != null && this.deeplinkDebugParams_ != null) {
                if (this.deeplinkDebugParams_.length() > 0) {
                    Log.w((String)TAG, (String)"You're currently in deep link debug mode. Please comment out 'setDeepLinkDebugMode' to receive the deep link parameters from a real Branch link");
                }
                Iterator keys = this.deeplinkDebugParams_.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    originalParams.put(key, this.deeplinkDebugParams_.get(key));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return originalParams;
    }

    public JSONObject getDeeplinkDebugParams() {
        if (this.deeplinkDebugParams_ != null && this.deeplinkDebugParams_.length() > 0) {
            Log.w((String)TAG, (String)"You're currently in deep link debug mode. Please comment out 'setDeepLinkDebugMode' to receive the deep link parameters from a real Branch link");
        }
        return this.deeplinkDebugParams_;
    }

    String generateShortLinkInternal(ServerRequestCreateUrl req) {
        if (!req.constructError_ && !req.handleErrors(this.context_)) {
            if (this.linkCache_.containsKey((Object)req.getLinkPost())) {
                String url = this.linkCache_.get((Object)req.getLinkPost());
                req.onUrlAvailable(url);
                return url;
            }
            if (req.isAsync()) {
                this.generateShortLinkAsync(req);
            } else {
                return this.generateShortLinkSync(req);
            }
        }
        return null;
    }

    private void shareLink(ShareLinkBuilder builder) {
        if (this.shareLinkManager_ != null) {
            this.shareLinkManager_.cancelShareLinkDialog(true);
        }
        this.shareLinkManager_ = new ShareLinkManager();
        this.shareLinkManager_.shareLink(builder);
    }

    public void cancelShareLinkDialog(boolean animateClose) {
        if (this.shareLinkManager_ != null) {
            this.shareLinkManager_.cancelShareLinkDialog(animateClose);
        }
    }

    private String convertDate(Date date) {
        return DateFormat.format((CharSequence)"yyyy-MM-dd", (Date)date).toString();
    }

    private String generateShortLinkSync(ServerRequestCreateUrl req) {
        if (this.initState_ == SESSION_STATE.INITIALISED) {
            ServerResponse response = null;
            try {
                int timeOut = this.prefHelper_.getTimeout() + 2000;
                response = (ServerResponse)new getShortLinkTask().execute(new ServerRequest[]{req}).get((long)timeOut, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException timeOut) {
                // empty catch block
            }
            String url = null;
            if (req.isDefaultToLongUrl()) {
                url = req.getLongUrl();
            }
            if (response != null && response.getStatusCode() == 200) {
                try {
                    url = response.getObject().getString("url");
                    if (req.getLinkPost() != null) {
                        this.linkCache_.put(req.getLinkPost(), url);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            return url;
        }
        Log.i((String)TAG, (String)"Branch Warning: User session has not been initialized");
        return null;
    }

    private void generateShortLinkAsync(ServerRequest req) {
        this.handleNewRequest(req);
    }

    private JSONObject convertParamsStringToDictionary(String paramString) {
        if (paramString.equals("bnc_no_value")) {
            return new JSONObject();
        }
        try {
            return new JSONObject(paramString);
        }
        catch (JSONException e) {
            byte[] encodedArray = Base64.decode(paramString.getBytes(), 2);
            try {
                return new JSONObject(new String(encodedArray));
            }
            catch (JSONException ex) {
                ex.printStackTrace();
                return new JSONObject();
            }
        }
    }

    private void scheduleListOfApps() {
        ScheduledThreadPoolExecutor scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1);
        Runnable periodicTask = new Runnable(){

            @Override
            public void run() {
                ServerRequestSendAppList req = new ServerRequestSendAppList(Branch.this.context_);
                if (!req.constructError_ && !((ServerRequest)req).handleErrors(Branch.this.context_)) {
                    Branch.this.handleNewRequest(req);
                }
            }
        };
        Date date = new Date();
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(date);
        int days = 7 - calendar.get(7);
        int hours = 2 - calendar.get(11);
        if (days == 0 && hours < 0) {
            days = 7;
        }
        int interval = 604800;
        this.appListingSchedule_ = scheduler.scheduleAtFixedRate(periodicTask, (days * 24 + hours) * 60 * 60, interval, TimeUnit.SECONDS);
    }

    private void processNextQueueItem() {
        try {
            this.serverSema_.acquire();
            if (this.networkCount_ == 0 && this.requestQueue_.getSize() > 0) {
                this.networkCount_ = 1;
                ServerRequest req = this.requestQueue_.peek();
                this.serverSema_.release();
                if (req != null) {
                    if (!req.isWaitingOnProcessToFinish()) {
                        if (!(req instanceof ServerRequestRegisterInstall) && !this.hasUser()) {
                            Log.i((String)TAG, (String)"Branch Error: User session has not been initialized!");
                            this.networkCount_ = 0;
                            this.handleFailure(this.requestQueue_.getSize() - 1, -101);
                        } else if (!(req instanceof ServerRequestInitSession || this.hasSession() && this.hasDeviceFingerPrint())) {
                            this.networkCount_ = 0;
                            this.handleFailure(this.requestQueue_.getSize() - 1, -101);
                        } else {
                            BranchPostTask postTask = new BranchPostTask(req);
                            postTask.executeTask(new Void[0]);
                        }
                    } else {
                        this.networkCount_ = 0;
                    }
                } else {
                    this.requestQueue_.remove(null);
                }
            } else {
                this.serverSema_.release();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleFailure(int index, int statusCode) {
        ServerRequest req = index >= this.requestQueue_.getSize() ? this.requestQueue_.peekAt(this.requestQueue_.getSize() - 1) : this.requestQueue_.peekAt(index);
        this.handleFailure(req, statusCode);
    }

    private void handleFailure(ServerRequest req, int statusCode) {
        if (req == null) {
            return;
        }
        req.handleFailure(statusCode, "");
    }

    private void updateAllRequestsInQueue() {
        try {
            for (int i = 0; i < this.requestQueue_.getSize(); ++i) {
                JSONObject reqJson;
                ServerRequest req = this.requestQueue_.peekAt(i);
                if (req == null || (reqJson = req.getPost()) == null) continue;
                if (reqJson.has(Defines.Jsonkey.SessionID.getKey())) {
                    req.getPost().put(Defines.Jsonkey.SessionID.getKey(), (Object)this.prefHelper_.getSessionID());
                }
                if (reqJson.has(Defines.Jsonkey.IdentityID.getKey())) {
                    req.getPost().put(Defines.Jsonkey.IdentityID.getKey(), (Object)this.prefHelper_.getIdentityID());
                }
                if (!reqJson.has(Defines.Jsonkey.DeviceFingerprintID.getKey())) continue;
                req.getPost().put(Defines.Jsonkey.DeviceFingerprintID.getKey(), (Object)this.prefHelper_.getDeviceFingerPrintID());
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private boolean hasSession() {
        return !this.prefHelper_.getSessionID().equals("bnc_no_value");
    }

    private boolean hasDeviceFingerPrint() {
        return !this.prefHelper_.getDeviceFingerPrintID().equals("bnc_no_value");
    }

    private boolean hasUser() {
        return !this.prefHelper_.getIdentityID().equals("bnc_no_value");
    }

    private void insertRequestAtFront(ServerRequest req) {
        if (this.networkCount_ == 0) {
            this.requestQueue_.insert(req, 0);
        } else {
            this.requestQueue_.insert(req, 1);
        }
    }

    private void registerInstallOrOpen(ServerRequest req, BranchReferralInitListener callback) {
        if (!this.requestQueue_.containsInstallOrOpen()) {
            this.insertRequestAtFront(req);
        } else {
            if (callback != null) {
                this.requestQueue_.setInstallOrOpenCallback(callback);
            }
            this.requestQueue_.moveInstallOrOpenToFront(req, this.networkCount_, callback);
        }
        this.processNextQueueItem();
    }

    private void initializeSession(BranchReferralInitListener callback) {
        if (this.prefHelper_.getBranchKey() == null || this.prefHelper_.getBranchKey().equalsIgnoreCase("bnc_no_value")) {
            this.initState_ = SESSION_STATE.UNINITIALISED;
            if (callback != null) {
                callback.onInitFinished(null, new BranchError("Trouble initializing Branch.", -114));
            }
            Log.i((String)TAG, (String)"Branch Warning: Please enter your branch_key in your project's res/values/strings.xml!");
            return;
        }
        if (this.prefHelper_.getBranchKey() != null && this.prefHelper_.getBranchKey().startsWith("key_test_")) {
            Log.i((String)TAG, (String)"Branch Warning: You are using your test app's Branch Key. Remember to change it to live Branch Key during deployment.");
        }
        if (!this.prefHelper_.getExternalIntentUri().equals("bnc_no_value") || !this.enableFacebookAppLinkCheck_) {
            this.registerAppInit(callback, null);
        } else {
            boolean appLinkRqSucceeded = DeferredAppLinkDataHandler.fetchDeferredAppLinkData(this.context_, new DeferredAppLinkDataHandler.AppLinkFetchEvents(){

                @Override
                public void onAppLinkFetchFinished(String nativeAppLinkUrl) {
                    Uri appLinkUri;
                    String bncLinkClickId;
                    Branch.this.prefHelper_.setIsAppLinkTriggeredInit(true);
                    if (nativeAppLinkUrl != null && !TextUtils.isEmpty((CharSequence)(bncLinkClickId = (appLinkUri = Uri.parse((String)nativeAppLinkUrl)).getQueryParameter(Defines.Jsonkey.LinkClickID.getKey())))) {
                        Branch.this.prefHelper_.setLinkClickIdentifier(bncLinkClickId);
                    }
                    Branch.this.requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.FB_APP_LINK_WAIT_LOCK);
                    Branch.this.processNextQueueItem();
                }
            });
            if (appLinkRqSucceeded) {
                this.registerAppInit(callback, ServerRequest.PROCESS_WAIT_LOCK.FB_APP_LINK_WAIT_LOCK);
            } else {
                this.registerAppInit(callback, null);
            }
        }
    }

    private void registerAppInit(BranchReferralInitListener callback, ServerRequest.PROCESS_WAIT_LOCK lock) {
        ServerRequestInitSession request = this.hasUser() ? new ServerRequestRegisterOpen(this.context_, callback, this.systemObserver_) : new ServerRequestRegisterInstall(this.context_, callback, this.systemObserver_, InstallListener.getInstallationID());
        request.addProcessWaitLock(lock);
        if (this.isGAParamsFetchInProgress_) {
            request.addProcessWaitLock(ServerRequest.PROCESS_WAIT_LOCK.GAID_FETCH_WAIT_LOCK);
        }
        if (this.intentState_ != INTENT_STATE.READY) {
            request.addProcessWaitLock(ServerRequest.PROCESS_WAIT_LOCK.INTENT_PENDING_WAIT_LOCK);
        }
        if (Branch.checkPlayStoreReferrer() && request instanceof ServerRequestRegisterInstall) {
            request.addProcessWaitLock(ServerRequest.PROCESS_WAIT_LOCK.INSTALL_REFERRER_FETCH_WAIT_LOCK);
            InstallListener.startInstallReferrerTime(PLAYSTORE_REFERRAL_FETCH_WAIT_FOR);
        }
        this.registerInstallOrOpen(request, callback);
    }

    private void onIntentReady(Activity activity) {
        this.requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.INTENT_PENDING_WAIT_LOCK);
        if (activity.getIntent() != null) {
            Uri intentData = activity.getIntent().getData();
            this.readAndStripParam(intentData, activity);
            if (cookieBasedMatchDomain_ != null && this.prefHelper_.getBranchKey() != null && !this.prefHelper_.getBranchKey().equalsIgnoreCase("bnc_no_value")) {
                if (this.isGAParamsFetchInProgress_) {
                    this.performCookieBasedStrongMatchingOnGAIDAvailable = true;
                } else {
                    this.performCookieBasedStrongMatch();
                }
            } else {
                this.processNextQueueItem();
            }
        } else {
            this.processNextQueueItem();
        }
    }

    private void performCookieBasedStrongMatch() {
        Context context;
        boolean simulateInstall = this.prefHelper_.getExternDebug() || Branch.isSimulatingInstalls();
        DeviceInfo deviceInfo = DeviceInfo.getInstance(simulateInstall, this.systemObserver_, disableDeviceIDFetch_);
        Activity currentActivity = null;
        if (this.currentActivityReference_ != null) {
            currentActivity = (Activity)this.currentActivityReference_.get();
        }
        Context context2 = context = currentActivity != null ? currentActivity.getApplicationContext() : null;
        if (context != null) {
            this.requestQueue_.setStrongMatchWaitLock();
            BranchStrongMatchHelper.getInstance().checkForStrongMatch(context, cookieBasedMatchDomain_, deviceInfo, this.prefHelper_, this.systemObserver_, new BranchStrongMatchHelper.StrongMatchCheckEvents(){

                @Override
                public void onStrongMatchCheckFinished() {
                    Branch.this.requestQueue_.unlockProcessWait(ServerRequest.PROCESS_WAIT_LOCK.STRONG_MATCH_PENDING_WAIT_LOCK);
                    Branch.this.processNextQueueItem();
                }
            });
        }
    }

    public void handleNewRequest(ServerRequest req) {
        if (this.initState_ != SESSION_STATE.INITIALISED && !(req instanceof ServerRequestInitSession)) {
            if (req instanceof ServerRequestLogout) {
                req.handleFailure(-101, "");
                Log.i((String)TAG, (String)"Branch is not initialized, cannot logout");
                return;
            }
            if (req instanceof ServerRequestRegisterClose) {
                Log.i((String)TAG, (String)"Branch is not initialized, cannot close session");
                return;
            }
            Activity currentActivity = null;
            if (this.currentActivityReference_ != null) {
                currentActivity = (Activity)this.currentActivityReference_.get();
            }
            if (customReferrableSettings_ == CUSTOM_REFERRABLE_SETTINGS.USE_DEFAULT) {
                this.initUserSessionInternal((BranchReferralInitListener)null, currentActivity, true);
            } else {
                boolean isReferrable = customReferrableSettings_ == CUSTOM_REFERRABLE_SETTINGS.REFERRABLE;
                this.initUserSessionInternal((BranchReferralInitListener)null, currentActivity, isReferrable);
            }
        }
        this.requestQueue_.enqueue(req);
        req.onRequestQueued();
        this.processNextQueueItem();
    }

    @TargetApi(value=14)
    private void setActivityLifeCycleObserver(Application application) {
        try {
            BranchActivityLifeCycleObserver activityLifeCycleObserver = new BranchActivityLifeCycleObserver();
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityLifeCycleObserver);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityLifeCycleObserver);
            isActivityLifeCycleCallbackRegistered_ = true;
        }
        catch (NoClassDefFoundError | NoSuchMethodError Ex) {
            isActivityLifeCycleCallbackRegistered_ = false;
            isAutoSessionMode_ = false;
            Log.w((String)TAG, (String)new BranchError("", -108).getMessage());
        }
    }

    private void startSession(Activity activity) {
        Uri intentData = null;
        if (activity.getIntent() != null) {
            intentData = activity.getIntent().getData();
        }
        this.initSessionWithData(intentData, activity);
    }

    private boolean checkIntentForSessionRestart(Intent intent) {
        boolean isRestartSessionRequested = false;
        if (intent != null && (isRestartSessionRequested = intent.getBooleanExtra(Defines.Jsonkey.ForceNewBranchSession.getKey(), false))) {
            intent.putExtra(Defines.Jsonkey.ForceNewBranchSession.getKey(), false);
        }
        return isRestartSessionRequested;
    }

    public static boolean isAutoDeepLinkLaunch(Activity activity) {
        return activity.getIntent().getStringExtra(AUTO_DEEP_LINKED) != null;
    }

    private void checkForAutoDeepLinkConfiguration() {
        JSONObject latestParams = this.getLatestReferringParams();
        String deepLinkActivity = null;
        try {
            if (!latestParams.has(Defines.Jsonkey.Clicked_Branch_Link.getKey()) || !latestParams.getBoolean(Defines.Jsonkey.Clicked_Branch_Link.getKey())) {
                return;
            }
            if (latestParams.length() > 0) {
                ApplicationInfo appInfo = this.context_.getPackageManager().getApplicationInfo(this.context_.getPackageName(), 128);
                if (appInfo.metaData != null && appInfo.metaData.getBoolean(AUTO_DEEP_LINK_DISABLE, false)) {
                    return;
                }
                PackageInfo info = this.context_.getPackageManager().getPackageInfo(this.context_.getPackageName(), 129);
                ActivityInfo[] activityInfos = info.activities;
                int deepLinkActivityReqCode = 1501;
                if (activityInfos != null) {
                    for (ActivityInfo activityInfo : activityInfos) {
                        if (activityInfo == null || activityInfo.metaData == null || activityInfo.metaData.getString(AUTO_DEEP_LINK_KEY) == null && activityInfo.metaData.getString(AUTO_DEEP_LINK_PATH) == null || !this.checkForAutoDeepLinkKeys(latestParams, activityInfo) && !this.checkForAutoDeepLinkPath(latestParams, activityInfo)) continue;
                        deepLinkActivity = activityInfo.name;
                        deepLinkActivityReqCode = activityInfo.metaData.getInt(AUTO_DEEP_LINK_REQ_CODE, 1501);
                        break;
                    }
                }
                if (deepLinkActivity != null && this.currentActivityReference_ != null) {
                    Activity currentActivity = (Activity)this.currentActivityReference_.get();
                    if (currentActivity != null) {
                        Intent intent = new Intent((Context)currentActivity, Class.forName(deepLinkActivity));
                        intent.putExtra(AUTO_DEEP_LINKED, "true");
                        intent.putExtra(Defines.Jsonkey.ReferringData.getKey(), latestParams.toString());
                        Iterator keys = latestParams.keys();
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            intent.putExtra(key, latestParams.getString(key));
                        }
                        currentActivity.startActivityForResult(intent, deepLinkActivityReqCode);
                    } else {
                        Log.w((String)TAG, (String)"No activity reference to launch deep linked activity");
                    }
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.i((String)TAG, (String)"Branch Warning: Please make sure Activity names set for auto deep link are correct!");
        }
        catch (ClassNotFoundException e) {
            Log.i((String)TAG, (String)("Branch Warning: Please make sure Activity names set for auto deep link are correct! Error while looking for activity " + deepLinkActivity));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean checkForAutoDeepLinkKeys(JSONObject params, ActivityInfo activityInfo) {
        if (activityInfo.metaData.getString(AUTO_DEEP_LINK_KEY) != null) {
            String[] activityLinkKeys;
            for (String activityLinkKey : activityLinkKeys = activityInfo.metaData.getString(AUTO_DEEP_LINK_KEY).split(",")) {
                if (!params.has(activityLinkKey)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkForAutoDeepLinkPath(JSONObject params, ActivityInfo activityInfo) {
        String deepLinkPath = null;
        try {
            if (params.has(Defines.Jsonkey.AndroidDeepLinkPath.getKey())) {
                deepLinkPath = params.getString(Defines.Jsonkey.AndroidDeepLinkPath.getKey());
            } else if (params.has(Defines.Jsonkey.DeepLinkPath.getKey())) {
                deepLinkPath = params.getString(Defines.Jsonkey.DeepLinkPath.getKey());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (activityInfo.metaData.getString(AUTO_DEEP_LINK_PATH) != null && deepLinkPath != null) {
            String[] activityLinkPaths;
            for (String activityLinkPath : activityLinkPaths = activityInfo.metaData.getString(AUTO_DEEP_LINK_PATH).split(",")) {
                if (!this.pathMatch(activityLinkPath.trim(), deepLinkPath)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean pathMatch(String templatePath, String path) {
        String[] pathSegmentsTarget;
        boolean matched = true;
        String[] pathSegmentsTemplate = templatePath.split("\\?")[0].split("/");
        if (pathSegmentsTemplate.length != (pathSegmentsTarget = path.split("\\?")[0].split("/")).length) {
            return false;
        }
        for (int i = 0; i < pathSegmentsTemplate.length && i < pathSegmentsTarget.length; ++i) {
            String pathSegmentTemplate = pathSegmentsTemplate[i];
            String pathSegmentTarget = pathSegmentsTarget[i];
            if (pathSegmentTemplate.equals(pathSegmentTarget) || pathSegmentTemplate.contains("*")) continue;
            matched = false;
            break;
        }
        return matched;
    }

    public static void enableSimulateInstalls() {
        isSimulatingInstalls_ = true;
    }

    public static void disableSimulateInstalls() {
        isSimulatingInstalls_ = false;
    }

    public static boolean isSimulatingInstalls() {
        return isSimulatingInstalls_;
    }

    public static void enableLogging() {
        isLogging_ = true;
    }

    public static void disableLogging() {
        isLogging_ = false;
    }

    public static boolean getIsLogging() {
        return isLogging_;
    }

    public void registerView(BranchUniversalObject branchUniversalObject, BranchUniversalObject.RegisterViewStatusListener callback) {
        if (this.context_ != null) {
            ServerRequestRegisterView req = new ServerRequestRegisterView(this.context_, branchUniversalObject, this.systemObserver_, callback);
            if (!req.constructError_ && !((ServerRequest)req).handleErrors(this.context_)) {
                this.handleNewRequest(req);
            }
        }
    }

    public void addExtraInstrumentationData(HashMap<String, String> instrumentationData) {
        this.instrumentationExtraData_.putAll(instrumentationData);
    }

    public void addExtraInstrumentationData(String key, String value) {
        this.instrumentationExtraData_.put(key, value);
    }

    @Override
    public void onBranchViewVisible(String action, String branchViewID) {
    }

    @Override
    public void onBranchViewAccepted(String action, String branchViewID) {
        if (ServerRequestInitSession.isInitSessionAction(action)) {
            this.checkForAutoDeepLinkConfiguration();
        }
    }

    @Override
    public void onBranchViewCancelled(String action, String branchViewID) {
        if (ServerRequestInitSession.isInitSessionAction(action)) {
            this.checkForAutoDeepLinkConfiguration();
        }
    }

    @Override
    public void onBranchViewError(int errorCode, String errorMsg, String action) {
        if (ServerRequestInitSession.isInitSessionAction(action)) {
            this.checkForAutoDeepLinkConfiguration();
        }
    }

    public static boolean isInstantApp(@NonNull Context context) {
        try {
            Context applicationContext = context.getApplicationContext();
            if (isInstantApp != null && applicationContext.equals(lastApplicationContext)) {
                return isInstantApp;
            }
            isInstantApp = null;
            lastApplicationContext = applicationContext;
            applicationContext.getClassLoader().loadClass("com.google.android.instantapps.supervisor.InstantAppsRuntime");
            isInstantApp = true;
        }
        catch (Exception ex) {
            isInstantApp = false;
        }
        return isInstantApp;
    }

    public static boolean showInstallPrompt(@NonNull Activity activity, int requestCode) {
        String installReferrerString = "";
        if (Branch.getInstance() != null) {
            JSONObject latestReferringParams = Branch.getInstance().getLatestReferringParams();
            String referringLinkKey = "~" + Defines.Jsonkey.ReferringLink.getKey();
            if (latestReferringParams != null && latestReferringParams.has(referringLinkKey)) {
                try {
                    String referringLink = latestReferringParams.getString(referringLinkKey);
                    installReferrerString = Defines.Jsonkey.IsFullAppConv.getKey() + "=true&" + Defines.Jsonkey.ReferringLink.getKey() + "=" + referringLink;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return Branch.doShowInstallPrompt(activity, requestCode, installReferrerString);
    }

    public static boolean showInstallPrompt(@NonNull Activity activity, int requestCode, @Nullable String referrer) {
        String installReferrerString = Defines.Jsonkey.IsFullAppConv.getKey() + "=true&" + referrer;
        return Branch.doShowInstallPrompt(activity, requestCode, installReferrerString);
    }

    public static boolean showInstallPrompt(@NonNull Activity activity, int requestCode, @NonNull BranchUniversalObject buo) {
        if (buo != null) {
            String shortUrl = buo.getShortUrl((Context)activity, new LinkProperties());
            String installReferrerString = Defines.Jsonkey.ReferringLink.getKey() + "=" + shortUrl;
            if (!TextUtils.isEmpty((CharSequence)installReferrerString)) {
                return Branch.showInstallPrompt(activity, requestCode, installReferrerString);
            }
            return Branch.showInstallPrompt(activity, requestCode, "");
        }
        return false;
    }

    private static boolean doShowInstallPrompt(@NonNull Activity activity, int requestCode, @Nullable String referrer) {
        if (activity == null) {
            Log.e((String)TAG, (String)"Unable to show install prompt. Activity is null");
            return false;
        }
        if (!Branch.isInstantApp((Context)activity)) {
            Log.e((String)TAG, (String)"Unable to show install prompt. Application is not an instant app");
            return false;
        }
        Intent intent = new Intent("android.intent.action.VIEW").setPackage("com.android.vending").addCategory("android.intent.category.DEFAULT").putExtra("callerId", activity.getPackageName()).putExtra("overlay", true);
        Uri.Builder uriBuilder = new Uri.Builder().scheme("market").authority("details").appendQueryParameter("id", activity.getPackageName());
        if (!TextUtils.isEmpty((CharSequence)referrer)) {
            uriBuilder.appendQueryParameter("referrer", referrer);
        }
        intent.setData(uriBuilder.build());
        activity.startActivityForResult(intent, requestCode);
        return true;
    }

    static {
        isLogging_ = false;
        checkInstallReferrer_ = false;
        PLAYSTORE_REFERRAL_FETCH_WAIT_FOR = 5000L;
        isAutoSessionMode_ = false;
        isActivityLifeCycleCallbackRegistered_ = false;
        customReferrableSettings_ = CUSTOM_REFERRABLE_SETTINGS.USE_DEFAULT;
        cookieBasedMatchDomain_ = "app.link";
        LATCH_WAIT_UNTIL = 2500;
        EXTERNAL_INTENT_EXTRA_KEY_WHITE_LIST = new String[]{"extra_launch_uri"};
        lastApplicationContext = null;
        isInstantApp = null;
    }

    public static interface IBranchViewControl {
        public boolean skipBranchViewsOnThisActivity();
    }

    public static class ShareLinkBuilder {
        private final Activity activity_;
        private final Branch branch_;
        private String shareMsg_;
        private String shareSub_;
        private BranchLinkShareListener callback_ = null;
        private IChannelProperties channelPropertiesCallback_ = null;
        private ArrayList<SharingHelper.SHARE_WITH> preferredOptions_;
        private String defaultURL_;
        private Drawable moreOptionIcon_;
        private String moreOptionText_;
        private Drawable copyUrlIcon_;
        private String copyURlText_;
        private String urlCopiedMessage_;
        private int styleResourceID_;
        private boolean setFullWidthStyle_;
        private int dividerHeight = -1;
        private String sharingTitle = null;
        private View sharingTitleView = null;
        BranchShortLinkBuilder shortLinkBuilder_;
        private List<String> includeInShareSheet = new ArrayList<String>();
        private List<String> excludeFromShareSheet = new ArrayList<String>();

        public ShareLinkBuilder(Activity activity, JSONObject parameters) {
            this.activity_ = activity;
            this.branch_ = branchReferral_;
            this.shortLinkBuilder_ = new BranchShortLinkBuilder((Context)activity);
            try {
                Iterator keys = parameters.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.shortLinkBuilder_.addParameters(key, (String)parameters.get(key));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.shareMsg_ = "";
            this.callback_ = null;
            this.channelPropertiesCallback_ = null;
            this.preferredOptions_ = new ArrayList();
            this.defaultURL_ = null;
            this.moreOptionIcon_ = BranchUtil.getDrawable(activity.getApplicationContext(), 17301573);
            this.moreOptionText_ = "More...";
            this.copyUrlIcon_ = BranchUtil.getDrawable(activity.getApplicationContext(), 17301582);
            this.copyURlText_ = "Copy link";
            this.urlCopiedMessage_ = "Copied link to clipboard!";
        }

        public ShareLinkBuilder(Activity activity, BranchShortLinkBuilder shortLinkBuilder) {
            this(activity, new JSONObject());
            this.shortLinkBuilder_ = shortLinkBuilder;
        }

        public ShareLinkBuilder setMessage(String message) {
            this.shareMsg_ = message;
            return this;
        }

        public ShareLinkBuilder setSubject(String subject) {
            this.shareSub_ = subject;
            return this;
        }

        public ShareLinkBuilder addTag(String tag) {
            this.shortLinkBuilder_.addTag(tag);
            return this;
        }

        public ShareLinkBuilder addTags(ArrayList<String> tags) {
            this.shortLinkBuilder_.addTags(tags);
            return this;
        }

        public ShareLinkBuilder setFeature(String feature) {
            this.shortLinkBuilder_.setFeature(feature);
            return this;
        }

        public ShareLinkBuilder setStage(String stage) {
            this.shortLinkBuilder_.setStage(stage);
            return this;
        }

        public ShareLinkBuilder setCallback(BranchLinkShareListener callback) {
            this.callback_ = callback;
            return this;
        }

        public ShareLinkBuilder setChannelProperties(IChannelProperties channelPropertiesCallback) {
            this.channelPropertiesCallback_ = channelPropertiesCallback;
            return this;
        }

        public ShareLinkBuilder addPreferredSharingOption(SharingHelper.SHARE_WITH preferredOption) {
            this.preferredOptions_.add(preferredOption);
            return this;
        }

        public ShareLinkBuilder addPreferredSharingOptions(ArrayList<SharingHelper.SHARE_WITH> preferredOptions) {
            this.preferredOptions_.addAll(preferredOptions);
            return this;
        }

        public ShareLinkBuilder addParam(String key, String value) {
            try {
                this.shortLinkBuilder_.addParameters(key, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        public ShareLinkBuilder setDefaultURL(String url) {
            this.defaultURL_ = url;
            return this;
        }

        public ShareLinkBuilder setMoreOptionStyle(Drawable icon, String label) {
            this.moreOptionIcon_ = icon;
            this.moreOptionText_ = label;
            return this;
        }

        public ShareLinkBuilder setMoreOptionStyle(int drawableIconID, int stringLabelID) {
            this.moreOptionIcon_ = BranchUtil.getDrawable(this.activity_.getApplicationContext(), drawableIconID);
            this.moreOptionText_ = this.activity_.getResources().getString(stringLabelID);
            return this;
        }

        public ShareLinkBuilder setCopyUrlStyle(Drawable icon, String label, String message) {
            this.copyUrlIcon_ = icon;
            this.copyURlText_ = label;
            this.urlCopiedMessage_ = message;
            return this;
        }

        public ShareLinkBuilder setCopyUrlStyle(int drawableIconID, int stringLabelID, int stringMessageID) {
            this.copyUrlIcon_ = BranchUtil.getDrawable(this.activity_.getApplicationContext(), drawableIconID);
            this.copyURlText_ = this.activity_.getResources().getString(stringLabelID);
            this.urlCopiedMessage_ = this.activity_.getResources().getString(stringMessageID);
            return this;
        }

        public ShareLinkBuilder setAlias(String alias) {
            this.shortLinkBuilder_.setAlias(alias);
            return this;
        }

        public ShareLinkBuilder setMatchDuration(int matchDuration) {
            this.shortLinkBuilder_.setDuration(matchDuration);
            return this;
        }

        public ShareLinkBuilder setAsFullWidthStyle(boolean setFullWidthStyle) {
            this.setFullWidthStyle_ = setFullWidthStyle;
            return this;
        }

        public ShareLinkBuilder setDividerHeight(int height) {
            this.dividerHeight = height;
            return this;
        }

        public ShareLinkBuilder setSharingTitle(String title) {
            this.sharingTitle = title;
            return this;
        }

        public ShareLinkBuilder setSharingTitle(View titleView) {
            this.sharingTitleView = titleView;
            return this;
        }

        public ShareLinkBuilder excludeFromShareSheet(@NonNull String packageName) {
            this.excludeFromShareSheet.add(packageName);
            return this;
        }

        public ShareLinkBuilder excludeFromShareSheet(@NonNull String[] packageName) {
            this.excludeFromShareSheet.addAll(Arrays.asList(packageName));
            return this;
        }

        public ShareLinkBuilder excludeFromShareSheet(@NonNull List<String> packageNames) {
            this.excludeFromShareSheet.addAll(packageNames);
            return this;
        }

        public ShareLinkBuilder includeInShareSheet(@NonNull String packageName) {
            this.includeInShareSheet.add(packageName);
            return this;
        }

        public ShareLinkBuilder includeInShareSheet(@NonNull String[] packageName) {
            this.includeInShareSheet.addAll(Arrays.asList(packageName));
            return this;
        }

        public ShareLinkBuilder includeInShareSheet(@NonNull List<String> packageNames) {
            this.includeInShareSheet.addAll(packageNames);
            return this;
        }

        public void setStyleResourceID(@StyleRes int resourceID) {
            this.styleResourceID_ = resourceID;
        }

        public void setShortLinkBuilderInternal(BranchShortLinkBuilder shortLinkBuilder) {
            this.shortLinkBuilder_ = shortLinkBuilder;
        }

        public void shareLink() {
            branchReferral_.shareLink(this);
        }

        public Activity getActivity() {
            return this.activity_;
        }

        public ArrayList<SharingHelper.SHARE_WITH> getPreferredOptions() {
            return this.preferredOptions_;
        }

        List<String> getExcludedFromShareSheet() {
            return this.excludeFromShareSheet;
        }

        List<String> getIncludedInShareSheet() {
            return this.includeInShareSheet;
        }

        public Branch getBranch() {
            return this.branch_;
        }

        public String getShareMsg() {
            return this.shareMsg_;
        }

        public String getShareSub() {
            return this.shareSub_;
        }

        public BranchLinkShareListener getCallback() {
            return this.callback_;
        }

        public IChannelProperties getChannelPropertiesCallback() {
            return this.channelPropertiesCallback_;
        }

        public String getDefaultURL() {
            return this.defaultURL_;
        }

        public Drawable getMoreOptionIcon() {
            return this.moreOptionIcon_;
        }

        public String getMoreOptionText() {
            return this.moreOptionText_;
        }

        public Drawable getCopyUrlIcon() {
            return this.copyUrlIcon_;
        }

        public String getCopyURlText() {
            return this.copyURlText_;
        }

        public String getUrlCopiedMessage() {
            return this.urlCopiedMessage_;
        }

        public BranchShortLinkBuilder getShortLinkBuilder() {
            return this.shortLinkBuilder_;
        }

        public boolean getIsFullWidthStyle() {
            return this.setFullWidthStyle_;
        }

        public int getDividerHeight() {
            return this.dividerHeight;
        }

        public String getSharingTitle() {
            return this.sharingTitle;
        }

        public View getSharingTitleView() {
            return this.sharingTitleView;
        }

        public int getStyleResourceID() {
            return this.styleResourceID_;
        }
    }

    private class BranchPostTask
    extends BranchAsyncTask<Void, Void, ServerResponse> {
        ServerRequest thisReq_;

        public BranchPostTask(ServerRequest request) {
            this.thisReq_ = request;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.thisReq_.onPreExecute();
        }

        protected ServerResponse doInBackground(Void ... voids) {
            if (this.thisReq_ instanceof ServerRequestInitSession) {
                ((ServerRequestInitSession)this.thisReq_).updateLinkReferrerParams();
            }
            Branch.this.addExtraInstrumentationData(this.thisReq_.getRequestPath() + "-" + Defines.Jsonkey.Queue_Wait_Time.getKey(), String.valueOf(this.thisReq_.getQueueWaitTime()));
            if (this.thisReq_.isGAdsParamsRequired() && !BranchUtil.isTestModeEnabled(Branch.this.context_)) {
                this.thisReq_.updateGAdsParams(Branch.this.systemObserver_);
            }
            if (this.thisReq_.isGetRequest()) {
                return Branch.this.branchRemoteInterface_.make_restful_get(this.thisReq_.getRequestUrl(), this.thisReq_.getGetParams(), this.thisReq_.getRequestPath(), Branch.this.prefHelper_.getBranchKey());
            }
            return Branch.this.branchRemoteInterface_.make_restful_post(this.thisReq_.getPostWithInstrumentationValues(Branch.this.instrumentationExtraData_), this.thisReq_.getRequestUrl(), this.thisReq_.getRequestPath(), Branch.this.prefHelper_.getBranchKey());
        }

        protected void onPostExecute(ServerResponse serverResponse) {
            super.onPostExecute((Object)serverResponse);
            if (serverResponse != null) {
                try {
                    int status = serverResponse.getStatusCode();
                    Branch.this.hasNetwork_ = true;
                    if (status != 200) {
                        if (this.thisReq_ instanceof ServerRequestInitSession) {
                            Branch.this.initState_ = SESSION_STATE.UNINITIALISED;
                        }
                        if (status == 409) {
                            Branch.this.requestQueue_.remove(this.thisReq_);
                            if (this.thisReq_ instanceof ServerRequestCreateUrl) {
                                ((ServerRequestCreateUrl)this.thisReq_).handleDuplicateURLError();
                            } else {
                                Log.i((String)Branch.TAG, (String)"Branch API Error: Conflicting resource error code from API");
                                Branch.this.handleFailure(0, status);
                            }
                        } else {
                            Branch.this.hasNetwork_ = false;
                            ArrayList<ServerRequest> requestToFail = new ArrayList<ServerRequest>();
                            for (int i = 0; i < Branch.this.requestQueue_.getSize(); ++i) {
                                requestToFail.add(Branch.this.requestQueue_.peekAt(i));
                            }
                            for (ServerRequest req : requestToFail) {
                                if (req != null && req.shouldRetryOnFail()) continue;
                                Branch.this.requestQueue_.remove(req);
                            }
                            Branch.this.networkCount_ = 0;
                            for (ServerRequest req : requestToFail) {
                                if (req == null) continue;
                                req.handleFailure(status, serverResponse.getFailReason());
                                if (!req.shouldRetryOnFail()) continue;
                                req.clearCallbacks();
                            }
                        }
                    } else {
                        Branch.this.hasNetwork_ = true;
                        if (this.thisReq_ instanceof ServerRequestCreateUrl) {
                            if (serverResponse.getObject() != null) {
                                String url = serverResponse.getObject().getString("url");
                                Branch.this.linkCache_.put(((ServerRequestCreateUrl)this.thisReq_).getLinkPost(), url);
                            }
                        } else if (this.thisReq_ instanceof ServerRequestLogout) {
                            Branch.this.linkCache_.clear();
                            Branch.this.requestQueue_.clear();
                        }
                        Branch.this.requestQueue_.dequeue();
                        if (this.thisReq_ instanceof ServerRequestInitSession || this.thisReq_ instanceof ServerRequestIdentifyUserRequest) {
                            JSONObject respJson = serverResponse.getObject();
                            if (respJson != null) {
                                boolean updateRequestsInQueue = false;
                                if (respJson.has(Defines.Jsonkey.SessionID.getKey())) {
                                    Branch.this.prefHelper_.setSessionID(respJson.getString(Defines.Jsonkey.SessionID.getKey()));
                                    updateRequestsInQueue = true;
                                }
                                if (respJson.has(Defines.Jsonkey.IdentityID.getKey())) {
                                    String new_Identity_Id = respJson.getString(Defines.Jsonkey.IdentityID.getKey());
                                    if (!Branch.this.prefHelper_.getIdentityID().equals(new_Identity_Id)) {
                                        Branch.this.linkCache_.clear();
                                        Branch.this.prefHelper_.setIdentityID(respJson.getString(Defines.Jsonkey.IdentityID.getKey()));
                                        updateRequestsInQueue = true;
                                    }
                                }
                                if (respJson.has(Defines.Jsonkey.DeviceFingerprintID.getKey())) {
                                    Branch.this.prefHelper_.setDeviceFingerPrintID(respJson.getString(Defines.Jsonkey.DeviceFingerprintID.getKey()));
                                    updateRequestsInQueue = true;
                                }
                                if (updateRequestsInQueue) {
                                    Branch.this.updateAllRequestsInQueue();
                                }
                                if (this.thisReq_ instanceof ServerRequestInitSession) {
                                    Branch.this.initState_ = SESSION_STATE.INITIALISED;
                                    this.thisReq_.onRequestSucceeded(serverResponse, branchReferral_);
                                    Branch.this.isInitReportedThroughCallBack = ((ServerRequestInitSession)this.thisReq_).hasCallBack();
                                    if (!((ServerRequestInitSession)this.thisReq_).handleBranchViewIfAvailable(serverResponse)) {
                                        Branch.this.checkForAutoDeepLinkConfiguration();
                                    }
                                    if (Branch.this.getLatestReferringParamsLatch != null) {
                                        Branch.this.getLatestReferringParamsLatch.countDown();
                                    }
                                    if (Branch.this.getFirstReferringParamsLatch != null) {
                                        Branch.this.getFirstReferringParamsLatch.countDown();
                                    }
                                } else {
                                    this.thisReq_.onRequestSucceeded(serverResponse, branchReferral_);
                                }
                            }
                        } else {
                            this.thisReq_.onRequestSucceeded(serverResponse, branchReferral_);
                        }
                    }
                    Branch.this.networkCount_ = 0;
                    if (Branch.this.hasNetwork_ && Branch.this.initState_ != SESSION_STATE.UNINITIALISED) {
                        Branch.this.processNextQueueItem();
                    }
                }
                catch (JSONException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class getShortLinkTask
    extends AsyncTask<ServerRequest, Void, ServerResponse> {
        private getShortLinkTask() {
        }

        protected ServerResponse doInBackground(ServerRequest ... serverRequests) {
            String urlExtend = "v1/url";
            return Branch.this.branchRemoteInterface_.make_restful_post(serverRequests[0].getPost(), Branch.this.prefHelper_.getAPIBaseUrl() + urlExtend, Defines.RequestPath.GetURL.getPath(), Branch.this.prefHelper_.getBranchKey());
        }
    }

    public static enum CreditHistoryOrder {
        kMostRecentFirst,
        kLeastRecentFirst;

    }

    public static interface LogoutStatusListener {
        public void onLogoutFinished(boolean var1, BranchError var2);
    }

    public static interface BranchListResponseListener {
        public void onReceivingResponse(JSONArray var1, BranchError var2);
    }

    public static interface IChannelProperties {
        public String getSharingTitleForChannel(String var1);

        public String getSharingMessageForChannel(String var1);
    }

    public static interface BranchLinkShareListener {
        public void onShareLinkDialogLaunched();

        public void onShareLinkDialogDismissed();

        public void onLinkShareResponse(String var1, String var2, BranchError var3);

        public void onChannelSelected(String var1);
    }

    public static interface BranchLinkCreateListener {
        public void onLinkCreate(String var1, BranchError var2);
    }

    public static interface BranchReferralStateChangedListener {
        public void onStateChanged(boolean var1, BranchError var2);
    }

    public static interface BranchUniversalReferralInitListener {
        public void onInitFinished(BranchUniversalObject var1, LinkProperties var2, BranchError var3);
    }

    public static interface BranchReferralInitListener {
        public void onInitFinished(JSONObject var1, BranchError var2);
    }

    @TargetApi(value=14)
    private class BranchActivityLifeCycleObserver
    implements Application.ActivityLifecycleCallbacks {
        private int activityCnt_ = 0;

        private BranchActivityLifeCycleObserver() {
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
            Branch.this.intentState_ = Branch.this.handleDelayedNewIntents_ ? INTENT_STATE.PENDING : INTENT_STATE.READY;
            if (BranchViewHandler.getInstance().isInstallOrOpenBranchViewPending(activity.getApplicationContext())) {
                BranchViewHandler.getInstance().showPendingBranchView((Context)activity);
            }
        }

        public void onActivityStarted(Activity activity) {
            Branch.this.intentState_ = Branch.this.handleDelayedNewIntents_ ? INTENT_STATE.PENDING : INTENT_STATE.READY;
            if (Branch.this.initState_ == SESSION_STATE.INITIALISED) {
                try {
                    ContentDiscoverer.getInstance().discoverContent(activity, Branch.this.sessionReferredLink_);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.activityCnt_ < 1) {
                if (Branch.this.initState_ == SESSION_STATE.INITIALISED) {
                    Branch.this.initState_ = SESSION_STATE.UNINITIALISED;
                }
                if (BranchUtil.isTestModeEnabled(Branch.this.context_)) {
                    Branch.this.prefHelper_.setExternDebug();
                }
                Branch.this.prefHelper_.setLogging(Branch.getIsLogging());
                Branch.this.startSession(activity);
            } else if (Branch.this.checkIntentForSessionRestart(activity.getIntent())) {
                Branch.this.initState_ = SESSION_STATE.UNINITIALISED;
                Branch.this.startSession(activity);
            }
            ++this.activityCnt_;
        }

        public void onActivityResumed(Activity activity) {
            if (Branch.this.checkIntentForSessionRestart(activity.getIntent())) {
                Branch.this.initState_ = SESSION_STATE.UNINITIALISED;
                Branch.this.startSession(activity);
            }
            Branch.this.currentActivityReference_ = new WeakReference<Activity>(activity);
            if (Branch.this.handleDelayedNewIntents_) {
                Branch.this.intentState_ = INTENT_STATE.READY;
                Branch.this.onIntentReady(activity);
            }
        }

        public void onActivityPaused(Activity activity) {
            if (Branch.this.shareLinkManager_ != null) {
                Branch.this.shareLinkManager_.cancelShareLinkDialog(true);
            }
        }

        public void onActivityStopped(Activity activity) {
            ContentDiscoverer.getInstance().onActivityStopped(activity);
            --this.activityCnt_;
            if (this.activityCnt_ < 1) {
                Branch.this.closeSessionInternal();
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
            if (Branch.this.currentActivityReference_ != null && Branch.this.currentActivityReference_.get() == activity) {
                Branch.this.currentActivityReference_.clear();
            }
            BranchViewHandler.getInstance().onCurrentActivityDestroyed(activity);
        }
    }

    private static enum CUSTOM_REFERRABLE_SETTINGS {
        USE_DEFAULT,
        REFERRABLE,
        NON_REFERRABLE;

    }

    private static enum INTENT_STATE {
        PENDING,
        READY;

    }

    private static enum SESSION_STATE {
        INITIALISED,
        INITIALISING,
        UNINITIALISED;

    }
}

