/*
 * Decompiled with CFR 0.152.
 */
package io.branch.referral;

class ApkParser {
    public static int endDocTag = 0x100101;
    public static int startTag = 0x100102;
    public static int endTag = 0x100103;

    ApkParser() {
    }

    public String decompressXML(byte[] xml) {
        int xmlTagOff;
        int numbStrings = this.LEW(xml, 16);
        int sitOff = 36;
        int stOff = sitOff + numbStrings * 4;
        for (int ii = xmlTagOff = this.LEW(xml, 12); ii < xml.length - 4; ii += 4) {
            if (this.LEW(xml, ii) != startTag) continue;
            xmlTagOff = ii;
            break;
        }
        int off = xmlTagOff;
        while (off < xml.length) {
            int tag0 = this.LEW(xml, off);
            if (tag0 == startTag) {
                int numbAttrs = this.LEW(xml, off + 28);
                off += 36;
                for (int ii = 0; ii < numbAttrs; ++ii) {
                    String attrValue;
                    int attrNameSi = this.LEW(xml, off + 4);
                    int attrValueSi = this.LEW(xml, off + 8);
                    int attrResId = this.LEW(xml, off + 16);
                    off += 20;
                    String attrName = this.compXmlString(xml, sitOff, stOff, attrNameSi);
                    if (!attrName.equals("scheme")) continue;
                    String string = attrValue = attrValueSi != -1 ? this.compXmlString(xml, sitOff, stOff, attrValueSi) : "resourceID 0x" + Integer.toHexString(attrResId);
                    if (!this.validURI(attrValue)) continue;
                    return attrValue;
                }
                continue;
            }
            if (tag0 == endTag) {
                off += 24;
                continue;
            }
            if (tag0 == endDocTag) break;
        }
        return "bnc_no_value";
    }

    private boolean validURI(String value) {
        return value != null && !value.equals("http") && !value.equals("https") && !value.equals("geo") && !value.equals("*") && !value.equals("package") && !value.equals("sms") && !value.equals("smsto") && !value.equals("mms") && !value.equals("mmsto") && !value.equals("tel") && !value.equals("voicemail") && !value.equals("file") && !value.equals("content") && !value.equals("mailto");
    }

    public String compXmlString(byte[] xml, int sitOff, int stOff, int strInd) {
        if (strInd < 0) {
            return null;
        }
        int strOff = stOff + this.LEW(xml, sitOff + strInd * 4);
        return this.compXmlStringAt(xml, strOff);
    }

    public String compXmlStringAt(byte[] arr, int strOff) {
        int strLen = arr[strOff + 1] << 8 & 0xFF00 | arr[strOff] & 0xFF;
        byte[] chars = new byte[strLen];
        for (int ii = 0; ii < strLen; ++ii) {
            chars[ii] = arr[strOff + 2 + ii * 2];
        }
        return new String(chars);
    }

    public int LEW(byte[] arr, int off) {
        return arr[off + 3] << 24 & 0xFF000000 | arr[off + 2] << 16 & 0xFF0000 | arr[off + 1] << 8 & 0xFF00 | arr[off] & 0xFF;
    }
}

