/*
 * Decompiled with CFR 0.152.
 */
package io.branch.indexing;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.TextView;
import io.branch.indexing.ContentDiscoveryManifest;
import io.branch.referral.PrefHelper;
import java.lang.ref.WeakReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentDiscoverer {
    private static ContentDiscoverer thisInstance_;
    private Handler handler_;
    private WeakReference<Activity> lastActivityReference_;
    private static final int VIEW_SETTLE_TIME = 1000;
    private static final int SCROLL_SETTLE_TIME = 1500;
    private String referredUrl_;
    private JSONObject contentEvent_;
    private int discoveryRepeatCnt_;
    private int maxDiscoveryRepeatCnt = 15;
    private static final String TIME_STAMP_KEY = "ts";
    private static final String TIME_STAMP_CLOSE_KEY = "tc";
    private static final String NAV_PATH_KEY = "n";
    private static final String REFERRAL_LINK_KEY = "rl";
    private static final String CONTENT_LINK_KEY = "cl";
    private static final String CONTENT_META_DATA_KEY = "cm";
    private static final String VIEW_KEY = "v";
    private static final String CONTENT_DATA_KEY = "cd";
    private static final String CONTENT_KEYS_KEY = "ck";
    private static final String PACKAGE_NAME_KEY = "p";
    private static final String ENTITIES_KEY = "e";
    private static final String COLLECTION_VIEW_KEY_PREFIX = "$";
    private static final String ENABLE_SCROLL_WATCH = "bnc_esw";
    private static final String RECYCLER_VIEW = "RecyclerView";
    private final HashHelper hashHelper_;
    private ContentDiscoveryManifest cdManifest_;
    private final Map<String, WeakReference<ViewTreeObserver>> viewTreeObserverMap;
    private ArrayList<String> discoveredViewList_ = new ArrayList();
    private Runnable readContentRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                ContentDiscoverer.this.discoveryRepeatCnt_++;
                if (ContentDiscoverer.this.cdManifest_.isCDEnabled() && ContentDiscoverer.this.lastActivityReference_ != null && ContentDiscoverer.this.lastActivityReference_.get() != null) {
                    Activity activity = (Activity)ContentDiscoverer.this.lastActivityReference_.get();
                    ContentDiscoverer.this.contentEvent_ = new JSONObject();
                    ContentDiscoverer.this.contentEvent_.put(ContentDiscoverer.TIME_STAMP_KEY, System.currentTimeMillis());
                    if (!TextUtils.isEmpty((CharSequence)ContentDiscoverer.this.referredUrl_)) {
                        ContentDiscoverer.this.contentEvent_.put(ContentDiscoverer.REFERRAL_LINK_KEY, (Object)ContentDiscoverer.this.referredUrl_);
                    }
                    String viewName = "/" + activity.getClass().getSimpleName();
                    ContentDiscoverer.this.contentEvent_.put(ContentDiscoverer.VIEW_KEY, (Object)viewName);
                    ViewGroup rootView = (ViewGroup)activity.findViewById(0x1020002);
                    if (rootView != null) {
                        JSONArray contentKeysArray;
                        ContentDiscoveryManifest.CDPathProperties cdPathProperties = ContentDiscoverer.this.cdManifest_.getCDPathProperties(activity);
                        boolean isClearText = cdPathProperties != null && cdPathProperties.isClearTextRequested();
                        JSONArray filteredElements = null;
                        if (cdPathProperties != null) {
                            isClearText = cdPathProperties.isClearTextRequested();
                            ContentDiscoverer.this.contentEvent_.put("h", !isClearText);
                            filteredElements = cdPathProperties.getFilteredElements();
                        }
                        if (filteredElements != null && filteredElements.length() > 0) {
                            contentKeysArray = new JSONArray();
                            ContentDiscoverer.this.contentEvent_.put(ContentDiscoverer.CONTENT_KEYS_KEY, (Object)contentKeysArray);
                            JSONArray contentDataArray = new JSONArray();
                            ContentDiscoverer.this.contentEvent_.put(ContentDiscoverer.CONTENT_DATA_KEY, (Object)contentDataArray);
                            ContentDiscoverer.this.discoverContentData(filteredElements, contentDataArray, contentKeysArray, activity, isClearText);
                        } else if (!ContentDiscoverer.this.discoveredViewList_.contains(viewName)) {
                            contentKeysArray = new JSONArray();
                            ContentDiscoverer.this.contentEvent_.put(ContentDiscoverer.CONTENT_KEYS_KEY, (Object)contentKeysArray);
                            ContentDiscoverer.this.discoverContentKeys(rootView, contentKeysArray, activity.getResources());
                        }
                        ContentDiscoverer.this.discoveredViewList_.add(viewName);
                        PrefHelper.getInstance((Context)activity).saveBranchAnalyticsData(ContentDiscoverer.this.contentEvent_);
                        int discoveryRepeatTime = ContentDiscoverer.this.cdManifest_.getCDPathProperties(activity).getDiscoveryRepeatInterval();
                        ContentDiscoverer.this.maxDiscoveryRepeatCnt = ContentDiscoverer.this.cdManifest_.getCDPathProperties(activity).getMaxDiscoveryRepeatNumber();
                        if (ContentDiscoverer.this.discoveryRepeatCnt_ < ContentDiscoverer.this.maxDiscoveryRepeatCnt && discoveryRepeatTime >= 500 && filteredElements != null && filteredElements.length() > 0) {
                            ContentDiscoverer.this.handler_.postDelayed(ContentDiscoverer.this.readContentRunnable, (long)discoveryRepeatTime);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private ViewTreeObserver.OnScrollChangedListener scrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

        public void onScrollChanged() {
            ContentDiscoverer.this.handler_.removeCallbacks(ContentDiscoverer.this.readListRunnable);
            if (ContentDiscoverer.this.maxDiscoveryRepeatCnt > ContentDiscoverer.this.discoveryRepeatCnt_) {
                ContentDiscoverer.this.handler_.postDelayed(ContentDiscoverer.this.readListRunnable, 1500L);
            }
        }
    };
    private Runnable readListRunnable = new Runnable(){

        @Override
        public void run() {
            ContentDiscoverer.this.readContentRunnable.run();
        }
    };

    public static ContentDiscoverer getInstance() {
        if (thisInstance_ == null) {
            thisInstance_ = new ContentDiscoverer();
        }
        return thisInstance_;
    }

    private ContentDiscoverer() {
        this.handler_ = new Handler();
        this.hashHelper_ = new HashHelper();
        this.viewTreeObserverMap = new HashMap<String, WeakReference<ViewTreeObserver>>();
    }

    public void discoverContent(Activity activity, String referredUrl) {
        this.cdManifest_ = ContentDiscoveryManifest.getInstance((Context)activity);
        this.referredUrl_ = referredUrl;
        ContentDiscoveryManifest.CDPathProperties pathProperties = this.cdManifest_.getCDPathProperties(activity);
        if (pathProperties != null) {
            if (!pathProperties.isSkipContentDiscovery()) {
                this.discoverContent(activity);
            }
        } else if (!TextUtils.isEmpty((CharSequence)this.referredUrl_)) {
            this.discoverContent(activity);
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.lastActivityReference_ != null && this.lastActivityReference_.get() != null && ((Activity)this.lastActivityReference_.get()).getClass().getName().equals(activity.getClass().getName())) {
            this.handler_.removeCallbacks(this.readContentRunnable);
            this.lastActivityReference_ = null;
        }
        this.updateLastViewTimeStampIfNeeded();
        for (WeakReference<ViewTreeObserver> viewTreeObserverRef : this.viewTreeObserverMap.values()) {
            ViewTreeObserver observer = (ViewTreeObserver)viewTreeObserverRef.get();
            if (observer == null) continue;
            observer.removeOnScrollChangedListener(this.scrollChangedListener);
        }
        this.viewTreeObserverMap.clear();
    }

    public void onSessionStarted(Activity activity, String referredUrl) {
        this.discoveredViewList_ = new ArrayList();
        this.discoverContent(activity, referredUrl);
    }

    private void discoverContent(Activity activity) {
        this.discoveryRepeatCnt_ = 0;
        if (this.discoveredViewList_.size() < this.cdManifest_.getMaxViewHistorySize()) {
            this.handler_.removeCallbacks(this.readContentRunnable);
            this.lastActivityReference_ = new WeakReference<Activity>(activity);
            this.handler_.postDelayed(this.readContentRunnable, 1000L);
        }
    }

    private void updateLastViewTimeStampIfNeeded() {
        try {
            if (this.contentEvent_ != null) {
                this.contentEvent_.put(TIME_STAMP_CLOSE_KEY, System.currentTimeMillis());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void discoverContentKeys(ViewGroup viewGroup, JSONArray contentKeysArray, Resources res) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View childView = viewGroup.getChildAt(i);
            if (childView.getVisibility() != 0) continue;
            if (childView instanceof AbsListView || childView.getClass().getSimpleName().equals(RECYCLER_VIEW)) {
                this.discoverListViewContentKeys((ViewGroup)childView, res, contentKeysArray);
                continue;
            }
            if (childView instanceof ViewGroup) {
                this.discoverContentKeys((ViewGroup)childView, contentKeysArray, res);
                continue;
            }
            if (!(childView instanceof TextView)) continue;
            String viewName = this.getViewName(childView, res);
            contentKeysArray.put((Object)viewName);
        }
    }

    private void discoverListViewContentKeys(ViewGroup listView, Resources res, JSONArray contentKeysArray) {
        View candidateItemView;
        JSONObject absListKeyObj = new JSONObject();
        if (listView != null && listView.getChildCount() > -1 && (candidateItemView = listView.getChildAt(listView.getChildCount() > 1 ? 1 : 0)) != null) {
            JSONArray itemViewArray = new JSONArray();
            try {
                absListKeyObj.put(this.getViewName((View)listView, res), (Object)itemViewArray);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (candidateItemView instanceof ViewGroup) {
                this.discoverContentKeys((ViewGroup)candidateItemView, itemViewArray, res);
            } else if (candidateItemView instanceof TextView) {
                itemViewArray.put((Object)this.getViewName(candidateItemView, res));
            }
            if (absListKeyObj.length() > 0) {
                contentKeysArray.put((Object)(COLLECTION_VIEW_KEY_PREFIX + absListKeyObj));
            }
        }
    }

    private void discoverContentData(JSONArray viewIDArray, JSONArray contentDataArray, JSONArray contentKeysArray, Activity activity, boolean isClearText) {
        try {
            for (int i = 0; i < viewIDArray.length(); ++i) {
                String viewName = viewIDArray.getString(i);
                if (viewName.startsWith(COLLECTION_VIEW_KEY_PREFIX)) {
                    this.discoverListViewContentData(viewName, activity, isClearText, contentDataArray, contentKeysArray);
                    continue;
                }
                int id2 = activity.getResources().getIdentifier(viewIDArray.getString(i), "id", activity.getPackageName());
                View childView = activity.findViewById(id2);
                this.updateElementData(viewName, childView, isClearText, contentDataArray, contentKeysArray);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void discoverListViewContentData(String viewKeyString, Activity activity, boolean isClearText, JSONArray contentDataArray, JSONArray contentKeysArray) {
        JSONObject listViewContentObj = new JSONObject();
        contentKeysArray.put((Object)viewKeyString);
        contentDataArray.put((Object)listViewContentObj);
        viewKeyString = viewKeyString.replace(COLLECTION_VIEW_KEY_PREFIX, "");
        try {
            JSONObject viewKeyJson = new JSONObject(viewKeyString);
            if (viewKeyJson.length() > 0) {
                View view;
                String listViewID = (String)viewKeyJson.keys().next();
                int id2 = activity.getResources().getIdentifier(listViewID, "id", activity.getPackageName());
                View view2 = view = activity.getCurrentFocus() != null ? activity.getCurrentFocus().findViewById(id2) : null;
                if (view == null) {
                    view = activity.findViewById(id2);
                }
                if (view != null && view instanceof ViewGroup) {
                    boolean isScrollListeningEnabled;
                    ViewGroup listView = (ViewGroup)view;
                    JSONArray itemViewChildIdArray = viewKeyJson.getJSONArray(listViewID);
                    int[] itemViewIds = new int[itemViewChildIdArray.length()];
                    for (int i = 0; i < itemViewChildIdArray.length(); ++i) {
                        itemViewIds[i] = activity.getResources().getIdentifier(itemViewChildIdArray.getString(i), "id", activity.getPackageName());
                    }
                    int firstVisibleItemIdx = listView instanceof AbsListView ? ((AbsListView)listView).getFirstVisiblePosition() : 0;
                    for (int j = 0; j < listView.getChildCount(); ++j) {
                        if (listView.getChildAt(j) == null) continue;
                        JSONObject itemObj = new JSONObject();
                        listViewContentObj.put("" + (j + firstVisibleItemIdx), (Object)itemObj);
                        for (int i = 0; i < itemViewIds.length; ++i) {
                            View itemViewChild;
                            if (listView.getChildAt(j) == null || !((itemViewChild = listView.getChildAt(j).findViewById(itemViewIds[i])) instanceof TextView)) continue;
                            itemObj.put(itemViewChildIdArray.getString(i), (Object)this.getTextViewValue(itemViewChild, isClearText));
                        }
                    }
                    boolean bl = isScrollListeningEnabled = viewKeyJson.has(ENABLE_SCROLL_WATCH) && viewKeyJson.getBoolean(ENABLE_SCROLL_WATCH);
                    if (isScrollListeningEnabled && !this.viewTreeObserverMap.containsKey(viewKeyString)) {
                        listView.getViewTreeObserver().addOnScrollChangedListener(this.scrollChangedListener);
                        this.viewTreeObserverMap.put(viewKeyString, new WeakReference<ViewTreeObserver>(listView.getViewTreeObserver()));
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private String getViewName(View view, Resources res) {
        String viewName = String.valueOf(view.getId());
        try {
            viewName = res.getResourceEntryName(view.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return viewName;
    }

    private String getTextViewValue(View view, boolean isClearText) {
        String viewVal = null;
        TextView txtView = (TextView)view;
        if (txtView.getText() != null) {
            viewVal = txtView.getText().toString().substring(0, Math.min(txtView.getText().toString().length(), this.cdManifest_.getMaxTextLen()));
            viewVal = isClearText ? viewVal : this.hashHelper_.hashContent(viewVal);
        }
        return viewVal;
    }

    private void updateElementData(String viewName, View view, boolean isClearText, JSONArray contentDataArray, JSONArray contentKeysArray) {
        if (view instanceof TextView) {
            String viewVal = this.getTextViewValue(view, isClearText);
            contentDataArray.put((Object)viewVal);
            contentKeysArray.put((Object)viewName);
        }
    }

    public JSONObject getContentDiscoverDataForCloseRequest(Context context) {
        JSONObject cdObj = null;
        JSONObject branchAnalyticalData = PrefHelper.getInstance(context).getBranchAnalyticsData();
        if (branchAnalyticalData.length() > 0 && branchAnalyticalData.toString().length() < this.cdManifest_.getMaxPacketSize()) {
            cdObj = new JSONObject();
            try {
                ContentDiscoveryManifest cdManifest = ContentDiscoveryManifest.getInstance(context);
                cdObj.put("mv", (Object)cdManifest.getManifestVersion()).put(ENTITIES_KEY, (Object)branchAnalyticalData);
                if (context != null) {
                    cdObj.put(PACKAGE_NAME_KEY, (Object)context.getPackageName());
                    cdObj.put(PACKAGE_NAME_KEY, (Object)context.getPackageName());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        PrefHelper.getInstance(context).clearBranchAnalyticsData();
        return cdObj;
    }

    private class HashHelper {
        MessageDigest messageDigest_;

        HashHelper() {
            try {
                this.messageDigest_ = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }

        String hashContent(String content) {
            String hashedVal = "";
            if (this.messageDigest_ != null) {
                this.messageDigest_.reset();
                this.messageDigest_.update(content.getBytes());
                hashedVal = new String(this.messageDigest_.digest());
            }
            return hashedVal;
        }
    }
}

