/*
 * Decompiled with CFR 0.152.
 */
package io.branch.indexing;

import android.app.Activity;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import io.branch.indexing.AppIndexingHelper;
import io.branch.referral.Branch;
import io.branch.referral.BranchError;
import io.branch.referral.BranchShortLinkBuilder;
import io.branch.referral.Defines;
import io.branch.referral.util.CurrencyType;
import io.branch.referral.util.LinkProperties;
import io.branch.referral.util.ShareSheetStyle;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BranchUniversalObject
implements Parcelable {
    private String canonicalIdentifier_ = "";
    private String canonicalUrl_ = "";
    private String title_ = "";
    private String description_ = "";
    private String imageUrl_;
    private final HashMap<String, String> metadata_ = new HashMap();
    private String type_ = "";
    private CONTENT_INDEX_MODE indexMode_;
    private final ArrayList<String> keywords_ = new ArrayList();
    private long expirationInMilliSec_ = 0L;
    private Double price_;
    private CurrencyType currency_;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public BranchUniversalObject createFromParcel(Parcel in) {
            return new BranchUniversalObject(in);
        }

        public BranchUniversalObject[] newArray(int size) {
            return new BranchUniversalObject[size];
        }
    };

    public BranchUniversalObject() {
        this.indexMode_ = CONTENT_INDEX_MODE.PUBLIC;
        this.currency_ = CurrencyType.USD;
    }

    public BranchUniversalObject setCanonicalIdentifier(@NonNull String canonicalIdentifier) {
        this.canonicalIdentifier_ = canonicalIdentifier;
        return this;
    }

    public BranchUniversalObject setCanonicalUrl(@NonNull String canonicalUrl) {
        this.canonicalUrl_ = canonicalUrl;
        return this;
    }

    public BranchUniversalObject setTitle(@NonNull String title) {
        this.title_ = title;
        return this;
    }

    public BranchUniversalObject setContentDescription(String description) {
        this.description_ = description;
        return this;
    }

    public BranchUniversalObject setContentImageUrl(@NonNull String imageUrl) {
        this.imageUrl_ = imageUrl;
        return this;
    }

    public BranchUniversalObject addContentMetadata(HashMap<String, String> metadata) {
        this.metadata_.putAll(metadata);
        return this;
    }

    public BranchUniversalObject addContentMetadata(String key, String value) {
        this.metadata_.put(key, value);
        return this;
    }

    public BranchUniversalObject setContentType(String type) {
        this.type_ = type;
        return this;
    }

    public BranchUniversalObject setContentIndexingMode(CONTENT_INDEX_MODE indexMode) {
        this.indexMode_ = indexMode;
        return this;
    }

    public BranchUniversalObject addKeyWords(ArrayList<String> keywords) {
        this.keywords_.addAll(keywords);
        return this;
    }

    public BranchUniversalObject addKeyWord(String keyword) {
        this.keywords_.add(keyword);
        return this;
    }

    public BranchUniversalObject setContentExpiration(Date expirationDate) {
        this.expirationInMilliSec_ = expirationDate.getTime();
        return this;
    }

    public BranchUniversalObject setPrice(double price, CurrencyType currency) {
        this.price_ = price;
        this.currency_ = currency;
        return this;
    }

    public void listOnGoogleSearch(Context context) {
        AppIndexingHelper.addToAppIndex(context, this);
    }

    public void userCompletedAction(String action) {
        this.userCompletedAction(action, null);
    }

    public void userCompletedAction(String action, HashMap<String, String> metadata) {
        JSONObject actionCompletedPayload = new JSONObject();
        try {
            JSONArray canonicalIDList = new JSONArray();
            canonicalIDList.put((Object)this.canonicalIdentifier_);
            actionCompletedPayload.put("$canonical_identifier_list", (Object)canonicalIDList);
            actionCompletedPayload.put(this.canonicalIdentifier_, (Object)this.convertToJson());
            if (metadata != null) {
                for (String key : metadata.keySet()) {
                    actionCompletedPayload.put(key, (Object)metadata.get(key));
                }
            }
            if (Branch.getInstance() != null) {
                Branch.getInstance().userCompletedAction(action, actionCompletedPayload);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public boolean isPublicallyIndexable() {
        return this.indexMode_ == CONTENT_INDEX_MODE.PUBLIC;
    }

    public HashMap<String, String> getMetadata() {
        return this.metadata_;
    }

    public long getExpirationTime() {
        return this.expirationInMilliSec_;
    }

    public String getCanonicalIdentifier() {
        return this.canonicalIdentifier_;
    }

    public String getCanonicalUrl() {
        return this.canonicalUrl_;
    }

    public String getDescription() {
        return this.description_;
    }

    public String getImageUrl() {
        return this.imageUrl_;
    }

    public String getTitle() {
        return this.title_;
    }

    public String getType() {
        return this.type_;
    }

    public double getPrice() {
        return this.price_ != null ? this.price_ : 0.0;
    }

    public String getCurrencyType() {
        return this.currency_.toString();
    }

    public JSONArray getKeywordsJsonArray() {
        JSONArray keywordArray = new JSONArray();
        for (String keyword : this.keywords_) {
            keywordArray.put((Object)keyword);
        }
        return keywordArray;
    }

    public ArrayList<String> getKeywords() {
        return this.keywords_;
    }

    public void registerView() {
        this.registerView(null);
    }

    public void registerView(@Nullable RegisterViewStatusListener callback) {
        if (Branch.getInstance() != null) {
            Branch.getInstance().registerView(this, callback);
        } else if (callback != null) {
            callback.onRegisterViewFinished(false, new BranchError("Register view error", -109));
        }
    }

    public String getShortUrl(@NonNull Context context, @NonNull LinkProperties linkProperties) {
        return this.getLinkBuilder(context, linkProperties).getShortUrl();
    }

    public String getShortUrl(@NonNull Context context, @NonNull LinkProperties linkProperties, boolean defaultToLongUrl) {
        return ((BranchShortLinkBuilder)this.getLinkBuilder(context, linkProperties).setDefaultToLongUrl(defaultToLongUrl)).getShortUrl();
    }

    public void generateShortUrl(@NonNull Context context, @NonNull LinkProperties linkProperties, @Nullable Branch.BranchLinkCreateListener callback) {
        this.getLinkBuilder(context, linkProperties).generateShortUrl(callback);
    }

    public void generateShortUrl(@NonNull Context context, @NonNull LinkProperties linkProperties, @Nullable Branch.BranchLinkCreateListener callback, boolean defaultToLongUrl) {
        ((BranchShortLinkBuilder)this.getLinkBuilder(context, linkProperties).setDefaultToLongUrl(defaultToLongUrl)).generateShortUrl(callback);
    }

    public void showShareSheet(@NonNull Activity activity, @NonNull LinkProperties linkProperties, @NonNull ShareSheetStyle style, @Nullable Branch.BranchLinkShareListener callback) {
        this.showShareSheet(activity, linkProperties, style, callback, null);
    }

    public void showShareSheet(@NonNull Activity activity, @NonNull LinkProperties linkProperties, @NonNull ShareSheetStyle style, @Nullable Branch.BranchLinkShareListener callback, Branch.IChannelProperties channelProperties) {
        if (Branch.getInstance() == null) {
            if (callback != null) {
                callback.onLinkShareResponse(null, null, new BranchError("Trouble sharing link. ", -109));
            } else {
                Log.e((String)"BranchSDK", (String)"Sharing error. Branch instance is not created yet. Make sure you have initialised Branch.");
            }
        } else {
            Branch.ShareLinkBuilder shareLinkBuilder = new Branch.ShareLinkBuilder(activity, this.getLinkBuilder((Context)activity, linkProperties)).setCallback(new LinkShareListenerWrapper(callback)).setChannelProperties(channelProperties).setSubject(style.getMessageTitle()).setMessage(style.getMessageBody());
            if (style.getCopyUrlIcon() != null) {
                shareLinkBuilder.setCopyUrlStyle(style.getCopyUrlIcon(), style.getCopyURlText(), style.getUrlCopiedMessage());
            }
            if (style.getMoreOptionIcon() != null) {
                shareLinkBuilder.setMoreOptionStyle(style.getMoreOptionIcon(), style.getMoreOptionText());
            }
            if (style.getDefaultURL() != null) {
                shareLinkBuilder.setDefaultURL(style.getDefaultURL());
            }
            if (style.getPreferredOptions().size() > 0) {
                shareLinkBuilder.addPreferredSharingOptions(style.getPreferredOptions());
            }
            if (style.getStyleResourceID() > 0) {
                shareLinkBuilder.setStyleResourceID(style.getStyleResourceID());
            }
            shareLinkBuilder.setDividerHeight(style.getDividerHeight());
            shareLinkBuilder.setAsFullWidthStyle(style.getIsFullWidthStyle());
            shareLinkBuilder.setSharingTitle(style.getSharingTitle());
            shareLinkBuilder.setSharingTitle(style.getSharingTitleView());
            if (style.getIncludedInShareSheet() != null && style.getIncludedInShareSheet().size() > 0) {
                shareLinkBuilder.includeInShareSheet(style.getIncludedInShareSheet());
            }
            if (style.getExcludedFromShareSheet() != null && style.getExcludedFromShareSheet().size() > 0) {
                shareLinkBuilder.excludeFromShareSheet(style.getExcludedFromShareSheet());
            }
            shareLinkBuilder.shareLink();
        }
    }

    private BranchShortLinkBuilder getLinkBuilder(@NonNull Context context, @NonNull LinkProperties linkProperties) {
        JSONArray keywords;
        BranchShortLinkBuilder shortLinkBuilder = new BranchShortLinkBuilder(context);
        if (linkProperties.getTags() != null) {
            shortLinkBuilder.addTags(linkProperties.getTags());
        }
        if (linkProperties.getFeature() != null) {
            shortLinkBuilder.setFeature(linkProperties.getFeature());
        }
        if (linkProperties.getAlias() != null) {
            shortLinkBuilder.setAlias(linkProperties.getAlias());
        }
        if (linkProperties.getChannel() != null) {
            shortLinkBuilder.setChannel(linkProperties.getChannel());
        }
        if (linkProperties.getStage() != null) {
            shortLinkBuilder.setStage(linkProperties.getStage());
        }
        if (linkProperties.getCampaign() != null) {
            shortLinkBuilder.setCampaign(linkProperties.getCampaign());
        }
        if (linkProperties.getMatchDuration() > 0) {
            shortLinkBuilder.setDuration(linkProperties.getMatchDuration());
        }
        if (!TextUtils.isEmpty((CharSequence)this.title_)) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.ContentTitle.getKey(), this.title_);
        }
        if (!TextUtils.isEmpty((CharSequence)this.canonicalIdentifier_)) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.CanonicalIdentifier.getKey(), this.canonicalIdentifier_);
        }
        if (!TextUtils.isEmpty((CharSequence)this.canonicalUrl_)) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.CanonicalUrl.getKey(), this.canonicalUrl_);
        }
        if ((keywords = this.getKeywordsJsonArray()).length() > 0) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.ContentKeyWords.getKey(), keywords);
        }
        if (!TextUtils.isEmpty((CharSequence)this.description_)) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.ContentDesc.getKey(), this.description_);
        }
        if (!TextUtils.isEmpty((CharSequence)this.imageUrl_)) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.ContentImgUrl.getKey(), this.imageUrl_);
        }
        if (!TextUtils.isEmpty((CharSequence)this.type_)) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.ContentType.getKey(), this.type_);
        }
        if (this.expirationInMilliSec_ > 0L) {
            shortLinkBuilder.addParameters(Defines.Jsonkey.ContentExpiryTime.getKey(), "" + this.expirationInMilliSec_);
        }
        shortLinkBuilder.addParameters(Defines.Jsonkey.PublicallyIndexable.getKey(), "" + this.isPublicallyIndexable());
        if (this.price_ != null) {
            shortLinkBuilder.addParameters("$amount", "" + this.price_);
            shortLinkBuilder.addParameters("$currency", this.currency_.toString());
        }
        for (String key : this.metadata_.keySet()) {
            shortLinkBuilder.addParameters(key, this.metadata_.get(key));
        }
        HashMap<String, String> controlParam = linkProperties.getControlParams();
        for (String key : controlParam.keySet()) {
            shortLinkBuilder.addParameters(key, controlParam.get(key));
        }
        return shortLinkBuilder;
    }

    public static BranchUniversalObject getReferredBranchUniversalObject() {
        BranchUniversalObject branchUniversalObject = null;
        Branch branchInstance = Branch.getInstance();
        try {
            if (branchInstance != null && branchInstance.getLatestReferringParams() != null) {
                if (branchInstance.getLatestReferringParams().has("+clicked_branch_link") && branchInstance.getLatestReferringParams().getBoolean("+clicked_branch_link")) {
                    branchUniversalObject = BranchUniversalObject.createInstance(branchInstance.getLatestReferringParams());
                } else if (branchInstance.getDeeplinkDebugParams() != null && branchInstance.getDeeplinkDebugParams().length() > 0) {
                    branchUniversalObject = BranchUniversalObject.createInstance(branchInstance.getLatestReferringParams());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return branchUniversalObject;
    }

    public static BranchUniversalObject createInstance(JSONObject jsonObject) {
        BranchUniversalObject branchUniversalObject = null;
        try {
            branchUniversalObject = new BranchUniversalObject();
            if (jsonObject.has(Defines.Jsonkey.ContentTitle.getKey())) {
                branchUniversalObject.title_ = jsonObject.getString(Defines.Jsonkey.ContentTitle.getKey());
            }
            if (jsonObject.has(Defines.Jsonkey.CanonicalIdentifier.getKey())) {
                branchUniversalObject.canonicalIdentifier_ = jsonObject.getString(Defines.Jsonkey.CanonicalIdentifier.getKey());
            }
            if (jsonObject.has(Defines.Jsonkey.CanonicalUrl.getKey())) {
                branchUniversalObject.canonicalUrl_ = jsonObject.getString(Defines.Jsonkey.CanonicalUrl.getKey());
            }
            if (jsonObject.has(Defines.Jsonkey.ContentDesc.getKey())) {
                branchUniversalObject.description_ = jsonObject.getString(Defines.Jsonkey.ContentDesc.getKey());
            }
            if (jsonObject.has(Defines.Jsonkey.ContentImgUrl.getKey())) {
                branchUniversalObject.imageUrl_ = jsonObject.getString(Defines.Jsonkey.ContentImgUrl.getKey());
            }
            if (jsonObject.has(Defines.Jsonkey.ContentType.getKey())) {
                branchUniversalObject.type_ = jsonObject.getString(Defines.Jsonkey.ContentType.getKey());
            }
            if (jsonObject.has(Defines.Jsonkey.ContentExpiryTime.getKey())) {
                branchUniversalObject.expirationInMilliSec_ = jsonObject.getLong(Defines.Jsonkey.ContentExpiryTime.getKey());
            }
            if (jsonObject.has("$amount")) {
                branchUniversalObject.price_ = jsonObject.getDouble("$amount");
            }
            if (jsonObject.has("$currency")) {
                branchUniversalObject.currency_ = CurrencyType.valueOf(jsonObject.getString("$currency"));
            }
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                branchUniversalObject.addContentMetadata(key, jsonObject.getString(key));
            }
            if (jsonObject.has(Defines.Jsonkey.ContentKeyWords.getKey())) {
                JSONArray keywordJsonArray = null;
                Object keyWordArrayObject = jsonObject.get(Defines.Jsonkey.ContentKeyWords.getKey());
                if (keyWordArrayObject instanceof JSONArray) {
                    keywordJsonArray = (JSONArray)keyWordArrayObject;
                } else if (keyWordArrayObject instanceof String) {
                    keywordJsonArray = new JSONArray((String)keyWordArrayObject);
                }
                if (keywordJsonArray != null) {
                    for (int i = 0; i < keywordJsonArray.length(); ++i) {
                        branchUniversalObject.keywords_.add((String)keywordJsonArray.get(i));
                    }
                }
            }
            if (jsonObject.has(Defines.Jsonkey.PublicallyIndexable.getKey())) {
                try {
                    branchUniversalObject.indexMode_ = jsonObject.getBoolean(Defines.Jsonkey.PublicallyIndexable.getKey()) ? CONTENT_INDEX_MODE.PUBLIC : CONTENT_INDEX_MODE.PRIVATE;
                }
                catch (JSONException ignore) {
                    branchUniversalObject.indexMode_ = jsonObject.getInt(Defines.Jsonkey.PublicallyIndexable.getKey()) == 1 ? CONTENT_INDEX_MODE.PUBLIC : CONTENT_INDEX_MODE.PRIVATE;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return branchUniversalObject;
    }

    public JSONObject convertToJson() {
        JSONObject buoJsonModel = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)this.title_)) {
                buoJsonModel.put(Defines.Jsonkey.ContentTitle.getKey(), (Object)this.title_);
            }
            if (!TextUtils.isEmpty((CharSequence)this.canonicalIdentifier_)) {
                buoJsonModel.put(Defines.Jsonkey.CanonicalIdentifier.getKey(), (Object)this.canonicalIdentifier_);
            }
            if (!TextUtils.isEmpty((CharSequence)this.canonicalUrl_)) {
                buoJsonModel.put(Defines.Jsonkey.CanonicalUrl.getKey(), (Object)this.canonicalUrl_);
            }
            if (this.keywords_.size() > 0) {
                JSONArray keyWordJsonArray = new JSONArray();
                for (String keyword : this.keywords_) {
                    keyWordJsonArray.put((Object)keyword);
                }
                buoJsonModel.put(Defines.Jsonkey.ContentKeyWords.getKey(), (Object)keyWordJsonArray);
            }
            if (!TextUtils.isEmpty((CharSequence)this.description_)) {
                buoJsonModel.put(Defines.Jsonkey.ContentDesc.getKey(), (Object)this.description_);
            }
            if (!TextUtils.isEmpty((CharSequence)this.imageUrl_)) {
                buoJsonModel.put(Defines.Jsonkey.ContentImgUrl.getKey(), (Object)this.imageUrl_);
            }
            if (!TextUtils.isEmpty((CharSequence)this.type_)) {
                buoJsonModel.put(Defines.Jsonkey.ContentType.getKey(), (Object)this.type_);
            }
            if (this.expirationInMilliSec_ > 0L) {
                buoJsonModel.put(Defines.Jsonkey.ContentExpiryTime.getKey(), this.expirationInMilliSec_);
            }
            buoJsonModel.put(Defines.Jsonkey.PublicallyIndexable.getKey(), this.isPublicallyIndexable());
            if (this.price_ != null) {
                buoJsonModel.put("$amount", (Object)this.price_);
                buoJsonModel.put("$currency", (Object)this.currency_.toString());
            }
            Set<String> metadataKeys = this.metadata_.keySet();
            for (String metadataKey : metadataKeys) {
                buoJsonModel.put(metadataKey, (Object)this.metadata_.get(metadataKey));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return buoJsonModel;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.canonicalIdentifier_);
        dest.writeString(this.canonicalUrl_);
        dest.writeString(this.title_);
        dest.writeString(this.description_);
        dest.writeString(this.imageUrl_);
        dest.writeString(this.type_);
        dest.writeLong(this.expirationInMilliSec_);
        dest.writeInt(this.indexMode_.ordinal());
        double priceVal = this.price_ != null ? this.price_ : -1.0;
        dest.writeDouble(priceVal);
        dest.writeInt(this.currency_.ordinal());
        dest.writeSerializable(this.keywords_);
        int metaDataSize = this.metadata_.size();
        dest.writeInt(metaDataSize);
        for (Map.Entry<String, String> entry : this.metadata_.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
    }

    private BranchUniversalObject(Parcel in) {
        this();
        this.canonicalIdentifier_ = in.readString();
        this.canonicalUrl_ = in.readString();
        this.title_ = in.readString();
        this.description_ = in.readString();
        this.imageUrl_ = in.readString();
        this.type_ = in.readString();
        this.expirationInMilliSec_ = in.readLong();
        this.indexMode_ = CONTENT_INDEX_MODE.values()[in.readInt()];
        this.price_ = in.readDouble();
        if (this.price_ < 0.0) {
            this.price_ = null;
        }
        this.currency_ = CurrencyType.values()[in.readInt()];
        ArrayList keywordsTemp = (ArrayList)in.readSerializable();
        this.keywords_.addAll(keywordsTemp);
        int metadataSize = in.readInt();
        for (int i = 0; i < metadataSize; ++i) {
            this.metadata_.put(in.readString(), in.readString());
        }
    }

    private class LinkShareListenerWrapper
    implements Branch.BranchLinkShareListener {
        private final Branch.BranchLinkShareListener originalCallback_;

        public LinkShareListenerWrapper(Branch.BranchLinkShareListener originalCallback) {
            this.originalCallback_ = originalCallback;
        }

        @Override
        public void onShareLinkDialogLaunched() {
            BranchUniversalObject.this.userCompletedAction("Share Started");
            if (this.originalCallback_ != null) {
                this.originalCallback_.onShareLinkDialogLaunched();
            }
        }

        @Override
        public void onShareLinkDialogDismissed() {
            if (this.originalCallback_ != null) {
                this.originalCallback_.onShareLinkDialogDismissed();
            }
        }

        @Override
        public void onLinkShareResponse(String sharedLink, String sharedChannel, BranchError error) {
            HashMap<String, String> metaData = new HashMap<String, String>();
            if (error == null) {
                metaData.put(Defines.Jsonkey.SharedLink.getKey(), sharedLink);
            } else {
                metaData.put(Defines.Jsonkey.ShareError.getKey(), error.getMessage());
            }
            BranchUniversalObject.this.userCompletedAction("Share Completed", metaData);
            if (this.originalCallback_ != null) {
                this.originalCallback_.onLinkShareResponse(sharedLink, sharedChannel, error);
            }
        }

        @Override
        public void onChannelSelected(String channelName) {
            if (this.originalCallback_ != null) {
                this.originalCallback_.onChannelSelected(channelName);
            }
        }
    }

    public static interface RegisterViewStatusListener {
        public void onRegisterViewFinished(boolean var1, BranchError var2);
    }

    public static enum CONTENT_INDEX_MODE {
        PUBLIC,
        PRIVATE;

    }
}

