/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers.shim;

import android.util.Log;
import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.answers.shim.KitEvent;
import com.crashlytics.android.answers.shim.KitEventLogger;

class AnswersKitEventLogger
implements KitEventLogger {
    private static final String TAG = "AnswersKitEventLogger";
    private final Answers answers;

    private AnswersKitEventLogger(Answers answers) {
        this.answers = answers;
    }

    public static AnswersKitEventLogger create() throws NoClassDefFoundError, IllegalStateException {
        Answers answers = Answers.getInstance();
        return AnswersKitEventLogger.create(answers);
    }

    static AnswersKitEventLogger create(Answers answers) throws IllegalStateException {
        if (answers == null) {
            throw new IllegalStateException("Answers must be initialized before logging kit events");
        }
        return new AnswersKitEventLogger(answers);
    }

    @Override
    public void logKitEvent(KitEvent kitEvent) {
        try {
            this.answers.logCustom(kitEvent.toCustomEvent());
        }
        catch (Throwable t) {
            Log.w((String)TAG, (String)"Unexpected error sending Answers event", (Throwable)t);
        }
    }
}

