/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.settings;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.CommonUtils;

public class IconRequest {
    public final String hash;
    public final int iconResourceId;
    public final int width;
    public final int height;

    public IconRequest(String hash, int iconResourceId, int width, int height) {
        this.hash = hash;
        this.iconResourceId = iconResourceId;
        this.width = width;
        this.height = height;
    }

    public static IconRequest build(Context context, String iconHash) {
        IconRequest iconRequest = null;
        if (iconHash != null) {
            try {
                int iconId = CommonUtils.getAppIconResourceId(context);
                Fabric.getLogger().d("Fabric", "App icon resource ID is " + iconId);
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeResource((Resources)context.getResources(), (int)iconId, (BitmapFactory.Options)options);
                iconRequest = new IconRequest(iconHash, iconId, options.outWidth, options.outHeight);
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "Failed to load icon", e);
            }
        }
        return iconRequest;
    }
}

