/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.persistence;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import io.fabric.sdk.android.services.persistence.PersistenceStrategy;
import io.fabric.sdk.android.services.persistence.PreferenceStore;
import io.fabric.sdk.android.services.persistence.SerializationStrategy;

public class PreferenceStoreStrategy<T>
implements PersistenceStrategy<T> {
    private final PreferenceStore store;
    private final SerializationStrategy<T> serializer;
    private final String key;

    public PreferenceStoreStrategy(PreferenceStore store, SerializationStrategy<T> serializer, String preferenceKey) {
        this.store = store;
        this.serializer = serializer;
        this.key = preferenceKey;
    }

    @Override
    @SuppressLint(value={"CommitPrefEdits"})
    public void save(T object) {
        this.store.save(this.store.edit().putString(this.key, this.serializer.serialize(object)));
    }

    @Override
    public T restore() {
        SharedPreferences store = this.store.get();
        return this.serializer.deserialize(store.getString(this.key, null));
    }

    @Override
    @SuppressLint(value={"CommitPrefEdits"})
    public void clear() {
        this.store.edit().remove(this.key).commit();
    }
}

