/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.persistence;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.persistence.FileStore;
import java.io.File;

public class FileStoreImpl
implements FileStore {
    private final Context context;
    private final String contentPath;
    private final String legacySupport;

    public FileStoreImpl(Kit kit) {
        if (kit.getContext() == null) {
            throw new IllegalStateException("Cannot get directory before context has been set. Call Fabric.with() first");
        }
        this.context = kit.getContext();
        this.contentPath = kit.getPath();
        this.legacySupport = "Android/" + this.context.getPackageName();
    }

    @Override
    public File getCacheDir() {
        return this.prepare(this.context.getCacheDir());
    }

    @Override
    public File getExternalCacheDir() {
        File file = null;
        if (this.isExternalStorageAvailable()) {
            file = Build.VERSION.SDK_INT >= 8 ? this.context.getExternalCacheDir() : new File(Environment.getExternalStorageDirectory(), this.legacySupport + "/cache/" + this.contentPath);
        }
        return this.prepare(file);
    }

    @Override
    public File getFilesDir() {
        return this.prepare(this.context.getFilesDir());
    }

    @Override
    @TargetApi(value=8)
    public File getExternalFilesDir() {
        File file = null;
        if (this.isExternalStorageAvailable()) {
            file = Build.VERSION.SDK_INT >= 8 ? this.context.getExternalFilesDir(null) : new File(Environment.getExternalStorageDirectory(), this.legacySupport + "/files/" + this.contentPath);
        }
        return this.prepare(file);
    }

    File prepare(File file) {
        if (file != null) {
            if (file.exists() || file.mkdirs()) {
                return file;
            }
            Fabric.getLogger().w("Fabric", "Couldn't create file");
        } else {
            Fabric.getLogger().d("Fabric", "Null File");
        }
        return null;
    }

    boolean isExternalStorageAvailable() {
        String state = Environment.getExternalStorageState();
        if (!"mounted".equals(state)) {
            Fabric.getLogger().w("Fabric", "External Storage is not mounted and/or writable\nHave you declared android.permission.WRITE_EXTERNAL_STORAGE in the manifest?");
            return false;
        }
        return true;
    }
}

