/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.concurrency.internal;

import io.fabric.sdk.android.services.concurrency.internal.AbstractFuture;
import io.fabric.sdk.android.services.concurrency.internal.Backoff;
import io.fabric.sdk.android.services.concurrency.internal.RetryPolicy;
import io.fabric.sdk.android.services.concurrency.internal.RetryState;
import io.fabric.sdk.android.services.concurrency.internal.RetryThreadPoolExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class RetryFuture<T>
extends AbstractFuture<T>
implements Runnable {
    private final RetryThreadPoolExecutor executor;
    private final Callable<T> task;
    private final AtomicReference<Thread> runner;
    RetryState retryState;

    RetryFuture(Callable<T> task, RetryState retryState, RetryThreadPoolExecutor executor) {
        this.task = task;
        this.retryState = retryState;
        this.executor = executor;
        this.runner = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isDone() || !this.runner.compareAndSet(null, Thread.currentThread())) {
            return;
        }
        try {
            T result = this.task.call();
            this.set(result);
        }
        catch (Throwable exception) {
            if (this.getRetryPolicy().shouldRetry(this.getRetryCount(), exception)) {
                long delay = this.getBackoff().getDelayMillis(this.getRetryCount());
                this.retryState = this.retryState.nextRetryState();
                this.executor.schedule(this, delay, TimeUnit.MILLISECONDS);
            } else {
                this.setException(exception);
            }
        }
        finally {
            this.runner.getAndSet(null);
        }
    }

    private RetryPolicy getRetryPolicy() {
        return this.retryState.getRetryPolicy();
    }

    private Backoff getBackoff() {
        return this.retryState.getBackoff();
    }

    private int getRetryCount() {
        return this.retryState.getRetryCount();
    }

    @Override
    protected void interruptTask() {
        Thread thread = this.runner.getAndSet(null);
        if (thread != null) {
            thread.interrupt();
        }
    }
}

