/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.concurrency;

import io.fabric.sdk.android.services.concurrency.AsyncTask;
import io.fabric.sdk.android.services.concurrency.DelegateProvider;
import io.fabric.sdk.android.services.concurrency.Dependency;
import io.fabric.sdk.android.services.concurrency.Priority;
import io.fabric.sdk.android.services.concurrency.PriorityFutureTask;
import io.fabric.sdk.android.services.concurrency.PriorityProvider;
import io.fabric.sdk.android.services.concurrency.PriorityTask;
import io.fabric.sdk.android.services.concurrency.Task;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public abstract class PriorityAsyncTask<Params, Progress, Result>
extends AsyncTask<Params, Progress, Result>
implements Dependency<Task>,
PriorityProvider,
Task,
DelegateProvider {
    private final PriorityTask priorityTask = new PriorityTask();

    public final void executeOnExecutor(ExecutorService exec, Params ... params) {
        ProxyExecutor executor = new ProxyExecutor(exec, this);
        super.executeOnExecutor(executor, params);
    }

    @Override
    public int compareTo(Object another) {
        return Priority.compareTo(this, another);
    }

    @Override
    public void addDependency(Task task) {
        if (this.getStatus() != AsyncTask.Status.PENDING) {
            throw new IllegalStateException("Must not add Dependency after task is running");
        }
        ((Dependency)((Object)((PriorityProvider)this.getDelegate()))).addDependency(task);
    }

    @Override
    public Collection<Task> getDependencies() {
        return ((Dependency)((Object)((PriorityProvider)this.getDelegate()))).getDependencies();
    }

    @Override
    public boolean areDependenciesMet() {
        return ((Dependency)((Object)((PriorityProvider)this.getDelegate()))).areDependenciesMet();
    }

    @Override
    public Priority getPriority() {
        return ((PriorityProvider)this.getDelegate()).getPriority();
    }

    @Override
    public void setFinished(boolean finished) {
        ((Task)((Object)((PriorityProvider)this.getDelegate()))).setFinished(finished);
    }

    @Override
    public boolean isFinished() {
        return ((Task)((Object)((PriorityProvider)this.getDelegate()))).isFinished();
    }

    @Override
    public void setError(Throwable throwable) {
        ((Task)((Object)((PriorityProvider)this.getDelegate()))).setError(throwable);
    }

    @Override
    public Throwable getError() {
        return ((Task)((Object)((PriorityProvider)this.getDelegate()))).getError();
    }

    @Override
    public <T extends Dependency<Task> & PriorityProvider> T getDelegate() {
        return (T)this.priorityTask;
    }

    private static class ProxyExecutor<Result>
    implements Executor {
        private final Executor executor;
        private final PriorityAsyncTask task;

        public ProxyExecutor(Executor ex, PriorityAsyncTask task) {
            this.executor = ex;
            this.task = task;
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(new PriorityFutureTask<Result>(command, null){

                @Override
                public <T extends Dependency<Task> & PriorityProvider> T getDelegate() {
                    return (T)ProxyExecutor.this.task;
                }
            });
        }
    }
}

