/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import android.os.SystemClock;
import android.util.Log;

public class TimingMetric {
    private final String eventName;
    private final String tag;
    private final boolean disabled;
    private long start;
    private long duration;

    public TimingMetric(String eventName, String tag) {
        this.eventName = eventName;
        this.tag = tag;
        this.disabled = !Log.isLoggable((String)tag, (int)2);
    }

    public synchronized void startMeasuring() {
        if (this.disabled) {
            return;
        }
        this.start = SystemClock.elapsedRealtime();
        this.duration = 0L;
    }

    public synchronized void stopMeasuring() {
        if (this.disabled) {
            return;
        }
        if (this.duration != 0L) {
            return;
        }
        this.duration = SystemClock.elapsedRealtime() - this.start;
        this.reportToLog();
    }

    public long getDuration() {
        return this.duration;
    }

    private void reportToLog() {
        Log.v((String)this.tag, (String)(this.eventName + ": " + this.duration + "ms"));
    }
}

