/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import android.content.Context;
import android.text.TextUtils;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.FirebaseApp;
import io.fabric.sdk.android.services.common.FirebaseAppImpl;

public class FirebaseInfo {
    static final String GOOGLE_APP_ID = "google_app_id";
    static final String FIREBASE_FEATURE_SWITCH = "com.crashlytics.useFirebaseAppId";

    protected String getApiKeyFromFirebaseAppId(Context context) {
        int id = CommonUtils.getResourcesIdentifier(context, GOOGLE_APP_ID, "string");
        if (id != 0) {
            Fabric.getLogger().d("Fabric", "Generating Crashlytics ApiKey from google_app_id in Strings");
            return this.createApiKeyFromFirebaseAppId(context.getResources().getString(id));
        }
        return null;
    }

    protected String createApiKeyFromFirebaseAppId(String appId) {
        return CommonUtils.sha256(appId).substring(0, 40);
    }

    public boolean isFirebaseCrashlyticsEnabled(Context context) {
        if (CommonUtils.getBooleanResourceValue(context, FIREBASE_FEATURE_SWITCH, false)) {
            return true;
        }
        boolean hasGoogleAppId = CommonUtils.getResourcesIdentifier(context, GOOGLE_APP_ID, "string") != 0;
        boolean hasApiKey = !TextUtils.isEmpty((CharSequence)new ApiKey().getApiKeyFromManifest(context)) || !TextUtils.isEmpty((CharSequence)new ApiKey().getApiKeyFromStrings(context));
        return hasGoogleAppId && !hasApiKey;
    }

    public boolean isDataCollectionDefaultEnabled(Context context) {
        FirebaseApp app = FirebaseAppImpl.getInstance(context);
        if (app == null) {
            return true;
        }
        return app.isDataCollectionDefaultEnabled();
    }
}

