/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.common.BackgroundPriorityRunnable;
import io.fabric.sdk.android.services.concurrency.internal.Backoff;
import io.fabric.sdk.android.services.concurrency.internal.RetryPolicy;
import io.fabric.sdk.android.services.concurrency.internal.RetryThreadPoolExecutor;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class ExecutorUtils {
    private static final long DEFAULT_TERMINATION_TIMEOUT = 2L;

    private ExecutorUtils() {
    }

    public static ExecutorService buildSingleThreadExecutorService(String name) {
        ThreadFactory threadFactory = ExecutorUtils.getNamedThreadFactory(name);
        ExecutorService executor = Executors.newSingleThreadExecutor(threadFactory);
        ExecutorUtils.addDelayedShutdownHook(name, executor);
        return executor;
    }

    public static RetryThreadPoolExecutor buildRetryThreadPoolExecutor(String name, int corePoolSize, RetryPolicy retryPolicy, Backoff backoff) {
        ThreadFactory threadFactory = ExecutorUtils.getNamedThreadFactory(name);
        RetryThreadPoolExecutor executor = new RetryThreadPoolExecutor(corePoolSize, threadFactory, retryPolicy, backoff);
        ExecutorUtils.addDelayedShutdownHook(name, executor);
        return executor;
    }

    public static ScheduledExecutorService buildSingleThreadScheduledExecutorService(String name) {
        ThreadFactory threadFactory = ExecutorUtils.getNamedThreadFactory(name);
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        ExecutorUtils.addDelayedShutdownHook(name, executor);
        return executor;
    }

    public static final ThreadFactory getNamedThreadFactory(final String threadNameTemplate) {
        final AtomicLong count = new AtomicLong(1L);
        return new ThreadFactory(){

            @Override
            public Thread newThread(final Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(new BackgroundPriorityRunnable(){

                    @Override
                    public void onRun() {
                        runnable.run();
                    }
                });
                thread.setName(threadNameTemplate + count.getAndIncrement());
                return thread;
            }
        };
    }

    private static final void addDelayedShutdownHook(String serviceName, ExecutorService service) {
        ExecutorUtils.addDelayedShutdownHook(serviceName, service, 2L, TimeUnit.SECONDS);
    }

    public static final void addDelayedShutdownHook(final String serviceName, final ExecutorService service, final long terminationTimeout, final TimeUnit timeUnit) {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new BackgroundPriorityRunnable(){

            @Override
            public void onRun() {
                try {
                    Fabric.getLogger().d("Fabric", "Executing shutdown hook for " + serviceName);
                    service.shutdown();
                    if (!service.awaitTermination(terminationTimeout, timeUnit)) {
                        Fabric.getLogger().d("Fabric", serviceName + " did not shut down in the allocated time. Requesting immediate shutdown.");
                        service.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    Fabric.getLogger().d("Fabric", String.format(Locale.US, "Interrupted while waiting for %s to shut down. Requesting immediate shutdown.", serviceName));
                    service.shutdownNow();
                }
            }
        }, "Crashlytics Shutdown Hook for " + serviceName));
    }
}

