/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.KitInfo;
import io.fabric.sdk.android.services.common.ApiKey;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.common.DeliveryMechanism;
import io.fabric.sdk.android.services.network.DefaultHttpRequestFactory;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.settings.AppRequestData;
import io.fabric.sdk.android.services.settings.AppSettingsData;
import io.fabric.sdk.android.services.settings.CreateAppSpiCall;
import io.fabric.sdk.android.services.settings.IconRequest;
import io.fabric.sdk.android.services.settings.Settings;
import io.fabric.sdk.android.services.settings.SettingsData;
import io.fabric.sdk.android.services.settings.UpdateAppSpiCall;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;

class Onboarding
extends Kit<Boolean> {
    static final String CRASHLYTICS_API_ENDPOINT = "com.crashlytics.ApiEndpoint";
    private static final String BINARY_BUILD_TYPE = "binary";
    private final HttpRequestFactory requestFactory = new DefaultHttpRequestFactory();
    private PackageManager packageManager;
    private String packageName;
    private PackageInfo packageInfo;
    private String versionCode;
    private String versionName;
    private String installerPackageName;
    private String applicationLabel;
    private String targetAndroidSdkVersion;
    private final Future<Map<String, KitInfo>> kitsFinder;
    private final Collection<Kit> providedKits;

    public Onboarding(Future<Map<String, KitInfo>> kitsFinder, Collection<Kit> providedKits) {
        this.kitsFinder = kitsFinder;
        this.providedKits = providedKits;
    }

    @Override
    public String getVersion() {
        return "1.4.4.27";
    }

    @Override
    protected boolean onPreExecute() {
        try {
            this.installerPackageName = this.getIdManager().getInstallerPackageName();
            this.packageManager = this.getContext().getPackageManager();
            this.packageName = this.getContext().getPackageName();
            this.packageInfo = this.packageManager.getPackageInfo(this.packageName, 0);
            this.versionCode = Integer.toString(this.packageInfo.versionCode);
            this.versionName = this.packageInfo.versionName == null ? "0.0" : this.packageInfo.versionName;
            this.applicationLabel = this.packageManager.getApplicationLabel(this.getContext().getApplicationInfo()).toString();
            this.targetAndroidSdkVersion = Integer.toString(this.getContext().getApplicationInfo().targetSdkVersion);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            Fabric.getLogger().e("Fabric", "Failed init", e);
            return false;
        }
    }

    @Override
    protected Boolean doInBackground() {
        String iconHash = CommonUtils.getAppIconHashOrNull(this.getContext());
        boolean appConfigured = false;
        SettingsData settingsData = this.retrieveSettingsData();
        if (settingsData != null) {
            try {
                Map<Object, Object> scannedKits = this.kitsFinder != null ? this.kitsFinder.get() : new HashMap();
                Map<String, KitInfo> mergedKits = this.mergeKits(scannedKits, this.providedKits);
                appConfigured = this.performAutoConfigure(iconHash, settingsData.appData, mergedKits.values());
            }
            catch (Exception e) {
                Fabric.getLogger().e("Fabric", "Error performing auto configuration.", e);
            }
        }
        return appConfigured;
    }

    private SettingsData retrieveSettingsData() {
        try {
            Settings.getInstance().initialize(this, this.idManager, this.requestFactory, this.versionCode, this.versionName, this.getOverridenSpiEndpoint()).loadSettingsData();
            return Settings.getInstance().awaitSettingsData();
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Error dealing with settings", e);
            return null;
        }
    }

    Map<String, KitInfo> mergeKits(Map<String, KitInfo> scannedKits, Collection<Kit> providedKits) {
        for (Kit kit : providedKits) {
            if (scannedKits.containsKey(kit.getIdentifier())) continue;
            scannedKits.put(kit.getIdentifier(), new KitInfo(kit.getIdentifier(), kit.getVersion(), BINARY_BUILD_TYPE));
        }
        return scannedKits;
    }

    @Override
    public String getIdentifier() {
        return "io.fabric.sdk.android:fabric";
    }

    private boolean performAutoConfigure(String iconHash, AppSettingsData appSettings, Collection<KitInfo> sdkKits) {
        boolean properlyConfigured = true;
        if ("new".equals(appSettings.status)) {
            if (this.performCreateApp(iconHash, appSettings, sdkKits)) {
                properlyConfigured = Settings.getInstance().loadSettingsSkippingCache();
            } else {
                Fabric.getLogger().e("Fabric", "Failed to create app with Crashlytics service.", null);
                properlyConfigured = false;
            }
        } else if ("configured".equals(appSettings.status)) {
            properlyConfigured = Settings.getInstance().loadSettingsSkippingCache();
        } else if (appSettings.updateRequired) {
            Fabric.getLogger().d("Fabric", "Server says an update is required - forcing a full App update.");
            this.performUpdateApp(iconHash, appSettings, sdkKits);
        }
        return properlyConfigured;
    }

    private boolean performCreateApp(String iconHash, AppSettingsData appSettings, Collection<KitInfo> sdkKits) {
        AppRequestData requestData = this.buildAppRequest(IconRequest.build(this.getContext(), iconHash), sdkKits);
        return new CreateAppSpiCall(this, this.getOverridenSpiEndpoint(), appSettings.url, this.requestFactory).invoke(requestData);
    }

    private boolean performUpdateApp(String iconHash, AppSettingsData appSettings, Collection<KitInfo> sdkKits) {
        return this.performUpdateApp(appSettings, IconRequest.build(this.getContext(), iconHash), sdkKits);
    }

    private boolean performUpdateApp(AppSettingsData appSettings, IconRequest iconRequest, Collection<KitInfo> sdkKits) {
        AppRequestData requestData = this.buildAppRequest(iconRequest, sdkKits);
        return new UpdateAppSpiCall(this, this.getOverridenSpiEndpoint(), appSettings.url, this.requestFactory).invoke(requestData);
    }

    private AppRequestData buildAppRequest(IconRequest iconRequest, Collection<KitInfo> sdkKits) {
        Context context = this.getContext();
        String apiKey = new ApiKey().getValue(context);
        String buildId = CommonUtils.resolveBuildId(context);
        String instanceId = CommonUtils.createInstanceIdFrom(buildId);
        int source = DeliveryMechanism.determineFrom(this.installerPackageName).getId();
        String appIdentifier = this.getIdManager().getAppIdentifier();
        return new AppRequestData(apiKey, appIdentifier, this.versionName, this.versionCode, instanceId, this.applicationLabel, source, this.targetAndroidSdkVersion, "0", iconRequest, sdkKits);
    }

    String getOverridenSpiEndpoint() {
        return CommonUtils.getStringsFileValue(this.getContext(), CRASHLYTICS_API_ENDPOINT);
    }
}

