/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android;

import android.content.Context;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.FabricContext;
import io.fabric.sdk.android.InitializationCallback;
import io.fabric.sdk.android.InitializationTask;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.concurrency.DependsOn;
import io.fabric.sdk.android.services.concurrency.Task;
import java.io.File;
import java.util.Collection;

public abstract class Kit<Result>
implements Comparable<Kit> {
    Fabric fabric;
    InitializationTask<Result> initializationTask = new InitializationTask(this);
    Context context;
    InitializationCallback<Result> initializationCallback;
    IdManager idManager;
    final DependsOn dependsOnAnnotation = this.getClass().getAnnotation(DependsOn.class);

    public abstract String getVersion();

    void injectParameters(Context context, Fabric fabric, InitializationCallback<Result> callback, IdManager idManager) {
        this.fabric = fabric;
        this.context = new FabricContext(context, this.getIdentifier(), this.getPath());
        this.initializationCallback = callback;
        this.idManager = idManager;
    }

    final void initialize() {
        this.initializationTask.executeOnExecutor(this.fabric.getExecutorService(), new Void[]{null});
    }

    protected boolean onPreExecute() {
        return true;
    }

    protected abstract Result doInBackground();

    protected void onPostExecute(Result result) {
    }

    protected void onCancelled(Result result) {
    }

    protected IdManager getIdManager() {
        return this.idManager;
    }

    public Context getContext() {
        return this.context;
    }

    public Fabric getFabric() {
        return this.fabric;
    }

    public abstract String getIdentifier();

    public String getPath() {
        return ".Fabric" + File.separator + this.getIdentifier();
    }

    @Override
    public int compareTo(Kit another) {
        if (this.containsAnnotatedDependency(another)) {
            return 1;
        }
        if (another.containsAnnotatedDependency(this)) {
            return -1;
        }
        if (this.hasAnnotatedDependency() && !another.hasAnnotatedDependency()) {
            return 1;
        }
        if (!this.hasAnnotatedDependency() && another.hasAnnotatedDependency()) {
            return -1;
        }
        return 0;
    }

    boolean containsAnnotatedDependency(Kit target) {
        if (this.hasAnnotatedDependency()) {
            Class<?>[] deps;
            for (Class<?> dep : deps = this.dependsOnAnnotation.value()) {
                if (!dep.isAssignableFrom(target.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasAnnotatedDependency() {
        return this.dependsOnAnnotation != null;
    }

    protected Collection<Task> getDependencies() {
        return this.initializationTask.getDependencies();
    }
}

