/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.os.Bundle;
import com.crashlytics.android.answers.AddToCartEvent;
import com.crashlytics.android.answers.FirebaseAnalyticsEvent;
import com.crashlytics.android.answers.SessionEvent;
import io.fabric.sdk.android.Fabric;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FirebaseAnalyticsEventMapper {
    private static final String FIREBASE_SUCCESS = "success";
    private static final String FIREBASE_LEVEL_NAME = "level_name";
    private static final String FIREBASE_RATING = "rating";
    private static final String FIREBASE_METHOD = "method";
    private static final Set<String> EVENT_NAMES = new HashSet<String>(Arrays.asList("app_clear_data", "app_exception", "app_remove", "app_upgrade", "app_install", "app_update", "firebase_campaign", "error", "first_open", "first_visit", "in_app_purchase", "notification_dismiss", "notification_foreground", "notification_open", "notification_receive", "os_update", "session_start", "user_engagement", "ad_exposure", "adunit_exposure", "ad_query", "ad_activeview", "ad_impression", "ad_click", "screen_view", "firebase_extra_parameter"));

    public FirebaseAnalyticsEvent mapEvent(SessionEvent event) {
        String eventName;
        Bundle bundle;
        boolean isPredefinedEvent;
        boolean isCustomEvent = SessionEvent.Type.CUSTOM.equals((Object)event.type) && event.customType != null;
        boolean bl = isPredefinedEvent = SessionEvent.Type.PREDEFINED.equals((Object)event.type) && event.predefinedType != null;
        if (!isCustomEvent && !isPredefinedEvent) {
            return null;
        }
        if (isPredefinedEvent) {
            bundle = this.mapPredefinedEvent(event);
        } else {
            bundle = new Bundle();
            if (event.customAttributes != null) {
                this.mapCustomEventAttributes(bundle, event.customAttributes);
            }
        }
        if (isPredefinedEvent) {
            String successBoolean = (String)event.predefinedAttributes.get(FIREBASE_SUCCESS);
            boolean wasFailedEvent = successBoolean != null && !Boolean.parseBoolean(successBoolean);
            eventName = this.mapPredefinedEventName(event.predefinedType, wasFailedEvent);
        } else {
            eventName = this.mapCustomEventName(event.customType);
        }
        Fabric.getLogger().d("Answers", "Logging event into firebase...");
        return new FirebaseAnalyticsEvent(eventName, bundle);
    }

    private String mapCustomEventName(String eventName) {
        if (eventName == null || eventName.length() == 0) {
            return "fabric_unnamed_event";
        }
        if (EVENT_NAMES.contains(eventName)) {
            return "fabric_" + eventName;
        }
        if ((eventName = eventName.replaceAll("[^\\p{Alnum}_]+", "_")).startsWith("ga_") || eventName.startsWith("google_") || eventName.startsWith("firebase_") || !Character.isLetter(eventName.charAt(0))) {
            eventName = "fabric_" + eventName;
        }
        if (eventName.length() > 40) {
            eventName = eventName.substring(0, 40);
        }
        return eventName;
    }

    private String mapAttribute(String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            return "fabric_unnamed_parameter";
        }
        if ((attributeName = attributeName.replaceAll("[^\\p{Alnum}_]+", "_")).startsWith("ga_") || attributeName.startsWith("google_") || attributeName.startsWith("firebase_") || !Character.isLetter(attributeName.charAt(0))) {
            attributeName = "fabric_" + attributeName;
        }
        if (attributeName.length() > 40) {
            return attributeName.substring(0, 40);
        }
        return attributeName;
    }

    private String mapPredefinedEventName(String name, boolean wasFailedEvent) {
        if (wasFailedEvent) {
            switch (name) {
                case "purchase": {
                    return "failed_ecommerce_purchase";
                }
                case "signUp": {
                    return "failed_sign_up";
                }
                case "login": {
                    return "failed_login";
                }
            }
        }
        switch (name) {
            case "purchase": {
                return "ecommerce_purchase";
            }
            case "addToCart": {
                return "add_to_cart";
            }
            case "startCheckout": {
                return "begin_checkout";
            }
            case "contentView": {
                return "select_content";
            }
            case "search": {
                return "search";
            }
            case "share": {
                return "share";
            }
            case "rating": {
                return "rate_content";
            }
            case "signUp": {
                return "sign_up";
            }
            case "login": {
                return "login";
            }
            case "invite": {
                return "invite";
            }
            case "levelStart": {
                return "level_start";
            }
            case "levelEnd": {
                return "level_end";
            }
        }
        return this.mapCustomEventName(name);
    }

    private Bundle mapPredefinedEvent(SessionEvent event) {
        Bundle bundle = new Bundle();
        if ("purchase".equals(event.predefinedType)) {
            this.putString(bundle, "item_id", (String)event.predefinedAttributes.get("itemId"));
            this.putString(bundle, "item_name", (String)event.predefinedAttributes.get("itemName"));
            this.putString(bundle, "item_category", (String)event.predefinedAttributes.get("itemType"));
            this.putDouble(bundle, "value", this.mapPriceValue(event.predefinedAttributes.get("itemPrice")));
            this.putString(bundle, "currency", (String)event.predefinedAttributes.get("currency"));
        } else if ("addToCart".equals(event.predefinedType)) {
            this.putString(bundle, "item_id", (String)event.predefinedAttributes.get("itemId"));
            this.putString(bundle, "item_name", (String)event.predefinedAttributes.get("itemName"));
            this.putString(bundle, "item_category", (String)event.predefinedAttributes.get("itemType"));
            this.putDouble(bundle, "price", this.mapPriceValue(event.predefinedAttributes.get("itemPrice")));
            this.putDouble(bundle, "value", this.mapPriceValue(event.predefinedAttributes.get("itemPrice")));
            this.putString(bundle, "currency", (String)event.predefinedAttributes.get("currency"));
            bundle.putLong("quantity", 1L);
        } else if ("startCheckout".equals(event.predefinedType)) {
            this.putLong(bundle, "quantity", (long)((Integer)event.predefinedAttributes.get("itemCount")));
            this.putDouble(bundle, "value", this.mapPriceValue(event.predefinedAttributes.get("totalPrice")));
            this.putString(bundle, "currency", (String)event.predefinedAttributes.get("currency"));
        } else if ("contentView".equals(event.predefinedType)) {
            this.putString(bundle, "content_type", (String)event.predefinedAttributes.get("contentType"));
            this.putString(bundle, "item_id", (String)event.predefinedAttributes.get("contentId"));
            this.putString(bundle, "item_name", (String)event.predefinedAttributes.get("contentName"));
        } else if ("search".equals(event.predefinedType)) {
            this.putString(bundle, "search_term", (String)event.predefinedAttributes.get("query"));
        } else if ("share".equals(event.predefinedType)) {
            this.putString(bundle, FIREBASE_METHOD, (String)event.predefinedAttributes.get(FIREBASE_METHOD));
            this.putString(bundle, "content_type", (String)event.predefinedAttributes.get("contentType"));
            this.putString(bundle, "item_id", (String)event.predefinedAttributes.get("contentId"));
            this.putString(bundle, "item_name", (String)event.predefinedAttributes.get("contentName"));
        } else if (FIREBASE_RATING.equals(event.predefinedType)) {
            this.putString(bundle, FIREBASE_RATING, String.valueOf(event.predefinedAttributes.get(FIREBASE_RATING)));
            this.putString(bundle, "content_type", (String)event.predefinedAttributes.get("contentType"));
            this.putString(bundle, "item_id", (String)event.predefinedAttributes.get("contentId"));
            this.putString(bundle, "item_name", (String)event.predefinedAttributes.get("contentName"));
        } else if ("signUp".equals(event.predefinedType)) {
            this.putString(bundle, FIREBASE_METHOD, (String)event.predefinedAttributes.get(FIREBASE_METHOD));
        } else if ("login".equals(event.predefinedType)) {
            this.putString(bundle, FIREBASE_METHOD, (String)event.predefinedAttributes.get(FIREBASE_METHOD));
        } else if ("invite".equals(event.predefinedType)) {
            this.putString(bundle, FIREBASE_METHOD, (String)event.predefinedAttributes.get(FIREBASE_METHOD));
        } else if ("levelStart".equals(event.predefinedType)) {
            this.putString(bundle, FIREBASE_LEVEL_NAME, (String)event.predefinedAttributes.get("levelName"));
        } else if ("levelEnd".equals(event.predefinedType)) {
            this.putDouble(bundle, "score", this.mapDouble(event.predefinedAttributes.get("score")));
            this.putString(bundle, FIREBASE_LEVEL_NAME, (String)event.predefinedAttributes.get("levelName"));
            this.putInt(bundle, FIREBASE_SUCCESS, this.mapBooleanValue((String)event.predefinedAttributes.get(FIREBASE_SUCCESS)));
        }
        this.mapCustomEventAttributes(bundle, event.customAttributes);
        return bundle;
    }

    private void putLong(Bundle bundle, String param, Long longValue) {
        if (longValue == null) {
            return;
        }
        bundle.putLong(param, longValue.longValue());
    }

    private void putInt(Bundle bundle, String param, Integer intValue) {
        if (intValue == null) {
            return;
        }
        bundle.putInt(param, intValue.intValue());
    }

    private void putString(Bundle bundle, String param, String stringValue) {
        if (stringValue == null) {
            return;
        }
        bundle.putString(param, stringValue);
    }

    private void putDouble(Bundle bundle, String param, Double doubleValue) {
        Double mappedDouble = this.mapDouble(doubleValue);
        if (mappedDouble == null) {
            return;
        }
        bundle.putDouble(param, mappedDouble.doubleValue());
    }

    private Double mapDouble(Object doubleObj) {
        String doubleString = String.valueOf(doubleObj);
        if (doubleString == null) {
            return null;
        }
        return Double.valueOf(doubleString);
    }

    private Integer mapBooleanValue(String truthyString) {
        if (truthyString == null) {
            return null;
        }
        return truthyString.equals("true") ? 1 : 0;
    }

    private Double mapPriceValue(Object o) {
        Long longValue = (Long)o;
        if (longValue == null) {
            return null;
        }
        return new BigDecimal((Long)o).divide(AddToCartEvent.MICRO_CONSTANT).doubleValue();
    }

    private void mapCustomEventAttributes(Bundle mutatedBundle, Map<String, Object> customAttributes) {
        for (Map.Entry<String, Object> o : customAttributes.entrySet()) {
            Object value = o.getValue();
            String attributeKey = this.mapAttribute(o.getKey());
            if (value instanceof String) {
                mutatedBundle.putString(attributeKey, o.getValue().toString());
                continue;
            }
            if (value instanceof Double) {
                mutatedBundle.putDouble(attributeKey, ((Double)o.getValue()).doubleValue());
                continue;
            }
            if (value instanceof Long) {
                mutatedBundle.putLong(attributeKey, ((Long)o.getValue()).longValue());
                continue;
            }
            if (!(value instanceof Integer)) continue;
            mutatedBundle.putInt(attributeKey, ((Integer)o.getValue()).intValue());
        }
    }
}

