/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.content.Context;
import com.crashlytics.android.answers.AppMeasurementEventLogger;
import com.crashlytics.android.answers.EventLogger;
import com.crashlytics.android.answers.FirebaseAnalyticsEvent;
import com.crashlytics.android.answers.FirebaseAnalyticsEventMapper;
import com.crashlytics.android.answers.SessionEvent;
import io.fabric.sdk.android.Fabric;

class FirebaseAnalyticsApiAdapter {
    private final Context context;
    private final FirebaseAnalyticsEventMapper eventMapper;
    private EventLogger eventLogger;

    public FirebaseAnalyticsApiAdapter(Context context) {
        this(context, new FirebaseAnalyticsEventMapper());
    }

    public FirebaseAnalyticsApiAdapter(Context context, FirebaseAnalyticsEventMapper eventMapper) {
        this.context = context;
        this.eventMapper = eventMapper;
    }

    public EventLogger getFirebaseAnalytics() {
        if (this.eventLogger == null) {
            this.eventLogger = AppMeasurementEventLogger.getEventLogger(this.context);
        }
        return this.eventLogger;
    }

    public void processEvent(SessionEvent sessionEvent) {
        EventLogger eventLogger = this.getFirebaseAnalytics();
        if (eventLogger == null) {
            Fabric.getLogger().d("Answers", "Firebase analytics logging was enabled, but not available...");
            return;
        }
        FirebaseAnalyticsEvent mappedEvent = this.eventMapper.mapEvent(sessionEvent);
        if (mappedEvent == null) {
            Fabric.getLogger().d("Answers", "Fabric event was not mappable to Firebase event: " + sessionEvent);
            return;
        }
        eventLogger.logEvent(mappedEvent.getEventName(), mappedEvent.getEventParams());
        if ("levelEnd".equals(sessionEvent.predefinedType)) {
            eventLogger.logEvent("post_score", mappedEvent.getEventParams());
        }
    }
}

