/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import android.content.Context;
import android.os.Bundle;
import com.crashlytics.android.answers.EventLogger;
import java.lang.reflect.Method;

public class AppMeasurementEventLogger
implements EventLogger {
    private static final String LOG_METHOD = "logEventInternal";
    private static final String ANALYTIC_CLASS = "com.google.android.gms.measurement.AppMeasurement";
    private static final String GET_INSTANCE_METHOD = "getInstance";
    private final Method logEventMethod;
    private final Object logEventInstance;

    public static EventLogger getEventLogger(Context context) {
        Class instanceClass = AppMeasurementEventLogger.getClass(context);
        if (instanceClass == null) {
            return null;
        }
        Object instance = AppMeasurementEventLogger.getInstance(context, instanceClass);
        if (instance == null) {
            return null;
        }
        Method logEventMethod = AppMeasurementEventLogger.getLogEventMethod(context, instanceClass);
        if (logEventMethod == null) {
            return null;
        }
        return new AppMeasurementEventLogger(instance, logEventMethod);
    }

    private static Class getClass(Context context) {
        try {
            return context.getClassLoader().loadClass(ANALYTIC_CLASS);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getInstance(Context context, Class instanceClass) {
        try {
            Method getInstanceMethod = instanceClass.getDeclaredMethod(GET_INSTANCE_METHOD, Context.class);
            return getInstanceMethod.invoke((Object)instanceClass, context);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Method getLogEventMethod(Context context, Class instanceClass) {
        try {
            return instanceClass.getDeclaredMethod(LOG_METHOD, String.class, String.class, Bundle.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AppMeasurementEventLogger(Object logEventInstance, Method logEventMethod) {
        this.logEventInstance = logEventInstance;
        this.logEventMethod = logEventMethod;
    }

    @Override
    public void logEvent(String eventName, Bundle metadata) {
        this.logEvent("fab", eventName, metadata);
    }

    @Override
    public void logEvent(String origin, String eventName, Bundle metadata) {
        try {
            this.logEventMethod.invoke(this.logEventInstance, origin, eventName, metadata);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

