/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.answers;

import io.fabric.sdk.android.Fabric;
import java.util.Locale;
import java.util.Map;

class AnswersEventValidator {
    final int maxNumAttributes;
    final int maxStringLength;
    boolean failFast;

    public AnswersEventValidator(int maxNumAttributes, int maxStringLength, boolean failFast) {
        this.maxNumAttributes = maxNumAttributes;
        this.maxStringLength = maxStringLength;
        this.failFast = failFast;
    }

    public String limitStringLength(String value) {
        if (value.length() > this.maxStringLength) {
            String message = String.format(Locale.US, "String is too long, truncating to %d characters", this.maxStringLength);
            this.logOrThrowException(new IllegalArgumentException(message));
            return value.substring(0, this.maxStringLength);
        }
        return value;
    }

    public boolean isNull(Object object, String paramName) {
        if (object == null) {
            this.logOrThrowException(new NullPointerException(paramName + " must not be null"));
            return true;
        }
        return false;
    }

    public boolean isFullMap(Map<String, Object> attributeMap, String key) {
        if (attributeMap.size() >= this.maxNumAttributes && !attributeMap.containsKey(key)) {
            String message = String.format(Locale.US, "Limit of %d attributes reached, skipping attribute", this.maxNumAttributes);
            this.logOrThrowException(new IllegalArgumentException(message));
            return true;
        }
        return false;
    }

    private void logOrThrowException(RuntimeException ex) {
        if (this.failFast) {
            throw ex;
        }
        Fabric.getLogger().e("Answers", "Invalid user input detected", (Throwable)ex);
    }
}

