/*
 * Decompiled with CFR 0.152.
 */
package com.appice.cordova;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.util.DisplayMetrics;
import android.view.View;
import com.appice.cordova.CampaignCampsReceiver;
import com.appice.cordova.NotificationEventService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONObject;
import semusi.activitysdk.Api;
import semusi.activitysdk.ContextData;
import semusi.activitysdk.ContextSdk;
import semusi.activitysdk.SdkConfig;
import semusi.activitysdk.User;

public class AppICEPlugin
extends CordovaPlugin {
    private static final String TAG = "AppICE_CP";
    HashMap<String, CallbackContext> callbackIds = new HashMap();
    private static final Map<String, Method> exportedMethods;
    private static boolean inBackground;
    private static ArrayList<JSONObject> notificationStack;
    private static CallbackContext notificationCallbackContext;

    public void initialize(CordovaInterface cordova, CordovaWebView webView) {
        super.initialize(cordova, webView);
        this.onNewIntent(cordova.getActivity().getIntent());
    }

    @CordovaMethod
    private void validateIntegration(JSONArray data, CallbackContext callbackContext) {
        try {
            ContextSdk sdk;
            Context ctx = this.cordova.getActivity().getApplicationContext();
            PackageManager pm = ctx.getPackageManager();
            Intent receiverIntent = new Intent();
            receiverIntent.setClass(ctx, CampaignCampsReceiver.class);
            List receivers = pm.queryBroadcastReceivers(receiverIntent, 0);
            if (receivers == null || receivers.size() <= 0) {
                callbackContext.error("Missing Receiver entry in AndroidManifest : CampaignCampsReceiver");
            }
            Intent serviceIntent = new Intent();
            serviceIntent.setClass(ctx, NotificationEventService.class);
            ResolveInfo services = pm.resolveService(serviceIntent, 0);
            if (services == null) {
                callbackContext.error("Missing Service entry in AndroidManifest : NotificationEventService");
            }
            if ((sdk = new ContextSdk(ctx)).getAppId() == null || sdk.getAppId().length() <= 0 || sdk.getAppId().trim().length() <= 0) {
                callbackContext.error("Missing Meta-data entry : AppID");
            }
            if (sdk.getAppKey() == null || sdk.getAppKey().length() <= 0 || sdk.getAppKey().trim().length() <= 0) {
                callbackContext.error("Missing Meta-data entry : AppKey");
                return;
            }
            if (sdk.getApiKey() == null || sdk.getApiKey().length() <= 0 || sdk.getApiKey().trim().length() <= 0) {
                callbackContext.error("Missing Meta-data entry : ApiKey");
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
            return;
        }
        callbackContext.success("");
    }

    @CordovaMethod
    private void startContext(JSONArray data, CallbackContext callbackContext) {
        try {
            SdkConfig config = new SdkConfig();
            Api.startContext((Context)this.cordova.getActivity().getApplicationContext(), (SdkConfig)config);
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void initSdk(JSONArray data, CallbackContext callbackContext) {
        try {
            SdkConfig config = new SdkConfig();
            String appId = "";
            String appKey = "";
            String apiKey = "";
            try {
                JSONObject root = data.getJSONObject(0);
                appId = root.optString("appID");
                appKey = root.optString("appKey");
                apiKey = root.optString("apiKey");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("AppICEPlugin initSdk : " + appId + " , " + appKey + " , " + apiKey);
            Api.initSdk((String)appId, (String)appKey, (String)apiKey, (Context)this.cordova.getActivity().getApplicationContext());
            Api.startContext((Context)this.cordova.getActivity().getApplicationContext(), (SdkConfig)config);
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void stopContext(JSONArray data, CallbackContext callbackContext) {
        try {
            Api.stopContext((Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void isSemusiSensing(JSONArray data, CallbackContext callbackContext) {
        try {
            boolean key = ContextSdk.isSemusiSensing((Context)this.cordova.getActivity().getApplicationContext());
            if (key) {
                callbackContext.success(1);
            } else {
                callbackContext.success(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void setAsTestDevice(JSONArray data, CallbackContext callbackContext) {
        try {
            ContextSdk.setAsTestDevice((boolean)true, (Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void removeAsTestDevice(JSONArray data, CallbackContext callbackContext) {
        try {
            ContextSdk.setAsTestDevice((boolean)false, (Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getIsTestDevice(JSONArray data, CallbackContext callbackContext) {
        try {
            boolean key = ContextSdk.getIsTestDevice((Context)this.cordova.getActivity().getApplicationContext());
            if (key) {
                callbackContext.success(1);
            } else {
                callbackContext.success(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void openPlayServiceUpdate(JSONArray data, CallbackContext callbackContext) {
        try {
            ContextSdk.openPlayServiceUpdate((Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getSdkVersion(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = ContextSdk.getSdkVersion();
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getSdkIntVersion(JSONArray data, CallbackContext callbackContext) {
        try {
            int key = ContextSdk.getSdkIntVersion();
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void setDeviceId(JSONArray data, CallbackContext callbackContext) {
        try {
            String deviceID = (String)data.getJSONObject(0).get("deviceID");
            if (deviceID != null && deviceID.length() > 0) {
                ContextSdk.setDeviceId((Context)this.cordova.getActivity().getApplicationContext(), (String)deviceID);
                callbackContext.success();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getDeviceId(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = new ContextSdk(this.cordova.getActivity().getApplicationContext()).getDeviceId();
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getAndroidId(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = new ContextSdk(this.cordova.getActivity().getApplicationContext()).getAndroidId();
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getAppKey(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = new ContextSdk(this.cordova.getActivity().getApplicationContext()).getAppKey();
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getApiKey(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = new ContextSdk(this.cordova.getActivity().getApplicationContext()).getApiKey();
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getAppId(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = new ContextSdk(this.cordova.getActivity().getApplicationContext()).getAppId();
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getCurrentContext(JSONArray data, CallbackContext callbackContext) {
        try {
            ContextData userData = new ContextSdk(this.cordova.getActivity().getApplicationContext()).getCurrentContext();
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void setAlias(JSONArray data, CallbackContext callbackContext) {
        try {
            String alias = (String)data.getJSONObject(0).get("alias");
            if (alias != null && alias.length() > 0) {
                ContextSdk.setAlias((String)alias, (Context)this.cordova.getActivity().getApplicationContext());
                callbackContext.success();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getAlias(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = ContextSdk.getAlias((Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void setUser(JSONArray data, CallbackContext callbackContext) {
        try {
            String email;
            String phone;
            User userinfo = ContextSdk.getUser((Context)this.cordova.getActivity().getApplicationContext());
            String name = (String)data.getJSONObject(0).get("name");
            if (name != null && name.length() > 0) {
                userinfo.setName(name);
            }
            if ((phone = (String)data.getJSONObject(0).get("phone")) != null && phone.length() > 0) {
                userinfo.setPhone(phone);
            }
            if ((email = (String)data.getJSONObject(0).get("email")) != null && email.length() > 0) {
                userinfo.setEmail(email);
            }
            ContextSdk.setUser((User)userinfo, (Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getUser(JSONArray data, CallbackContext callbackContext) {
        try {
            User userInfo = ContextSdk.getUser((Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success(userInfo.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void setChildId(JSONArray data, CallbackContext callbackContext) {
        try {
            String childID = (String)data.getJSONObject(0).get("childID");
            if (childID != null && childID.length() > 0) {
                ContextSdk.setChildId((String)childID, (Context)this.cordova.getActivity().getApplicationContext());
                callbackContext.success();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getChildId(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = ContextSdk.getChildId((Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void setReferrer(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = (String)data.getJSONObject(0).get("referrer");
            if (key != null && key.length() > 0) {
                ContextSdk.setReferrer((String)key, (Context)this.cordova.getActivity().getApplicationContext());
                callbackContext.success();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getReferrer(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = ContextSdk.getReferrer((Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void setInstallReferrer(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = (String)data.getJSONObject(0).get("installRef");
            if (key != null && key.length() > 0) {
                ContextSdk.setInstallReferrer((String)key, (Context)this.cordova.getActivity().getApplicationContext());
                callbackContext.success();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getInstallReferrer(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = ContextSdk.getInstallReferrer((Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void setInstaller(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = (String)data.getJSONObject(0).get("installer");
            if (key != null && key.length() > 0) {
                ContextSdk.setInstaller((String)key, (Context)this.cordova.getActivity().getApplicationContext());
                callbackContext.success();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getInstaller(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = ContextSdk.getInstaller((Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getGCMSenderId(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = "GCM-Deprecated";
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getDeviceToken(JSONArray data, CallbackContext callbackContext) {
        try {
            String registrationId = "";
            callbackContext.success(registrationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void setCustomVariable(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = (String)data.getJSONObject(0).get("key");
            Object value = data.getJSONObject(0).get("value");
            if (key != null && key.length() > 0 && value != null) {
                Class<?> valueClass = value.getClass();
                if (valueClass == Integer.class) {
                    ContextSdk.setCustomVariable((String)key, (Integer)((Integer)value), (Context)this.cordova.getActivity().getApplicationContext());
                } else if (valueClass == Float.class || valueClass == Double.class) {
                    ContextSdk.setCustomVariable((String)key, (Float)((Float)value), (Context)this.cordova.getActivity().getApplicationContext());
                } else if (valueClass == Long.class) {
                    ContextSdk.setCustomVariable((String)key, (Long)((Long)value), (Context)this.cordova.getActivity().getApplicationContext());
                } else if (valueClass == String.class) {
                    ContextSdk.setCustomVariable((String)key, (String)((String)value), (Context)this.cordova.getActivity().getApplicationContext());
                } else if (valueClass == Boolean.class) {
                    ContextSdk.setCustomVariable((String)key, (Boolean)((Boolean)value), (Context)this.cordova.getActivity().getApplicationContext());
                }
                callbackContext.success();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getCustomVariable(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = (String)data.getJSONObject(0).get("key");
            Object value = ContextSdk.getCustomVariable((String)key, (Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success((String)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void removeCustomVariable(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = (String)data.getJSONObject(0).get("key");
            ContextSdk.removeCustomVariable((String)key, (Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void tagEvent(JSONArray data, CallbackContext callbackContext) {
        block6: {
            try {
                String key = (String)data.getJSONObject(0).get("key");
                if (key == null || key.length() <= 0) break block6;
                HashMap<String, Object> mapData = new HashMap<String, Object>();
                try {
                    JSONObject hashData = (JSONObject)data.getJSONObject(0).get("data");
                    if (hashData != null && hashData.length() > 0) {
                        Iterator keys = hashData.keys();
                        while (keys.hasNext()) {
                            String dataKey = (String)keys.next();
                            if (dataKey == null || dataKey.length() <= 0) continue;
                            mapData.put(dataKey, hashData.get(dataKey));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ContextSdk.tagEventObj((String)key, mapData, (Context)this.cordova.getActivity().getApplicationContext());
                callbackContext.success();
            }
            catch (Exception e) {
                e.printStackTrace();
                callbackContext.error(e.getMessage());
            }
        }
    }

    @CordovaMethod
    private void setSmallIcon(JSONArray data, CallbackContext callbackContext) {
        try {
            String key = (String)data.getJSONObject(0).get("icon");
            if (key != null && key.length() > 0) {
                ContextSdk.setSmallIcon((String)key, (Context)this.cordova.getActivity().getApplicationContext());
            }
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void setSessionTimeout(JSONArray data, CallbackContext callbackContext) {
        try {
            int key = data.getJSONObject(0).getInt("timeout");
            ContextSdk.setSessionTimeout((int)key, (Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void getSessionTimeout(JSONArray data, CallbackContext callbackContext) {
        try {
            int key = ContextSdk.getSessionTimeout((Context)this.cordova.getActivity().getApplicationContext());
            callbackContext.success(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void trackTouches(JSONArray data, CallbackContext callbackContext) {
        try {
            DisplayMetrics dm = new DisplayMetrics();
            this.cordova.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
            int screenWidth = dm.widthPixels;
            int screenHeight = dm.heightPixels;
            JSONObject root = data.getJSONObject(0);
            if (root != null) {
                double webWidth = root.optInt("w");
                double webHeight = root.optInt("h");
                double wRatio = (double)screenWidth / webWidth;
                double hRatio = (double)screenHeight / webHeight;
                double x = root.optDouble("x");
                double y = root.optDouble("y");
                root.put("x", x *= wRatio);
                root.put("y", y *= hRatio);
                double px = root.optDouble("px");
                double py = root.optDouble("py");
                double pw = root.optDouble("pw");
                double ph = root.optDouble("ph");
                pw *= wRatio;
                ph *= hRatio;
                root.put("px", px *= wRatio);
                root.put("py", py *= hRatio);
                root.put("pw", pw);
                root.put("ph", ph);
                JSONArray newObjects = new JSONArray();
                JSONArray objects = root.optJSONArray("arr");
                if (objects != null && objects.length() > 0) {
                    for (int i = 0; i < objects.length(); ++i) {
                        JSONObject inputFld = objects.optJSONObject(i);
                        if (inputFld == null || inputFld.length() <= 0) continue;
                        JSONObject obj = new JSONObject(inputFld.toString());
                        obj.put("x", inputFld.optDouble("x") * wRatio);
                        obj.put("y", inputFld.optDouble("y") * hRatio + inputFld.optDouble("h"));
                        obj.put("w", inputFld.optDouble("w") * wRatio);
                        obj.put("h", inputFld.optDouble("h") * hRatio);
                        newObjects.put((Object)obj);
                    }
                }
                root.put("arr", (Object)newObjects);
            }
            View rootView = this.cordova.getActivity().getWindow().getDecorView().getRootView();
            ContextSdk.trackTouches((JSONObject)root, (Context)this.cordova.getActivity().getApplicationContext(), (View)rootView, (Activity)this.cordova.getActivity());
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void trackSwipes(JSONArray data, CallbackContext callbackContext) {
        try {
            DisplayMetrics dm = new DisplayMetrics();
            this.cordova.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
            int screenWidth = dm.widthPixels;
            int screenHeight = dm.heightPixels;
            JSONObject root = data.getJSONObject(0);
            if (root != null) {
                double webWidth = root.optInt("w");
                double webHeight = root.optInt("h");
                double wRatio = (double)screenWidth / webWidth;
                double hRatio = (double)screenHeight / webHeight;
                double x1 = root.optDouble("x1");
                double y1 = root.optDouble("y1");
                root.put("x1", x1 *= wRatio);
                root.put("y1", y1 *= hRatio);
                double x2 = root.optDouble("x2");
                double y2 = root.optDouble("y2");
                root.put("x2", x2 *= wRatio);
                root.put("y2", y2 *= hRatio);
                JSONArray newObjects = new JSONArray();
                JSONArray objects = root.optJSONArray("arr");
                if (objects != null && objects.length() > 0) {
                    for (int i = 0; i < objects.length(); ++i) {
                        JSONObject inputFld = objects.optJSONObject(i);
                        if (inputFld == null || inputFld.length() <= 0) continue;
                        JSONObject obj = new JSONObject(inputFld.toString());
                        obj.put("x", inputFld.optDouble("x") * wRatio);
                        obj.put("y", inputFld.optDouble("y") * hRatio + inputFld.optDouble("h"));
                        obj.put("w", inputFld.optDouble("w") * wRatio);
                        obj.put("h", inputFld.optDouble("h") * hRatio);
                        newObjects.put((Object)obj);
                    }
                }
                root.put("arr", (Object)newObjects);
            }
            View rootView = this.cordova.getActivity().getWindow().getDecorView().getRootView();
            ContextSdk.trackSwipes((JSONObject)root, (Context)this.cordova.getActivity().getApplicationContext(), (View)rootView, (Activity)this.cordova.getActivity());
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    @CordovaMethod
    private void trackScreens(JSONArray data, CallbackContext callbackContext) {
        try {
            DisplayMetrics dm = new DisplayMetrics();
            this.cordova.getActivity().getWindowManager().getDefaultDisplay().getMetrics(dm);
            int screenWidth = dm.widthPixels;
            int screenHeight = dm.heightPixels;
            JSONObject root = data.getJSONObject(0);
            if (root != null) {
                double webWidth = root.optInt("w");
                double webHeight = root.optInt("h");
                double wRatio = (double)screenWidth / webWidth;
                double hRatio = (double)screenHeight / webHeight;
                JSONArray newObjects = new JSONArray();
                JSONArray objects = root.optJSONArray("arr");
                if (objects != null && objects.length() > 0) {
                    for (int i = 0; i < objects.length(); ++i) {
                        JSONObject inputFld = objects.optJSONObject(i);
                        if (inputFld == null || inputFld.length() <= 0) continue;
                        JSONObject obj = new JSONObject(inputFld.toString());
                        obj.put("x", inputFld.optDouble("x") * wRatio);
                        obj.put("y", inputFld.optDouble("y") * hRatio + inputFld.optDouble("h"));
                        obj.put("w", inputFld.optDouble("w") * wRatio);
                        obj.put("h", inputFld.optDouble("h") * hRatio);
                        newObjects.put((Object)obj);
                    }
                }
                root.put("arr", (Object)newObjects);
            }
            View rootView = this.cordova.getActivity().getWindow().getDecorView().getRootView();
            ContextSdk.trackScreens((JSONObject)root, (Context)this.cordova.getActivity().getApplicationContext(), (View)rootView, (Activity)this.cordova.getActivity());
            callbackContext.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            callbackContext.error(e.getMessage());
        }
    }

    public boolean execute(String action, JSONArray data, CallbackContext callbackId) {
        Method method = exportedMethods.get(action);
        if (method == null) {
            return false;
        }
        try {
            Boolean result = (Boolean)method.invoke((Object)this, data, callbackId);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void sendNotification(JSONObject bundle, Context context) {
        if (!AppICEPlugin.hasNotificationsCallback() && AppICEPlugin.inBackground()) {
            String packageName = context.getPackageName();
            if (notificationStack == null) {
                notificationStack = new ArrayList();
            }
            notificationStack.add(bundle);
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setComponent(new ComponentName(packageName, packageName + ".MainActivity"));
            intent.addFlags(0x34000000);
            intent.putExtra("cdvStartInBackground", true);
            context.startActivity(intent);
            return;
        }
        try {
            CallbackContext callbackContext = notificationCallbackContext;
            if (callbackContext != null && bundle != null) {
                PluginResult pluginresult = new PluginResult(PluginResult.Status.OK, bundle);
                pluginresult.setKeepCallback(true);
                callbackContext.sendPluginResult(pluginresult);
            } else if (callbackContext == null) {
                String packageName = context.getPackageName();
                if (notificationStack == null) {
                    notificationStack = new ArrayList();
                }
                notificationStack.add(bundle);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPause(boolean multitasking) {
        inBackground = true;
    }

    public void onResume(boolean multitasking) {
        inBackground = false;
    }

    public void onReset() {
        notificationCallbackContext = null;
    }

    public static boolean inBackground() {
        return inBackground;
    }

    public static boolean hasNotificationsCallback() {
        return notificationCallbackContext != null;
    }

    @CordovaMethod
    private void onNotificationOpen(JSONArray data, CallbackContext callbackContext) {
        try {
            notificationCallbackContext = callbackContext;
            if (notificationStack != null) {
                for (JSONObject bundle : notificationStack) {
                    AppICEPlugin.sendNotification(bundle, this.cordova.getActivity().getApplicationContext());
                }
                notificationStack.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        ArrayList<Method> allMethods = new ArrayList<Method>(Arrays.asList(AppICEPlugin.class.getDeclaredMethods()));
        for (Method method : allMethods) {
            if (!method.isAnnotationPresent(CordovaMethod.class)) continue;
            methods.put(method.getName(), method);
        }
        exportedMethods = methods;
        inBackground = true;
        notificationStack = null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface CordovaMethod {
    }
}

