/*
 * Decompiled with CFR 0.152.
 */
package app.youkai.progressview;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import app.youkai.progressview.IncrementListener;
import app.youkai.progressview.LongTouchHandler;
import app.youkai.progressview.R;
import java.util.Timer;
import java.util.TimerTask;

public class ProgressView
extends LinearLayout {
    private ImageView decrement;
    private EditText progressView;
    private TextView maxView;
    private ImageView increment;
    private int progress;
    private int max;
    private OnProgressChangedListener listener;
    private LongTouchHandler decrementHandler;
    private LongTouchHandler incrementHandler;
    private boolean fromButton;

    public ProgressView(Context context) {
        this(context, null);
    }

    public ProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public ProgressView(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs);
        this.init(attrs, defStyle, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs, int defStyle, int defStyleRes) {
        boolean showMax;
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.view_progressview, (ViewGroup)this, true);
        this.setOrientation(0);
        this.setGravity(16);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayoutTransition(new LayoutTransition());
        }
        this.decrement = (ImageView)this.findViewById(R.id.decrement);
        this.progressView = (EditText)this.findViewById(R.id.progress);
        this.maxView = (TextView)this.findViewById(R.id.max);
        this.increment = (ImageView)this.findViewById(R.id.increment);
        this.decrementHandler = new LongTouchHandler(new IncrementListener(){

            @Override
            public void increment() {
                ProgressView.this.decrement.post(new Runnable(){

                    @Override
                    public void run() {
                        ProgressView.this.decrementProgress();
                    }
                });
            }

            @Override
            public void incrementBy(final int changeValue) {
                ProgressView.this.decrement.post(new Runnable(){

                    @Override
                    public void run() {
                        ProgressView.this.addToProgress(changeValue);
                    }
                });
            }
        }, -1);
        this.decrement.setOnTouchListener((View.OnTouchListener)this.decrementHandler);
        this.incrementHandler = new LongTouchHandler(new IncrementListener(){

            @Override
            public void increment() {
                ProgressView.this.increment.post(new Runnable(){

                    @Override
                    public void run() {
                        ProgressView.this.incrementProgress();
                    }
                });
            }

            @Override
            public void incrementBy(final int changeValue) {
                ProgressView.this.increment.post(new Runnable(){

                    @Override
                    public void run() {
                        ProgressView.this.addToProgress(changeValue);
                    }
                });
            }
        }, 1);
        this.increment.setOnTouchListener((View.OnTouchListener)this.incrementHandler);
        this.progressView.addTextChangedListener(new TextWatcher(){
            Timer timer = new Timer();
            String lastText = "";

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (ProgressView.this.fromButton) {
                    ProgressView.this.fromButton = false;
                    return;
                }
                final String text = ProgressView.this.progressView.getText().toString().trim();
                if (this.lastText.equals(text)) {
                    return;
                }
                this.lastText = text;
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){
                    int newProgress;

                    @Override
                    public void run() {
                        this.newProgress = Integer.parseInt(text.length() != 0 ? text : "0");
                        this.newProgress = Math.max(this.newProgress, 0);
                        if (ProgressView.this.max != 0 && this.newProgress > ProgressView.this.max) {
                            this.newProgress = ProgressView.this.max;
                        }
                        ProgressView.this.progressView.post(new Runnable(){

                            @Override
                            public void run() {
                                ProgressView.this.setProgress(newProgress);
                            }
                        });
                    }
                }, 500L);
            }
        });
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.ProgressView, defStyle, defStyleRes);
        try {
            showMax = a.getBoolean(R.styleable.ProgressView_pv_showMax, false);
        }
        finally {
            a.recycle();
        }
        this.showMax(showMax);
        this.setProgress(0);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.progress = this.progress;
        savedState.max = this.max;
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.setMax(this.max);
        this.setProgress(savedState.progress);
    }

    public void setListener(OnProgressChangedListener listener) {
        this.listener = listener;
    }

    public void setProgress(int progress) {
        if (progress < 0) {
            throw new IllegalArgumentException("Pro-gress cannot be negative. That's con-gress!");
        }
        if (this.max != 0 && progress > this.max) {
            throw new IllegalArgumentException("Progress cannot be greater than the maximum.");
        }
        this.progress = progress;
        this.progressView.setText((CharSequence)String.valueOf(progress));
        this.progressView.setSelection(this.progressView.getText().length());
        if (progress == 0) {
            this.decrement.setClickable(false);
            this.decrement.setPressed(false);
            this.decrementHandler.cancelPress();
            this.increment.setClickable(true);
        } else if (progress == this.max) {
            this.increment.setClickable(false);
            this.increment.setPressed(false);
            this.incrementHandler.cancelPress();
            this.decrement.setClickable(true);
        } else {
            this.decrement.setClickable(true);
            this.increment.setClickable(true);
        }
        this.notifyProgressChanged();
    }

    public int getProgress() {
        return this.progress;
    }

    public void decrementProgress() {
        this.setProgress(this.progress - 1);
    }

    public void incrementProgress() {
        this.setProgress(this.progress + 1);
    }

    private void addToProgress(int change) {
        this.setProgress(this.progress + change);
    }

    @SuppressLint(value={"SetTextI18n"})
    public void setMax(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("Total cannot be less than or equal to zero.");
        }
        this.max = max;
        this.fromButton = true;
        this.maxView.setText((CharSequence)("/ " + max));
        if (max > this.progress) {
            this.setProgress(max);
        }
    }

    public int getMax() {
        return this.max;
    }

    public void showMax(boolean show) {
        this.maxView.setVisibility(show ? 0 : 8);
    }

    private void notifyProgressChanged() {
        if (this.listener != null) {
            this.listener.onProgressChanged(this.progress);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        int progress;
        int max;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.progress = in.readInt();
            this.max = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.progress);
            out.writeInt(this.max);
        }
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(int var1);
    }
}

