/*
 * Decompiled with CFR 0.152.
 */
package app.youkai.progressview;

import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import app.youkai.progressview.IncrementListener;
import java.util.Timer;
import java.util.TimerTask;

class LongTouchHandler
implements View.OnTouchListener {
    private IncrementListener incrementListener;
    private Timer timer;
    private int incrementBy;

    LongTouchHandler(IncrementListener incrementListener, int incrementBy) {
        this.incrementListener = incrementListener;
        this.incrementBy = incrementBy;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (v.isClickable()) {
            if (event.getAction() == 0) {
                v.setPressed(true);
                this.timer = new Timer();
                this.timer.schedule((TimerTask)new IncrementTask(0, ViewConfiguration.getLongPressTimeout()), ViewConfiguration.getLongPressTimeout());
            } else if (event.getAction() == 1) {
                this.timer.cancel();
                v.setPressed(false);
            }
            long lengthOfPress = event.getEventTime() - event.getDownTime();
            if (lengthOfPress < (long)ViewConfiguration.getLongPressTimeout() && event.getAction() == 1) {
                this.incrementListener.increment();
            }
            return true;
        }
        return false;
    }

    void cancelPress() {
        try {
            this.timer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class IncrementTask
    extends TimerTask {
        private int count;
        private final long initialDelay;

        IncrementTask(int count, long initialDelay) {
            this.count = count;
            this.initialDelay = initialDelay;
        }

        @Override
        public void run() {
            LongTouchHandler.this.incrementListener.incrementBy(LongTouchHandler.this.incrementBy);
            ++this.count;
            LongTouchHandler.this.timer.schedule((TimerTask)new IncrementTask(this.count, this.initialDelay), (long)(this.newTimerCoefficient(this.count) * (double)this.initialDelay));
        }

        private double newTimerCoefficient(int count) {
            return 0.2 + Math.exp(-0.3 * (double)count);
        }
    }
}

