/*
 * Decompiled with CFR 0.152.
 */
package app.youkai.progressview;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import app.youkai.progressview.R;
import java.util.Timer;
import java.util.TimerTask;

public class ProgressView
extends LinearLayout {
    private ImageView decrement;
    private EditText progressView;
    private TextView totalView;
    private ImageView increment;
    private int progress;
    private int total;
    private OnProgressChangedListener listener;
    private boolean fromButton;

    public ProgressView(Context context) {
        this(context, null);
    }

    public ProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    public ProgressView(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        super(context, attrs);
        this.init(attrs, defStyle, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs, int defStyle, int defStyleRes) {
        boolean showTotal;
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.view_progressview, (ViewGroup)this, true);
        this.setOrientation(0);
        this.setGravity(16);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayoutTransition(new LayoutTransition());
        }
        this.decrement = (ImageView)this.findViewById(R.id.decrement);
        this.progressView = (EditText)this.findViewById(R.id.progress);
        this.totalView = (TextView)this.findViewById(R.id.total);
        this.increment = (ImageView)this.findViewById(R.id.increment);
        this.decrement.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProgressView.this.setProgress(ProgressView.this.progress - 1);
            }
        });
        this.increment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProgressView.this.setProgress(ProgressView.this.progress + 1);
            }
        });
        this.progressView.addTextChangedListener(new TextWatcher(){
            Timer timer = new Timer();
            String lastText = "";

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (ProgressView.this.fromButton) {
                    ProgressView.this.fromButton = false;
                    return;
                }
                final String text = ProgressView.this.progressView.getText().toString().trim();
                if (this.lastText.equals(text)) {
                    return;
                }
                this.lastText = text;
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){
                    int newProgress;

                    @Override
                    public void run() {
                        this.newProgress = Integer.parseInt(text.length() != 0 ? text : "0");
                        this.newProgress = Math.max(this.newProgress, 0);
                        if (ProgressView.this.total != 0 && this.newProgress > ProgressView.this.total) {
                            this.newProgress = ProgressView.this.total;
                        }
                        ProgressView.this.progressView.post(new Runnable(){

                            @Override
                            public void run() {
                                ProgressView.this.setProgress(newProgress);
                            }
                        });
                    }
                }, 500L);
            }
        });
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.ProgressView, defStyle, defStyleRes);
        try {
            showTotal = a.getBoolean(R.styleable.ProgressView_pv_showTotal, false);
        }
        finally {
            a.recycle();
        }
        this.totalView.setVisibility(showTotal ? 0 : 8);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.progress = this.progress;
        savedState.total = this.total;
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.progress = savedState.progress;
        this.total = savedState.total;
    }

    public void setListener(OnProgressChangedListener listener) {
        this.listener = listener;
    }

    public void setProgress(int progress) {
        if (progress < 0) {
            return;
        }
        if (this.total != 0 && progress > this.total) {
            return;
        }
        this.progress = progress;
        this.progressView.setText((CharSequence)String.valueOf(progress));
        this.notifyProgressChanged();
    }

    public int getProgress() {
        return this.progress;
    }

    @SuppressLint(value={"SetTextI18n"})
    public void setTotal(int total) {
        if (total <= 0) {
            throw new IllegalArgumentException("Total cannot be less than or equal to zero");
        }
        this.total = total;
        this.fromButton = true;
        this.totalView.setText((CharSequence)("/ " + total));
    }

    public int getTotal() {
        return this.total;
    }

    private void notifyProgressChanged() {
        if (this.listener != null) {
            this.listener.onProgressChanged(this.progress);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int progress;
        int total;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.progress = in.readInt();
            this.total = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.progress);
            out.writeInt(this.total);
        }
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(int var1);
    }
}

