/*
 * Decompiled with CFR 0.152.
 */
package app.youkai.placeholdertextview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import app.youkai.placeholdertextview.ExtKt;
import app.youkai.placeholdertextview.R;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\r\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ%\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b)J\u0006\u0010*\u001a\u00020\tJ\b\u0010+\u001a\u0004\u0018\u00010\u001aJ3\u0010,\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010-\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010.J\r\u0010/\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b0J\r\u00101\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b2J\u0010\u00103\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\tH\u0014J*\u00107\u001a\u00020\u001e2\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\tH\u0014J\u000e\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\tJ\u000e\u0010?\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\u001aJ\r\u0010@\u001a\u00020AH\u0000\u00a2\u0006\u0002\bBR\u001b\u0010\u000b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0012\u0010\u0018\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lapp/youkai/placeholdertextview/PlaceholderTextView;", "Landroid/support/v7/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "LINE_SPACING", "getLINE_SPACING", "()I", "LINE_SPACING$delegate", "Lkotlin/Lazy;", "linesToDraw", "", "placeholderColor", "Ljava/lang/Integer;", "placeholderLineHeight", "placeholderPaint", "Landroid/graphics/Paint;", "ruleLines", "ruleMaxLines", "sampleText", "", "singleLineWidth", "totalPlaceholderWidth", "calculatePlaceholderValues", "", "calculatePlaceholderValues$library_release", "drawLine", "canvas", "Landroid/graphics/Canvas;", "top", "width", "drawLine$library_release", "drawPlaceholder", "drawPlaceholder$library_release", "getAvgCharWidth", "getAvgCharWidth$library_release", "getPlaceholderColor", "getSampleText", "init", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;Ljava/lang/Integer;Ljava/lang/Integer;)V", "loadPlaceholderColor", "loadPlaceholderColor$library_release", "loadPlaceholderLineHeight", "loadPlaceholderLineHeight$library_release", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onTextChanged", "text", "", "start", "lengthBefore", "lengthAfter", "setPlaceholderColor", "color", "setSampleText", "shouldShowPlaceholder", "", "shouldShowPlaceholder$library_release", "library_release"})
public final class PlaceholderTextView
extends AppCompatTextView {
    private final Lazy LINE_SPACING$delegate;
    private String sampleText;
    private Integer placeholderColor;
    private Integer ruleLines;
    private Integer ruleMaxLines;
    private float totalPlaceholderWidth;
    private float singleLineWidth;
    private float linesToDraw;
    private float placeholderLineHeight;
    private final Paint placeholderPaint;
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final int getLINE_SPACING() {
        Lazy lazy = this.LINE_SPACING$delegate;
        PlaceholderTextView placeholderTextView = this;
        KProperty kProperty = $$delegatedProperties[0];
        return ((Number)lazy.getValue()).intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(Context context, AttributeSet attrs, Integer defStyleAttr, Integer defStyleRes) {
        Integer n = defStyleAttr;
        Integer n2 = defStyleRes;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PlaceholderTextView, n != null ? n : 0, n2 != null ? n2 : 0);
        int[] androidAttrs = new int[]{16843092, 16843091};
        TypedArray ta = context.obtainStyledAttributes(attrs, androidAttrs);
        try {
            int lines = ta.getInt(0, 0);
            int maxLines = ta.getInt(1, 0);
            if (lines != 0) {
                this.ruleLines = lines;
            }
            if (maxLines != 0) {
                this.ruleMaxLines = maxLines;
            }
        }
        finally {
            ta.recycle();
        }
        try {
            this.sampleText = a.getString(R.styleable.PlaceholderTextView_ptv_sampleText);
            int color = a.getColor(R.styleable.PlaceholderTextView_ptv_placeholderColor, 0);
            this.placeholderColor = color != 0 ? Integer.valueOf(color) : null;
        }
        finally {
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.shouldShowPlaceholder$library_release()) {
            this.calculatePlaceholderValues$library_release();
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int desiredWidth = Math.round(this.singleLineWidth) + this.getCompoundPaddingLeft() + this.getCompoundPaddingRight();
            int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? Math.min(desiredWidth, widthSize) : desiredWidth);
            double linesCount = Math.ceil(this.linesToDraw);
            double lineSpacing = (linesCount - 1.0) * (double)this.getLINE_SPACING();
            int padding = this.getCompoundPaddingTop() + this.getCompoundPaddingBottom();
            int desiredHeight = (int)Math.round(linesCount * (double)this.placeholderLineHeight + (double)padding + lineSpacing);
            int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? Math.min(desiredHeight, heightSize) : desiredHeight);
            this.setMeasuredDimension(width, height);
            this.calculatePlaceholderValues$library_release();
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public final float getAvgCharWidth$library_release() {
        return this.placeholderLineHeight * 0.45f;
    }

    /*
     * WARNING - void declaration
     */
    public final void calculatePlaceholderValues$library_release() {
        float f;
        this.loadPlaceholderColor$library_release();
        this.loadPlaceholderLineHeight$library_release();
        int availableWidth = this.getMeasuredWidth() != 0 ? this.getMeasuredWidth() : this.getContext().getResources().getDisplayMetrics().widthPixels;
        String string = this.sampleText;
        this.totalPlaceholderWidth = (string != null ? (float)string.length() : 0.0f) * this.getAvgCharWidth$library_release();
        this.singleLineWidth = Math.max((float)(availableWidth - (this.getCompoundPaddingLeft() + this.getCompoundPaddingRight())), 1.0f);
        if (this.totalPlaceholderWidth > (float)availableWidth) {
            float lines = this.totalPlaceholderWidth / this.singleLineWidth;
            int linesRound = (int)Math.ceil(lines);
            if (this.ruleLines != null) {
                Integer n = this.ruleLines;
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                if (linesRound > n) {
                    Integer n2 = this.ruleLines;
                    if (n2 == null) {
                        Intrinsics.throwNpe();
                    }
                    f = n2.intValue();
                } else {
                    f = lines;
                }
            } else if (this.ruleMaxLines != null) {
                Integer n = this.ruleMaxLines;
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                if (linesRound > n) {
                    Integer n3 = this.ruleMaxLines;
                    if (n3 == null) {
                        Intrinsics.throwNpe();
                    }
                    f = n3.intValue();
                } else {
                    f = lines;
                }
            } else {
                void var2_2;
                f = var2_2;
            }
        } else {
            f = 1.0f;
        }
        this.linesToDraw = f;
    }

    public final void loadPlaceholderColor$library_release() {
        int n;
        if (this.placeholderColor != null) {
            Integer n2 = this.placeholderColor;
            if (n2 == null) {
                Intrinsics.throwNpe();
            }
            n = n2;
        } else {
            n = this.getCurrentTextColor() & 0xFFFFFF | 0x33000000;
        }
        this.placeholderPaint.setColor(n);
    }

    public final void loadPlaceholderLineHeight$library_release() {
        this.placeholderLineHeight = this.getTextSize();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.shouldShowPlaceholder$library_release()) {
            this.drawPlaceholder$library_release(canvas);
        } else {
            super.onDraw(canvas);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void drawPlaceholder$library_release(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.linesToDraw == 1.0f) {
            this.drawLine$library_release(canvas, this.getCompoundPaddingTop(), this.totalPlaceholderWidth);
        } else {
            float lastLineWidthMultiplier;
            int n = 0;
            int n2 = (int)this.linesToDraw - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (i == false) {
                        this.drawLine$library_release(canvas, this.getCompoundPaddingTop(), this.singleLineWidth);
                    } else {
                        this.drawLine$library_release(canvas, (float)this.getCompoundPaddingTop() + (this.placeholderLineHeight + (float)this.getLINE_SPACING()) * (float)i, this.singleLineWidth);
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if ((lastLineWidthMultiplier = this.linesToDraw - (float)((int)this.linesToDraw)) > 0.0f) {
                this.drawLine$library_release(canvas, (float)this.getCompoundPaddingTop() + (this.placeholderLineHeight + (float)this.getLINE_SPACING()) * (float)((int)this.linesToDraw), this.singleLineWidth * lastLineWidthMultiplier);
            }
        }
    }

    public final void drawLine$library_release(@NotNull Canvas canvas, float top, float width) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        float left = this.getCompoundPaddingLeft();
        float right = left + width;
        float bottom = top + this.placeholderLineHeight;
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        float cornerRadius = ExtKt.toPx(4, context);
        canvas.drawRoundRect(new RectF(left, top, right, bottom), cornerRadius, cornerRadius, this.placeholderPaint);
    }

    public final boolean shouldShowPlaceholder$library_release() {
        CharSequence charSequence = this.getText();
        return charSequence.length() == 0;
    }

    public final void setSampleText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.sampleText = text;
        this.requestLayout();
    }

    @Nullable
    public final String getSampleText() {
        return this.sampleText;
    }

    public final void setPlaceholderColor(int color) {
        this.placeholderColor = color != 0 ? Integer.valueOf(color) : null;
        this.invalidate();
    }

    public final int getPlaceholderColor() {
        return this.placeholderPaint.getColor();
    }

    protected void onTextChanged(@Nullable CharSequence text, int start, int lengthBefore, int lengthAfter) {
        this.requestLayout();
    }

    public PlaceholderTextView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.LINE_SPACING$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ PlaceholderTextView this$0;

            public final int invoke() {
                Context context = this.this$0.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                return ExtKt.toPx(4, context);
            }
            {
                this.this$0 = placeholderTextView;
                super(0);
            }
        }));
        this.placeholderPaint = new Paint(1);
        this.init(context, null, null, null);
    }

    public PlaceholderTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.LINE_SPACING$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.placeholderPaint = new Paint(1);
        this.init(context, attrs, null, null);
    }

    public PlaceholderTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.LINE_SPACING$delegate = LazyKt.lazy((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
        this.placeholderPaint = new Paint(1);
        this.init(context, attrs, defStyleAttr, null);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PlaceholderTextView.class), "LINE_SPACING", "getLINE_SPACING()I"))};
    }
}

