package app.raybritton.tokenstorage.room

import android.arch.persistence.room.Room
import android.content.Context
import app.raybritton.tokenstorage.Persistence

/**
 * Uses the Room library to persist strings to SQLite
 *
 * @param filename The name of the database file
 *
 * @param inMemory If true the database will be created in memory
 */
class RoomPersistence(private val context: Context,
                      private val filename: String = "tokens.db",
                      private val inMemory: Boolean = false) : Persistence {

    private val db by lazy {
        if (inMemory) {
            Room.inMemoryDatabaseBuilder(context, CryptoDatabase::class.java)
                    .allowMainThreadQueries()
                    .build()
        } else {
            Room.databaseBuilder(context, CryptoDatabase::class.java, filename).build()
        }
    }

    override fun clearAll() {
        db.crpytoDao().deleteAll()
    }

    override fun clear(id: String) {
        db.crpytoDao().delete(id)
    }

    override fun save(id: String, value: String) {
        db.crpytoDao().insert(Encrypted(id, value))
    }

    override fun load(id: String): String? {
        return db.crpytoDao().get(id)?.value
    }

}