/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.elog.data;

import app.raybritton.elog.ELog;
import app.raybritton.elog.ELogConfig;
import app.raybritton.elog.arch.LogModule;
import app.raybritton.elog.data.ELogTree;
import app.raybritton.elog.data.LogFile;
import app.raybritton.elog.data.LogPreferences;
import app.raybritton.elog.data.LogUpload;
import app.raybritton.elog.data.Result;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JM\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\u000e2!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00100\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lapp/raybritton/elog/data/LogUpload;", "", "()V", "dateFormatter", "Ljava/text/SimpleDateFormat;", "okhttp", "Lokhttp3/OkHttpClient;", "kotlin.jvm.PlatformType", "getOkhttp", "()Lokhttp3/OkHttpClient;", "okhttp$delegate", "Lkotlin/Lazy;", "uploading", "Ljava/util/concurrent/CopyOnWriteArraySet;", "", "upload", "", "log", "Lapp/raybritton/elog/data/LogFile;", "manual", "", "logTitle", "code", "onComplete", "Lkotlin/Function1;", "Lapp/raybritton/elog/data/Result;", "Lkotlin/ParameterName;", "name", "result", "lib_release"})
public final class LogUpload {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private CopyOnWriteArraySet<String> uploading = new CopyOnWriteArraySet();
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.UK);
    private final Lazy okhttp$delegate = LazyKt.lazy((Function0)okhttp.2.INSTANCE);

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LogUpload.class), "okhttp", "getOkhttp()Lokhttp3/OkHttpClient;"))};
    }

    private final OkHttpClient getOkhttp() {
        Lazy lazy = this.okhttp$delegate;
        LogUpload logUpload = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (OkHttpClient)lazy.getValue();
    }

    public final void upload(@NotNull LogFile log, boolean manual, @Nullable String logTitle, @NotNull String code, @NotNull Function1<? super Result, Unit> onComplete) {
        block10: {
            block9: {
                Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
                Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
                Intrinsics.checkParameterIsNotNull(onComplete, (String)"onComplete");
                if (StringsKt.isBlank((CharSequence)ELog.INSTANCE.getUploadServerUrl$lib_release())) {
                    throw (Throwable)new IllegalStateException("uploadServerUrl has not been set");
                }
                if (StringsKt.isBlank((CharSequence)ELogConfig.INSTANCE.getApiPath())) {
                    throw (Throwable)new IllegalStateException("apiPath has not been set");
                }
                if (this.uploading.contains(log.getId())) {
                    Timber.d((String)("Already uploading " + log.getId()), (Object[])new Object[0]);
                    return;
                }
                if (log.getCode() != null) {
                    Timber.d((String)"Log already submitted", (Object[])new Object[0]);
                    throw (Throwable)new IllegalStateException("Log already submitted");
                }
                CharSequence charSequence = ELog.INSTANCE.getAppBuild();
                boolean bl = false;
                if (charSequence.length() == 0) break block9;
                charSequence = ELog.INSTANCE.getAppPackage();
                bl = false;
                if (charSequence.length() == 0) break block9;
                charSequence = ELog.INSTANCE.getAppVersionName();
                bl = false;
                if (!(charSequence.length() == 0)) break block10;
            }
            throw (Throwable)new IllegalStateException("ELog.appBuild, appPackage, appVersion and appVersionName must be set before submitting a log");
        }
        this.uploading.add(log.getId());
        MediaType mediaType = MediaType.get((String)"text/plain");
        RequestBody body = RequestBody.create((MediaType)mediaType, (File)log.getFile());
        Request.Builder builder = new Request.Builder().url(ELog.INSTANCE.getUploadServerUrl$lib_release() + ELogConfig.INSTANCE.getApiPath()).header("x-code", code).header("x-version", ELog.INSTANCE.getAppVersionName()).header("x-version-code", String.valueOf(ELog.INSTANCE.getAppVersion())).header("x-app", ELog.INSTANCE.getAppPackage()).header("x-build", ELog.INSTANCE.getAppBuild()).header("x-created", this.dateFormatter.format(new Date(log.getCreated()))).header("x-device-id", LogPreferences.INSTANCE.getDeviceId$lib_release()).header("x-manual", String.valueOf(manual)).header("x-lib-ver", "3").header("x-addt-info", URLEncoder.encode(ELog.INSTANCE.getAdditionalInfo(), "UTF-8")).header("x-user-id", ELog.INSTANCE.getUserId()).header("x-platform", "android");
        boolean bl = false;
        boolean bl2 = false;
        Request.Builder $this$apply = builder;
        boolean bl3 = false;
        if (logTitle != null) {
            $this$apply.header("x-auto-title", logTitle);
        }
        if (log.getContinuationCode() != null) {
            $this$apply.header("x-cont-code", log.getContinuationCode());
        }
        Request request = builder.post(body).build();
        this.getOkhttp().newCall(request).enqueue(new Callback(this, onComplete, log, code){
            final /* synthetic */ LogUpload this$0;
            final /* synthetic */ Function1 $onComplete;
            final /* synthetic */ LogFile $log;
            final /* synthetic */ String $code;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$onComplete.invoke((Object)new Result.Error(e));
                LogUpload.access$getUploading$p(this.this$0).remove(this.$log.getId());
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (response.isSuccessful()) {
                    if (Intrinsics.areEqual((Object)this.$log.getFile().getAbsolutePath(), (Object)ELogTree.Companion.getFile$lib_release().getAbsolutePath())) {
                        ELogTree.Companion.setFile$lib_release(LogModule.INSTANCE.getLogManager$lib_release().createLog$lib_release(this.$code));
                        Timber.d((String)"New file started", (Object[])new Object[0]);
                    }
                    LogModule.INSTANCE.getLogManager$lib_release().setCodeForLog$lib_release(this.$log, this.$code);
                    this.$onComplete.invoke((Object)new Result.Success(this.$code));
                } else {
                    this.$onComplete.invoke((Object)new Result.Error(new IOException("" + response.code() + ' ' + response.message())));
                }
                LogUpload.access$getUploading$p(this.this$0).remove(this.$log.getId());
            }
            {
                this.this$0 = $outer;
                this.$onComplete = $captured_local_variable$1;
                this.$log = $captured_local_variable$2;
                this.$code = $captured_local_variable$3;
            }
        });
    }

    public static /* synthetic */ void upload$default(LogUpload logUpload, LogFile logFile, boolean bl, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = ELog.generateCode$lib_release$default(ELog.INSTANCE, null, 1, null);
        }
        logUpload.upload(logFile, bl, string, string2, (Function1<? super Result, Unit>)function1);
    }

    public static final /* synthetic */ CopyOnWriteArraySet access$getUploading$p(LogUpload $this) {
        return $this.uploading;
    }

    public static final /* synthetic */ void access$setUploading$p(LogUpload $this, CopyOnWriteArraySet copyOnWriteArraySet) {
        $this.uploading = copyOnWriteArraySet;
    }
}

