package app.raybritton.elog.data

import android.util.Log
import app.raybritton.elog.arch.LogModule
import timber.log.Timber
import java.io.File
import java.text.SimpleDateFormat
import java.util.*

class ELogTree : Timber.Tree() {
    init {
        file = LogModule.logManager.createLog()
    }

    val dateFormatter = SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.UK)

    override fun log(priority: Int, tag: String?, message: String, t: Throwable?) {
        val builder = StringBuilder()
        builder.append(dateFormatter.format(Date()))
        builder.append(" ")
        builder.append(priorityToLetter(priority))
        builder.append(": ")
        builder.append(message)
        builder.append("\n")
        file.appendText(builder.toString())
    }

    private fun priorityToLetter(priority: Int): String {
        return when (priority) {
            Log.ASSERT -> "A"
            Log.DEBUG -> "D"
            Log.ERROR -> "E"
            Log.VERBOSE -> "V"
            Log.WARN -> "W"
            Log.INFO -> "I"
            else -> "?"
        }

    }

    companion object {
        internal lateinit var file: File
    }
}