package app.raybritton.elog.ui

import android.content.Context
import android.os.Build
import androidx.annotation.ColorRes
import androidx.recyclerview.widget.RecyclerView

fun Context.getColorById(@ColorRes id: Int): Int {
    return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
        resources.getColor(id, theme)
    } else {
        resources.getColor(id)
    }
}

fun RecyclerView.ViewHolder.getColorById(@ColorRes id: Int): Int {
    return itemView.context.getColorById(id)
}