package app.raybritton.tokenstorage

import io.reactivex.Completable
import io.reactivex.Flowable

class RxTokenWrapper(private val tokenStorage: RxTokenStorage<*,*,*>,
                   val key: String): CryptoLogging {
    fun save(plaintext: String): Completable {
        fine("save($plaintext)")
        return tokenStorage.save(key, plaintext)
    }

    fun load(): Flowable<Optional<String>> {
        fine("load()")
        return tokenStorage.load(key)
    }

    fun isSet(): Flowable<Boolean> {
        fine("isSet()")
        return tokenStorage.contains(key)
    }

    fun clear(): Completable {
        fine("clear()")
        return tokenStorage.clear(key)
    }

    fun clearSync() {
        fine("clearSync()")
        return tokenStorage.clearSync(key)
    }

    fun saveSync(plaintext: String) {
        fine("saveSync($plaintext)")
        return tokenStorage.saveSync(key, plaintext)
    }

    fun loadSync(): String? {
        fine("loadSync()")
        return tokenStorage.loadSync(key)
    }

    fun isSetSync(): Boolean {
        fine("isSetSync()")
        return tokenStorage.containsSync(key)
    }

    override fun logPrefix(): String = "[${Thread.currentThread().name}]-${this::class.java.simpleName}{${System.identityHashCode(this)}}[$key] - "
}