/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.tokenstorage.crypto;

import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import app.raybritton.tokenstorage.crypto.Crypto;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0016H\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lapp/raybritton/tokenstorage/crypto/CertCrypto;", "Lapp/raybritton/tokenstorage/crypto/Crypto;", "alias", "", "userMustBeAuthenticated", "", "invalidateOnBiometricChange", "(Ljava/lang/String;ZZ)V", "ENCRYPT_ALGORITHM", "KEYSTORE_TYPE", "privateKey", "Ljava/security/PrivateKey;", "publicKey", "Ljava/security/PublicKey;", "decrypt", "encrypted", "encrypt", "plaintext", "loadCert", "verify", "", "setupBiometrics", "Landroid/security/keystore/KeyGenParameterSpec$Builder;", "core_release"})
public final class CertCrypto
implements Crypto {
    private final String KEYSTORE_TYPE = "AndroidKeyStore";
    private final String ENCRYPT_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private final String alias;
    private final boolean userMustBeAuthenticated;
    private final boolean invalidateOnBiometricChange;

    private final boolean loadCert() {
        KeyStore keyStore = KeyStore.getInstance(this.KEYSTORE_TYPE);
        keyStore.load(null);
        if (keyStore.containsAlias(this.alias)) {
            Key key = keyStore.getKey(this.alias, null);
            if (key == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.PrivateKey");
            }
            this.privateKey = (PrivateKey)key;
            Certificate certificate = keyStore.getCertificate(this.alias);
            Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"keyStore.getCertificate(alias)");
            this.publicKey = certificate.getPublicKey();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String encrypt(@NotNull String plaintext) {
        Intrinsics.checkParameterIsNotNull((Object)plaintext, (String)"plaintext");
        Cipher cipher = Cipher.getInstance(this.ENCRYPT_ALGORITHM);
        cipher.init(1, this.publicKey);
        String string = plaintext;
        Cipher cipher2 = cipher;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] encrypted = cipher2.doFinal(byArray2);
        String string2 = Base64.encodeToString((byte[])encrypted, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64.encodeToString(encrypted, Base64.NO_WRAP)");
        return string2;
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String encrypted) {
        Intrinsics.checkParameterIsNotNull((Object)encrypted, (String)"encrypted");
        Cipher cipher = Cipher.getInstance(this.ENCRYPT_ALGORITHM);
        cipher.init(2, this.privateKey);
        byte[] encryptedData = Base64.decode((String)encrypted, (int)0);
        byte[] decodedData = cipher.doFinal(encryptedData);
        Intrinsics.checkExpressionValueIsNotNull((Object)decodedData, (String)"decodedData");
        byte[] byArray = decodedData;
        return new String(byArray, Charsets.UTF_8);
    }

    @Override
    public void verify() {
        if (!this.loadCert()) {
            KeyPair keyPair;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", this.KEYSTORE_TYPE);
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.alias, 3).setBlockModes(new String[]{"ECB"}).setEncryptionPaddings(new String[]{"PKCS1Padding"}).setUserAuthenticationRequired(this.userMustBeAuthenticated);
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"KeyGenParameterSpec.Buil\u2026(userMustBeAuthenticated)");
            keyPairGenerator.initialize((AlgorithmParameterSpec)this.setupBiometrics(builder).build());
            KeyPair keyPair2 = keyPair = keyPairGenerator.generateKeyPair();
            Intrinsics.checkExpressionValueIsNotNull((Object)keyPair2, (String)"keyPair");
            this.privateKey = keyPair2.getPrivate();
            this.publicKey = keyPair.getPublic();
        }
    }

    private final KeyGenParameterSpec.Builder setupBiometrics(@NotNull KeyGenParameterSpec.Builder $receiver) {
        if (Build.VERSION.SDK_INT >= 24) {
            $receiver.setInvalidatedByBiometricEnrollment(this.invalidateOnBiometricChange);
        }
        return $receiver;
    }

    public CertCrypto(@NotNull String alias, boolean userMustBeAuthenticated, boolean invalidateOnBiometricChange) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        this.alias = alias;
        this.userMustBeAuthenticated = userMustBeAuthenticated;
        this.invalidateOnBiometricChange = invalidateOnBiometricChange;
        this.KEYSTORE_TYPE = "AndroidKeyStore";
        this.ENCRYPT_ALGORITHM = "RSA/ECB/PKCS1Padding";
    }

    public /* synthetic */ CertCrypto(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(string, bl, bl2);
    }
}

