/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.tokenstorage;

import app.raybritton.tokenstorage.TokenWrapper;
import app.raybritton.tokenstorage.crypto.Crypto;
import app.raybritton.tokenstorage.keyCrypto.KeyCrypto;
import app.raybritton.tokenstorage.keyCrypto.NoKeyCrypto;
import app.raybritton.tokenstorage.persistence.Persistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lapp/raybritton/tokenstorage/TokenStorage;", "", "crypto", "Lapp/raybritton/tokenstorage/crypto/Crypto;", "persistence", "Lapp/raybritton/tokenstorage/persistence/Persistence;", "keyCrypto", "Lapp/raybritton/tokenstorage/keyCrypto/KeyCrypto;", "(Lapp/raybritton/tokenstorage/crypto/Crypto;Lapp/raybritton/tokenstorage/persistence/Persistence;Lapp/raybritton/tokenstorage/keyCrypto/KeyCrypto;)V", "getCrypto", "()Lapp/raybritton/tokenstorage/crypto/Crypto;", "getKeyCrypto", "()Lapp/raybritton/tokenstorage/keyCrypto/KeyCrypto;", "getPersistence", "()Lapp/raybritton/tokenstorage/persistence/Persistence;", "clear", "", "key", "", "clearAll", "contains", "", "keys", "", "load", "save", "plaintext", "wrap", "Lapp/raybritton/tokenstorage/TokenWrapper;", "core_release"})
public class TokenStorage {
    @NotNull
    private final Crypto crypto;
    @NotNull
    private final Persistence persistence;
    @NotNull
    private final KeyCrypto keyCrypto;

    public final void clearAll() {
        this.crypto.verify();
        this.keyCrypto.verify();
        this.persistence.clearAll();
    }

    public final void clear(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.crypto.verify();
        this.keyCrypto.verify();
        this.persistence.clear(this.keyCrypto.encrypt(key));
    }

    public final void save(@NotNull String key, @NotNull String plaintext) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)plaintext, (String)"plaintext");
        this.crypto.verify();
        this.keyCrypto.verify();
        this.persistence.save(this.keyCrypto.encrypt(key), this.crypto.encrypt(plaintext));
    }

    @Nullable
    public final String load(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.crypto.verify();
        this.keyCrypto.verify();
        String encrypted = this.persistence.load(this.keyCrypto.encrypt(key));
        if (encrypted == null) {
            return null;
        }
        return this.crypto.decrypt(encrypted);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> keys() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        this.crypto.verify();
        this.keyCrypto.verify();
        Iterable iterable = $receiver$iv = (Iterable)this.persistence.keys();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string2 = this.keyCrypto.decrypt((String)it);
            collection.add(string2);
        }
        return (List)var3_3;
    }

    public final boolean contains(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.crypto.verify();
        this.keyCrypto.verify();
        return this.persistence.contains(this.keyCrypto.encrypt(key));
    }

    @NotNull
    public final TokenWrapper wrap(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return new TokenWrapper(this, key);
    }

    @NotNull
    public final Crypto getCrypto() {
        return this.crypto;
    }

    @NotNull
    public final Persistence getPersistence() {
        return this.persistence;
    }

    @NotNull
    public final KeyCrypto getKeyCrypto() {
        return this.keyCrypto;
    }

    public TokenStorage(@NotNull Crypto crypto, @NotNull Persistence persistence, @NotNull KeyCrypto keyCrypto) {
        Intrinsics.checkParameterIsNotNull((Object)crypto, (String)"crypto");
        Intrinsics.checkParameterIsNotNull((Object)persistence, (String)"persistence");
        Intrinsics.checkParameterIsNotNull((Object)keyCrypto, (String)"keyCrypto");
        this.crypto = crypto;
        this.persistence = persistence;
        this.keyCrypto = keyCrypto;
    }

    public /* synthetic */ TokenStorage(Crypto crypto, Persistence persistence, KeyCrypto keyCrypto, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            keyCrypto = new NoKeyCrypto();
        }
        this(crypto, persistence, keyCrypto);
    }
}

