/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.tokenstorage.persistence;

import android.content.Context;
import android.content.SharedPreferences;
import app.raybritton.tokenstorage.persistence.Persistence;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lapp/raybritton/tokenstorage/persistence/PreferencesPersistence;", "Lapp/raybritton/tokenstorage/persistence/Persistence;", "context", "Landroid/content/Context;", "filename", "", "(Landroid/content/Context;Ljava/lang/String;)V", "sharedPrefs", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "clear", "", "key", "clearAll", "keys", "", "load", "save", "encrypted", "core_release"})
public final class PreferencesPersistence
implements Persistence {
    private final SharedPreferences sharedPrefs;

    @Override
    public void clearAll() {
        this.sharedPrefs.edit().clear().apply();
    }

    @Override
    public void clear(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.sharedPrefs.edit().putString(key, null).apply();
    }

    @Override
    public void save(@NotNull String key, @NotNull String encrypted) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)encrypted, (String)"encrypted");
        this.sharedPrefs.edit().putString(key, encrypted).apply();
    }

    @Override
    @Nullable
    public String load(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.sharedPrefs.getString(key, null);
    }

    @Override
    @NotNull
    public List<String> keys() {
        SharedPreferences sharedPreferences = this.sharedPrefs;
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"sharedPrefs");
        return CollectionsKt.toList((Iterable)sharedPreferences.getAll().keySet());
    }

    public PreferencesPersistence(@NotNull Context context, @NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        this.sharedPrefs = context.getSharedPreferences(filename, 0);
    }

    public /* synthetic */ PreferencesPersistence(Context context, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "tokens.prefs";
        }
        this(context, string);
    }
}

