package app.raybritton.tokenstorage.persistence

/**
 * Stores the strings in a map in memory, this is mostly provided for
 * assisting with development of new TokenStorage classes and testing
 */
class InMemoryPersistence : Persistence {
    private val map = mutableMapOf<String, String>()

    override fun clearAll() {
        map.clear()
    }

    override fun clear(key: String) {
        map.remove(key)
    }

    override fun save(key: String, encrypted: String) {
        map[key] = encrypted
    }

    override fun load(key: String): String? {
        return map[key]
    }

    override fun keys(): List<String> {
        return map.keys.toList()
    }
}
