package app.raybritton.tokenstorage

import app.raybritton.tokenstorage.crypto.Crypto
import app.raybritton.tokenstorage.keyCrypto.KeyCrypto
import app.raybritton.tokenstorage.keyCrypto.NoKeyCrypto
import app.raybritton.tokenstorage.persistence.Persistence


open class TokenStorage(val crypto: Crypto,
                        val persistence: Persistence,
                        val keyCrypto: KeyCrypto = NoKeyCrypto()) {
    fun clearAll() {
        crypto.verify()
        keyCrypto.verify()
        persistence.clearAll()
    }

    fun clear(key: String) {
        crypto.verify()
        keyCrypto.verify()
        persistence.clear(keyCrypto.encrypt(key))
    }

    fun save(key: String, plaintext: String) {
        crypto.verify()
        keyCrypto.verify()
        persistence.save(keyCrypto.encrypt(key), crypto.encrypt(plaintext))
    }

    fun load(key: String): String? {
        crypto.verify()
        keyCrypto.verify()
        val encrypted = persistence.load(keyCrypto.encrypt(key))
        if (encrypted == null) {
            return null
        } else {
            return crypto.decrypt(encrypted)
        }
    }

    fun keys(): List<String> {
        crypto.verify()
        keyCrypto.verify()
        return persistence.keys().map { keyCrypto.decrypt(it) }
    }
}