package app.raybritton.tokenstorage.persistence

import android.content.Context

/**
 * Uses SharedPreferences to persist strings
 *
 * @param filename The name of the preferences file
 *
 */
class PreferencesPersistence(private val context: Context,
                             filename: String = "tokens.prefs") : Persistence {
    private val sharedPrefs = context.getSharedPreferences(filename, Context.MODE_PRIVATE)

    override fun clearAll() {
        sharedPrefs.edit()
                .clear()
                .apply()
    }

    override fun clear(key: String) {
        sharedPrefs.edit()
                .remove(key)
                .apply()
    }

    override fun save(key: String, encrypted: String) {
        sharedPrefs.edit()
                .putString(key, encrypted)
                .apply()
    }

    override fun load(key: String): String? {
        return sharedPrefs.getString(key, null)
    }

    override fun keys(): List<String> {
        return sharedPrefs.all.keys.toList()
    }

    override fun contains(key: String): Boolean {
        return sharedPrefs.contains(key)
    }

    override fun reset() {
        sharedPrefs.edit().clear().apply()
    }
}