/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.tokenstorage.crypto;

import android.os.Build;
import android.os.Process;
import android.util.Base64;
import android.util.Log;
import app.raybritton.tokenstorage.CryptoLogging;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003./0B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J \u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010!\u001a\u00020\u0007H\u0007J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u0014H\u0002J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0014H\u0002J\u0016\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007J\u0018\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lapp/raybritton/tokenstorage/crypto/AesCbcWithIntegrity;", "Lapp/raybritton/tokenstorage/CryptoLogging;", "()V", "AES_KEY_LENGTH_BITS", "", "BASE64_FLAGS", "CIPHER", "", "CIPHER_TRANSFORMATION", "HMAC_ALGORITHM", "HMAC_KEY_LENGTH_BITS", "IV_LENGTH_BYTES", "PBE_ALGORITHM", "PBE_ITERATION_COUNT", "RANDOM_ALGORITHM", "prngFixed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "constantTimeEq", "", "a", "", "b", "copyOfRange", "from", "start", "end", "decrypt", "civ", "Lapp/raybritton/tokenstorage/crypto/AesCbcWithIntegrity$CipherTextIvMac;", "secretKeys", "Lapp/raybritton/tokenstorage/crypto/AesCbcWithIntegrity$SecretKeys;", "encrypt", "plaintext", "encoding", "fixPrng", "", "generateIv", "generateKeyFromPassword", "password", "salt", "generateMac", "byteCipherText", "integrityKey", "Ljavax/crypto/SecretKey;", "randomBytes", "length", "CipherTextIvMac", "PrngFixes", "SecretKeys", "core_release"})
public final class AesCbcWithIntegrity
implements CryptoLogging {
    private static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String CIPHER = "AES";
    private static final String RANDOM_ALGORITHM = "SHA1PRNG";
    private static final int AES_KEY_LENGTH_BITS = 128;
    private static final int IV_LENGTH_BYTES = 16;
    private static final int PBE_ITERATION_COUNT = 10000;
    private static final String PBE_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int BASE64_FLAGS = 2;
    private static final AtomicBoolean prngFixed;
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final int HMAC_KEY_LENGTH_BITS = 256;
    public static final AesCbcWithIntegrity INSTANCE;

    private final SecretKeys generateKeyFromPassword(String password, byte[] salt2) throws GeneralSecurityException {
        this.debug("generateKeyFromPassword(" + this.shrink(password) + ", " + salt2 + ')');
        this.fixPrng();
        String string = password;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string2.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        int n = 384;
        int n2 = 10000;
        byte[] byArray = salt2;
        char[] cArray3 = cArray2;
        PBEKeySpec keySpec = new PBEKeySpec(cArray3, byArray, n2, n);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(PBE_ALGORITHM);
        SecretKey secretKey = keyFactory.generateSecret(keySpec);
        Intrinsics.checkExpressionValueIsNotNull((Object)secretKey, (String)"keyFactory.generateSecret(keySpec)");
        byte[] keyBytes = secretKey.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyBytes, (String)"keyBytes");
        byte[] confidentialityKeyBytes = this.copyOfRange(keyBytes, 0, 16);
        byte[] integrityKeyBytes = this.copyOfRange(keyBytes, 16, 48);
        SecretKeySpec confidentialityKey = new SecretKeySpec(confidentialityKeyBytes, CIPHER);
        SecretKeySpec integrityKey = new SecretKeySpec(integrityKeyBytes, HMAC_ALGORITHM);
        return new SecretKeys(confidentialityKey, integrityKey);
    }

    @NotNull
    public final SecretKeys generateKeyFromPassword(@NotNull String password, @NotNull String salt2) throws GeneralSecurityException {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        Intrinsics.checkParameterIsNotNull((Object)salt2, (String)"salt");
        this.fine("generateKeyFromPassword(" + this.shrink(password) + ", " + salt2 + ')');
        byte[] byArray = Base64.decode((String)salt2, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decode(salt, BASE64_FLAGS)");
        return this.generateKeyFromPassword(password, byArray);
    }

    private final byte[] generateIv() throws GeneralSecurityException {
        this.fine("generateIv()");
        return this.randomBytes(16);
    }

    private final byte[] randomBytes(int length) throws GeneralSecurityException {
        this.fine("randomBytes(" + length + ')');
        this.fixPrng();
        SecureRandom random = SecureRandom.getInstance(RANDOM_ALGORITHM);
        byte[] b = new byte[length];
        random.nextBytes(b);
        return b;
    }

    @JvmOverloads
    @NotNull
    public final CipherTextIvMac encrypt(@NotNull String plaintext, @NotNull SecretKeys secretKeys, @NotNull String encoding) throws UnsupportedEncodingException, GeneralSecurityException {
        Intrinsics.checkParameterIsNotNull((Object)plaintext, (String)"plaintext");
        Intrinsics.checkParameterIsNotNull((Object)secretKeys, (String)"secretKeys");
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        String string = plaintext;
        AesCbcWithIntegrity aesCbcWithIntegrity = this;
        boolean bl = false;
        Charset charset = Charset.forName(encoding);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
        Object object = charset;
        Charset charset2 = object;
        boolean bl2 = false;
        byte[] byArray = string.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        object = byArray;
        return aesCbcWithIntegrity.encrypt((byte[])object, secretKeys);
    }

    public static /* synthetic */ CipherTextIvMac encrypt$default(AesCbcWithIntegrity aesCbcWithIntegrity, String string, SecretKeys secretKeys, String string2, int n, Object object) throws UnsupportedEncodingException, GeneralSecurityException {
        if ((n & 4) != 0) {
            string2 = "UTF-8";
        }
        return aesCbcWithIntegrity.encrypt(string, secretKeys, string2);
    }

    @JvmOverloads
    @NotNull
    public final CipherTextIvMac encrypt(@NotNull String plaintext, @NotNull SecretKeys secretKeys) throws UnsupportedEncodingException, GeneralSecurityException {
        return AesCbcWithIntegrity.encrypt$default(this, plaintext, secretKeys, null, 4, null);
    }

    private final CipherTextIvMac encrypt(byte[] plaintext, SecretKeys secretKeys) throws GeneralSecurityException {
        byte[] iv = this.generateIv();
        Cipher aesCipherForEncryption = Cipher.getInstance(CIPHER_TRANSFORMATION);
        aesCipherForEncryption.init(1, (Key)secretKeys.getConfidentialityKey(), new IvParameterSpec(iv));
        Cipher cipher = aesCipherForEncryption;
        Intrinsics.checkExpressionValueIsNotNull((Object)cipher, (String)"aesCipherForEncryption");
        byte[] byArray = cipher.getIV();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"aesCipherForEncryption.iv");
        iv = byArray;
        byte[] byteCipherText = aesCipherForEncryption.doFinal(plaintext);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteCipherText, (String)"byteCipherText");
        byte[] ivCipherConcat = CipherTextIvMac.Companion.ivCipherConcat(iv, byteCipherText);
        byte[] integrityMac = this.generateMac(ivCipherConcat, secretKeys.getIntegrityKey());
        return new CipherTextIvMac(byteCipherText, iv, integrityMac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fixPrng() {
        this.debug("fixPrng()");
        if (!prngFixed.get()) {
            Class<PrngFixes> clazz = PrngFixes.class;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (clazz) {
                boolean bl3 = false;
                if (!prngFixed.get()) {
                    PrngFixes.INSTANCE.apply();
                    prngFixed.set(true);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    public final byte[] decrypt(@NotNull CipherTextIvMac civ, @NotNull SecretKeys secretKeys) throws GeneralSecurityException {
        Intrinsics.checkParameterIsNotNull((Object)civ, (String)"civ");
        Intrinsics.checkParameterIsNotNull((Object)secretKeys, (String)"secretKeys");
        byte[] ivCipherConcat = CipherTextIvMac.Companion.ivCipherConcat(civ.getIv(), civ.getCipherText());
        byte[] computedMac = this.generateMac(ivCipherConcat, secretKeys.getIntegrityKey());
        if (this.constantTimeEq(computedMac, civ.getMac())) {
            Cipher aesCipherForDecryption = Cipher.getInstance(CIPHER_TRANSFORMATION);
            aesCipherForDecryption.init(2, (Key)secretKeys.getConfidentialityKey(), new IvParameterSpec(civ.getIv()));
            byte[] byArray = aesCipherForDecryption.doFinal(civ.getCipherText());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"aesCipherForDecryption.doFinal(civ.cipherText)");
            return byArray;
        }
        throw (Throwable)new GeneralSecurityException("MAC stored in civ does not match computed MAC.");
    }

    private final byte[] generateMac(byte[] byteCipherText, SecretKey integrityKey) throws NoSuchAlgorithmException, InvalidKeyException {
        this.debug("generateMac(...)");
        Mac sha256HMAC = Mac.getInstance(HMAC_ALGORITHM);
        sha256HMAC.init(integrityKey);
        byte[] byArray = sha256HMAC.doFinal(byteCipherText);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"sha256HMAC.doFinal(byteCipherText)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean constantTimeEq(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int result = 0;
        int n = 0;
        int n2 = a.length;
        while (n < n2) {
            void i;
            result |= a[i] ^ b[i];
            ++i;
        }
        return result == 0;
    }

    private final byte[] copyOfRange(byte[] from, int start, int end) {
        int length = end - start;
        byte[] result = new byte[length];
        System.arraycopy(from, start, result, 0, length);
        return result;
    }

    private AesCbcWithIntegrity() {
    }

    static {
        AesCbcWithIntegrity aesCbcWithIntegrity;
        INSTANCE = aesCbcWithIntegrity = new AesCbcWithIntegrity();
        prngFixed = new AtomicBoolean(false);
        aesCbcWithIntegrity.fine("init");
    }

    @Override
    public void debug(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        CryptoLogging.DefaultImpls.debug(this, message);
    }

    @Override
    public void fine(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        CryptoLogging.DefaultImpls.fine(this, message);
    }

    @Override
    @NotNull
    public String shrink(@Nullable Object $this$shrink) {
        return CryptoLogging.DefaultImpls.shrink(this, $this$shrink);
    }

    @Override
    @NotNull
    public String logPrefix() {
        return CryptoLogging.DefaultImpls.logPrefix(this);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lapp/raybritton/tokenstorage/crypto/AesCbcWithIntegrity$SecretKeys;", "Lapp/raybritton/tokenstorage/CryptoLogging;", "confidentialityKey", "Ljavax/crypto/SecretKey;", "integrityKey", "(Ljavax/crypto/SecretKey;Ljavax/crypto/SecretKey;)V", "getConfidentialityKey", "()Ljavax/crypto/SecretKey;", "getIntegrityKey", "equals", "", "other", "", "hashCode", "", "toString", "", "core_release"})
    public static final class SecretKeys
    implements CryptoLogging {
        @NotNull
        private final SecretKey confidentialityKey;
        @NotNull
        private final SecretKey integrityKey;

        @NotNull
        public String toString() {
            return Base64.encodeToString((byte[])this.confidentialityKey.getEncoded(), (int)2) + ":" + Base64.encodeToString((byte[])this.integrityKey.getEncoded(), (int)2);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + this.confidentialityKey.hashCode();
            result = prime * result + this.integrityKey.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
                return false;
            }
            SecretKeys obj = (SecretKeys)other;
            if (Intrinsics.areEqual((Object)this.integrityKey, (Object)obj.integrityKey) ^ true) {
                return false;
            }
            return !(Intrinsics.areEqual((Object)this.confidentialityKey, (Object)obj.confidentialityKey) ^ true);
        }

        @NotNull
        public final SecretKey getConfidentialityKey() {
            return this.confidentialityKey;
        }

        @NotNull
        public final SecretKey getIntegrityKey() {
            return this.integrityKey;
        }

        public SecretKeys(@NotNull SecretKey confidentialityKey, @NotNull SecretKey integrityKey) {
            Intrinsics.checkParameterIsNotNull((Object)confidentialityKey, (String)"confidentialityKey");
            Intrinsics.checkParameterIsNotNull((Object)integrityKey, (String)"integrityKey");
            this.confidentialityKey = confidentialityKey;
            this.integrityKey = integrityKey;
            this.fine("init");
        }

        @Override
        public void debug(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            CryptoLogging.DefaultImpls.debug(this, message);
        }

        @Override
        public void fine(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            CryptoLogging.DefaultImpls.fine(this, message);
        }

        @Override
        @NotNull
        public String shrink(@Nullable Object $this$shrink) {
            return CryptoLogging.DefaultImpls.shrink(this, $this$shrink);
        }

        @Override
        @NotNull
        public String logPrefix() {
            return CryptoLogging.DefaultImpls.logPrefix(this);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0018"}, d2={"Lapp/raybritton/tokenstorage/crypto/AesCbcWithIntegrity$CipherTextIvMac;", "", "cipherTextBytes", "", "ivBytes", "macBytes", "([B[B[B)V", "base64IvAndCiphertext", "", "(Ljava/lang/String;)V", "cipherText", "getCipherText", "()[B", "iv", "getIv", "mac", "getMac", "equals", "", "other", "hashCode", "", "toString", "Companion", "core_release"})
    public static final class CipherTextIvMac {
        @NotNull
        private final byte[] cipherText;
        @NotNull
        private final byte[] iv;
        @NotNull
        private final byte[] mac;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final byte[] getCipherText() {
            return this.cipherText;
        }

        @NotNull
        public final byte[] getIv() {
            return this.iv;
        }

        @NotNull
        public final byte[] getMac() {
            return this.mac;
        }

        @NotNull
        public String toString() {
            String ivString = Base64.encodeToString((byte[])this.iv, (int)2);
            String cipherTextString = Base64.encodeToString((byte[])this.cipherText, (int)2);
            String macString = Base64.encodeToString((byte[])this.mac, (int)2);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = ivString + ':' + macString + ':' + cipherTextString;
            Object[] objectArray = new Object[]{};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + Arrays.hashCode(this.cipherText);
            result = prime * result + Arrays.hashCode(this.iv);
            result = prime * result + Arrays.hashCode(this.mac);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
                return false;
            }
            CipherTextIvMac obj = (CipherTextIvMac)other;
            if (!Arrays.equals(this.cipherText, obj.cipherText)) {
                return false;
            }
            if (!Arrays.equals(this.iv, obj.iv)) {
                return false;
            }
            return Arrays.equals(this.mac, obj.mac);
        }

        public CipherTextIvMac(@NotNull byte[] cipherTextBytes, @NotNull byte[] ivBytes, @NotNull byte[] macBytes) {
            Intrinsics.checkParameterIsNotNull((Object)cipherTextBytes, (String)"cipherTextBytes");
            Intrinsics.checkParameterIsNotNull((Object)ivBytes, (String)"ivBytes");
            Intrinsics.checkParameterIsNotNull((Object)macBytes, (String)"macBytes");
            this.cipherText = new byte[cipherTextBytes.length];
            System.arraycopy(cipherTextBytes, 0, this.cipherText, 0, cipherTextBytes.length);
            this.iv = new byte[ivBytes.length];
            System.arraycopy(ivBytes, 0, this.iv, 0, ivBytes.length);
            this.mac = new byte[macBytes.length];
            System.arraycopy(macBytes, 0, this.mac, 0, macBytes.length);
        }

        public CipherTextIvMac(@NotNull String base64IvAndCiphertext) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)base64IvAndCiphertext, (String)"base64IvAndCiphertext");
            CharSequence charSequence = base64IvAndCiphertext;
            String string = ":";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            List $this$dropLastWhile$iv = string.split(charSequence, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it;
                    boolean bl3 = false;
                    if (charSequence2.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection collection = $this$toTypedArray$iv;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] civArray = stringArray;
            if (civArray.length != 3) {
                throw (Throwable)new IllegalArgumentException("Cannot parse iv:ciphertext:mac");
            }
            byte[] byArray = Base64.decode((String)civArray[0], (int)2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decode(civArray[0], BASE64_FLAGS)");
            this.iv = byArray;
            byte[] byArray2 = Base64.decode((String)civArray[1], (int)2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"Base64.decode(civArray[1], BASE64_FLAGS)");
            this.mac = byArray2;
            byte[] byArray3 = Base64.decode((String)civArray[2], (int)2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"Base64.decode(civArray[2], BASE64_FLAGS)");
            this.cipherText = byArray3;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lapp/raybritton/tokenstorage/crypto/AesCbcWithIntegrity$CipherTextIvMac$Companion;", "", "()V", "ivCipherConcat", "", "iv", "cipherText", "core_release"})
        public static final class Companion {
            @NotNull
            public final byte[] ivCipherConcat(@NotNull byte[] iv, @NotNull byte[] cipherText) {
                Intrinsics.checkParameterIsNotNull((Object)iv, (String)"iv");
                Intrinsics.checkParameterIsNotNull((Object)cipherText, (String)"cipherText");
                byte[] combined = new byte[iv.length + cipherText.length];
                System.arraycopy(iv, 0, combined, 0, iv.length);
                System.arraycopy(cipherText, 0, combined, iv.length, cipherText.length);
                return combined;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0004H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lapp/raybritton/tokenstorage/crypto/AesCbcWithIntegrity$PrngFixes;", "", "()V", "BUILD_FINGERPRINT_AND_DEVICE_SERIAL", "", "VERSION_CODE_JELLY_BEAN", "", "VERSION_CODE_JELLY_BEAN_MR2", "buildFingerprintAndDeviceSerial", "getBuildFingerprintAndDeviceSerial", "()[B", "deviceSerialNumber", "", "getDeviceSerialNumber", "()Ljava/lang/String;", "apply", "", "applyOpenSSLFix", "generateSeed", "installLinuxPRNGSecureRandom", "LinuxPRNGSecureRandom", "LinuxPRNGSecureRandomProvider", "core_release"})
    public static final class PrngFixes {
        private static final int VERSION_CODE_JELLY_BEAN = 16;
        private static final int VERSION_CODE_JELLY_BEAN_MR2 = 18;
        private static final byte[] BUILD_FINGERPRINT_AND_DEVICE_SERIAL;
        public static final PrngFixes INSTANCE;

        public final void apply() {
            this.applyOpenSSLFix();
            this.installLinuxPRNGSecureRandom();
        }

        private final void applyOpenSSLFix() throws SecurityException {
            if (Build.VERSION.SDK_INT < 16 || Build.VERSION.SDK_INT > 18) {
                return;
            }
            try {
                Byte[] byteArray = ArraysKt.toTypedArray((byte[])this.generateSeed());
                Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_seed", byte[].class).invoke(null, (Object[])Arrays.copyOf(byteArray, byteArray.length));
                Object object = Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_load_file", String.class, Long.TYPE).invoke(null, "/dev/urandom", 1024);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                }
                int bytesRead = (Integer)object;
                if (bytesRead != 1024) {
                    throw (Throwable)new IOException("Unexpected number of bytes read from Linux PRNG: " + bytesRead);
                }
            }
            catch (Exception e) {
                throw (Throwable)new SecurityException("Failed to seed OpenSSL PRNG", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void installLinuxPRNGSecureRandom() throws SecurityException {
            if (Build.VERSION.SDK_INT > 18) {
                return;
            }
            Provider[] secureRandomProviders = Security.getProviders("SecureRandom.SHA1PRNG");
            Class<Security> clazz = Security.class;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (clazz) {
                SecureRandom rng1;
                block13: {
                    block12: {
                        boolean bl3 = false;
                        if (secureRandomProviders == null) break block12;
                        Provider[] providerArray = secureRandomProviders;
                        boolean bl4 = false;
                        if (!(providerArray.length == 0) && Intrinsics.areEqual((Object)secureRandomProviders[0].getClass().getSimpleName(), (Object)"LinuxPRNGSecureRandomProvider")) break block13;
                    }
                    Security.insertProviderAt(new LinuxPRNGSecureRandomProvider(), 1);
                }
                if (Intrinsics.areEqual((Object)(rng1 = new SecureRandom()).getProvider().getClass().getSimpleName(), (Object)"LinuxPRNGSecureRandomProvider") ^ true) {
                    throw (Throwable)new SecurityException("new SecureRandom() backed by wrong Provider: " + rng1.getProvider().getClass());
                }
                SecureRandom rng2 = null;
                try {
                    rng2 = SecureRandom.getInstance(AesCbcWithIntegrity.RANDOM_ALGORITHM);
                }
                catch (NoSuchAlgorithmException e) {
                    new SecurityException("SHA1PRNG not available", e);
                }
                SecureRandom secureRandom = rng2;
                if (secureRandom == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)secureRandom.getProvider().getClass().getSimpleName(), (Object)"LinuxPRNGSecureRandomProvider") ^ true) {
                    throw (Throwable)new SecurityException("SecureRandom.getInstance(\"SHA1PRNG\") backed by wrong Provider: " + rng2.getProvider().getClass());
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        private final byte[] generateSeed() {
            try {
                ByteArrayOutputStream seedBuffer = new ByteArrayOutputStream();
                DataOutputStream seedBufferOut = new DataOutputStream(seedBuffer);
                seedBufferOut.writeLong(System.currentTimeMillis());
                seedBufferOut.writeLong(System.nanoTime());
                seedBufferOut.writeInt(Process.myPid());
                seedBufferOut.writeInt(Process.myUid());
                seedBufferOut.write(BUILD_FINGERPRINT_AND_DEVICE_SERIAL);
                seedBufferOut.close();
                byte[] byArray = seedBuffer.toByteArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"seedBuffer.toByteArray()");
                return byArray;
            }
            catch (IOException e) {
                throw (Throwable)new SecurityException("Failed to generate seed", e);
            }
        }

        private final String getDeviceSerialNumber() {
            try {
                Object object = Build.class.getField("SERIAL").get(null);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                return (String)object;
            }
            catch (Exception ignored) {
                return null;
            }
        }

        private final byte[] getBuildFingerprintAndDeviceSerial() {
            String serial;
            StringBuilder result = new StringBuilder();
            String fingerprint = Build.FINGERPRINT;
            if (fingerprint != null) {
                result.append(fingerprint);
            }
            if ((serial = this.getDeviceSerialNumber()) != null) {
                result.append(serial);
            }
            try {
                String string = result.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.toString()");
                String string2 = string;
                Object object = "UTF-8";
                boolean bl = false;
                Charset charset = Charset.forName((String)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                object = charset;
                bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes((Charset)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                return byArray;
            }
            catch (UnsupportedEncodingException e) {
                throw (Throwable)new RuntimeException("UTF-8 encoding not supported");
            }
        }

        private PrngFixes() {
        }

        static {
            PrngFixes prngFixes;
            INSTANCE = prngFixes = new PrngFixes();
            BUILD_FINGERPRINT_AND_DEVICE_SERIAL = prngFixes.getBuildFingerprintAndDeviceSerial();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lapp/raybritton/tokenstorage/crypto/AesCbcWithIntegrity$PrngFixes$LinuxPRNGSecureRandomProvider;", "Ljava/security/Provider;", "()V", "core_release"})
        private static final class LinuxPRNGSecureRandomProvider
        extends Provider {
            public LinuxPRNGSecureRandomProvider() {
                super("LinuxPRNG", 1.0, "A Linux-specific random number provider that uses /dev/urandom");
                this.put("SecureRandom.SHA1PRNG", LinuxPRNGSecureRandom.class.getName());
                this.put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0014J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lapp/raybritton/tokenstorage/crypto/AesCbcWithIntegrity$PrngFixes$LinuxPRNGSecureRandom;", "Ljava/security/SecureRandomSpi;", "()V", "mSeeded", "", "urandomInputStream", "Ljava/io/DataInputStream;", "getUrandomInputStream", "()Ljava/io/DataInputStream;", "urandomOutputStream", "Ljava/io/OutputStream;", "getUrandomOutputStream", "()Ljava/io/OutputStream;", "engineGenerateSeed", "", "size", "", "engineNextBytes", "", "bytes", "engineSetSeed", "Companion", "core_release"})
        public static final class LinuxPRNGSecureRandom
        extends SecureRandomSpi {
            private boolean mSeeded;
            private static final File URANDOM_FILE;
            private static final Object sLock;
            private static DataInputStream sUrandomIn;
            private static OutputStream sUrandomOut;
            public static final Companion Companion;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void engineSetSeed(@NotNull byte[] bytes) {
                Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
                try {
                    OutputStream out = null;
                    Object object = sLock;
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        out = this.getUrandomOutputStream();
                        Unit unit = Unit.INSTANCE;
                    }
                    OutputStream outputStream = out;
                    if (outputStream == null) {
                        Intrinsics.throwNpe();
                    }
                    outputStream.write(bytes);
                    OutputStream outputStream2 = out;
                    if (outputStream2 == null) {
                        Intrinsics.throwNpe();
                    }
                    outputStream2.flush();
                }
                catch (IOException e) {
                    Log.w((String)PrngFixes.class.getSimpleName(), (String)("Failed to mix seed into " + URANDOM_FILE));
                }
                finally {
                    this.mSeeded = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void engineNextBytes(@NotNull byte[] bytes) {
                Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
                if (!this.mSeeded) {
                    this.engineSetSeed(INSTANCE.generateSeed());
                }
                try {
                    DataInputStream dis = null;
                    Object object = sLock;
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        dis = this.getUrandomInputStream();
                        Unit unit = Unit.INSTANCE;
                    }
                    DataInputStream dataInputStream = dis;
                    if (dataInputStream == null) {
                        Intrinsics.throwNpe();
                    }
                    object = dataInputStream;
                    bl = false;
                    boolean bl4 = false;
                    synchronized (object) {
                        boolean bl5 = false;
                        DataInputStream dataInputStream2 = dis;
                        if (dataInputStream2 == null) {
                            Intrinsics.throwNpe();
                        }
                        dataInputStream2.readFully(bytes);
                        Unit unit = Unit.INSTANCE;
                    }
                }
                catch (IOException e) {
                    throw (Throwable)new SecurityException("Failed to read from " + URANDOM_FILE, e);
                }
            }

            @Override
            @NotNull
            protected byte[] engineGenerateSeed(int size) {
                byte[] seed = new byte[size];
                this.engineNextBytes(seed);
                return seed;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final DataInputStream getUrandomInputStream() {
                Object object = sLock;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    if (sUrandomIn == null) {
                        try {
                            sUrandomIn = new DataInputStream(new FileInputStream(URANDOM_FILE));
                        }
                        catch (IOException e) {
                            throw (Throwable)new SecurityException("Failed to open " + URANDOM_FILE + " for reading", e);
                        }
                    }
                    DataInputStream dataInputStream = sUrandomIn;
                    if (dataInputStream == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.io.DataInputStream");
                    }
                    DataInputStream dataInputStream2 = dataInputStream;
                    return dataInputStream2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final OutputStream getUrandomOutputStream() throws IOException {
                Object object = sLock;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    if (sUrandomOut == null) {
                        sUrandomOut = new FileOutputStream(URANDOM_FILE);
                    }
                    OutputStream outputStream = sUrandomOut;
                    if (outputStream == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.io.OutputStream");
                    }
                    OutputStream outputStream2 = outputStream;
                    return outputStream2;
                }
            }

            static {
                Companion = new Companion(null);
                URANDOM_FILE = new File("/dev/urandom");
                sLock = new Object();
            }

            @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lapp/raybritton/tokenstorage/crypto/AesCbcWithIntegrity$PrngFixes$LinuxPRNGSecureRandom$Companion;", "", "()V", "URANDOM_FILE", "Ljava/io/File;", "sLock", "sUrandomIn", "Ljava/io/DataInputStream;", "sUrandomOut", "Ljava/io/OutputStream;", "core_release"})
            public static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

