/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.tokenstorage;

import app.raybritton.tokenstorage.CryptoLogging;
import app.raybritton.tokenstorage.TokenStorage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u0004\u0018\u00010\u0005J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lapp/raybritton/tokenstorage/TokenWrapper;", "Lapp/raybritton/tokenstorage/CryptoLogging;", "tokenStorage", "Lapp/raybritton/tokenstorage/TokenStorage;", "key", "", "(Lapp/raybritton/tokenstorage/TokenStorage;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "clear", "", "isSet", "", "load", "logPrefix", "save", "plaintext", "core_release"})
public final class TokenWrapper
implements CryptoLogging {
    private final TokenStorage<?, ?, ?> tokenStorage;
    @NotNull
    private final String key;

    public final void save(@NotNull String plaintext) {
        Intrinsics.checkParameterIsNotNull((Object)plaintext, (String)"plaintext");
        this.fine("save(" + this.shrink(plaintext) + ')');
        this.tokenStorage.save(this.key, plaintext);
    }

    @Nullable
    public final String load() {
        this.fine("load()");
        return this.tokenStorage.load(this.key);
    }

    public final boolean isSet() {
        this.fine("isSet()");
        return this.tokenStorage.contains(this.key);
    }

    public final void clear() {
        this.fine("clear()");
        this.tokenStorage.clear(this.key);
    }

    @Override
    @NotNull
    public String logPrefix() {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        return stringBuilder.append(thread.getName()).append("]-").append(this.getClass().getSimpleName()).append('{').append(System.identityHashCode(this)).append("}[").append(this.key).append("] - ").toString();
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    public TokenWrapper(@NotNull TokenStorage<?, ?, ?> tokenStorage, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull(tokenStorage, (String)"tokenStorage");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.tokenStorage = tokenStorage;
        this.key = key;
        this.fine("init");
    }

    @Override
    public void debug(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        CryptoLogging.DefaultImpls.debug(this, message);
    }

    @Override
    public void fine(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        CryptoLogging.DefaultImpls.fine(this, message);
    }

    @Override
    @NotNull
    public String shrink(@Nullable Object $receiver) {
        return CryptoLogging.DefaultImpls.shrink(this, $receiver);
    }
}

