package app.raybritton.tokenstorage

import android.util.Log

interface CryptoLogging {
    enum class LogLevel {
        NONE, DEBUG, ALL
    }

    fun debug(message: String) {
        if (loggingLevel >= LogLevel.DEBUG) {
            Log.d(TAG, logPrefix() + message)
        }
    }

    fun fine(message: String) {
        if (loggingLevel >= LogLevel.ALL) {
            Log.v(TAG, logPrefix() + message)
        }
    }

    fun String?.shrink(): String {
        return if (this == null) {
            "null"
        } else if (length > 12) {
            substring(0, 6) + "..." + substring(length - 6, length)
        } else {
            this
        }
    }

    fun logPrefix(): String = "[${Thread.currentThread().name}]-${this::class.java.simpleName}{${System.identityHashCode(this)}} - "

    companion object {
        private const val TAG = "Crypto"

        var loggingLevel = LogLevel.NONE
    }
}