/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.tokenstorage.crypto;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import app.raybritton.tokenstorage.crypto.Crypto;
import app.raybritton.tokenstorage.crypto.PassphraseCrypto;
import java.io.File;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.security.auth.x500.X500Principal;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u0001:\u000223BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0003J\b\u0010(\u001a\u00020)H\u0003J\b\u0010*\u001a\u00020!H\u0016J\u0016\u0010+\u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002J\b\u0010/\u001a\u00020!H\u0016J\f\u00100\u001a\u000201*\u000201H\u0002R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lapp/raybritton/tokenstorage/crypto/CertCrypto;", "Lapp/raybritton/tokenstorage/crypto/Crypto;", "context", "Landroid/content/Context;", "alias", "", "saltDir", "Ljava/io/File;", "saltFilename", "keyDir", "keyFilename", "options", "Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options;", "(Landroid/content/Context;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options;)V", "ENCRYPT_ALGORITHM", "KEYSTORE_ALGORITM", "KEYSTORE_TYPE", "internalCrypto", "Lapp/raybritton/tokenstorage/crypto/PassphraseCrypto;", "passphrase", "getPassphrase", "()Ljava/lang/String;", "passphrase$delegate", "Lkotlin/Lazy;", "privateKey", "Ljava/security/PrivateKey;", "publicKey", "Ljava/security/PublicKey;", "certDecrypt", "encrypted", "certEncrypt", "plaintext", "certVerify", "", "decrypt", "encrypt", "loadCert", "", "marshmallowKeyGen", "Landroid/security/keystore/KeyGenParameterSpec;", "preMarshmallowKeyGen", "Landroid/security/KeyPairGeneratorSpec;", "reset", "setupPassphrase", "gen", "Lkotlin/Function0;", "Ljava/security/spec/AlgorithmParameterSpec;", "verify", "setupBiometrics", "Landroid/security/keystore/KeyGenParameterSpec$Builder;", "Companion", "Options", "core_release"})
public final class CertCrypto
implements Crypto {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final String KEYSTORE_TYPE = "AndroidKeyStore";
    private final String KEYSTORE_ALGORITM = "RSA";
    private final String ENCRYPT_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private final PassphraseCrypto internalCrypto;
    private final Lazy passphrase$delegate;
    private final Context context;
    private final String alias;
    private final File keyDir;
    private final String keyFilename;
    private final Options options;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(CertCrypto.class), "passphrase", "getPassphrase()Ljava/lang/String;"))};
        Companion = new Companion(null);
    }

    private final String getPassphrase() {
        Lazy lazy = this.passphrase$delegate;
        CertCrypto certCrypto = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    private final boolean loadCert() {
        KeyStore keyStore = KeyStore.getInstance(this.KEYSTORE_TYPE);
        keyStore.load(null);
        if (keyStore.containsAlias(this.alias)) {
            Key key = keyStore.getKey(this.alias, null);
            if (key == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.security.PrivateKey");
            }
            this.privateKey = (PrivateKey)key;
            Certificate certificate = keyStore.getCertificate(this.alias);
            Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"keyStore.getCertificate(alias)");
            this.publicKey = certificate.getPublicKey();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String encrypt(@NotNull String plaintext) {
        Intrinsics.checkParameterIsNotNull((Object)plaintext, (String)"plaintext");
        return this.internalCrypto.encrypt(plaintext);
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String encrypted) {
        Intrinsics.checkParameterIsNotNull((Object)encrypted, (String)"encrypted");
        return this.internalCrypto.decrypt(encrypted);
    }

    private final String certEncrypt(String plaintext) {
        Cipher cipher = Cipher.getInstance(this.ENCRYPT_ALGORITHM);
        cipher.init(1, this.publicKey);
        String string = plaintext;
        Cipher cipher2 = cipher;
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] encrypted = cipher2.doFinal(byArray2);
        String string3 = Base64.encodeToString((byte[])encrypted, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Base64.encodeToString(encrypted, Base64.NO_WRAP)");
        return string3;
    }

    private final String certDecrypt(String encrypted) {
        Cipher cipher = Cipher.getInstance(this.ENCRYPT_ALGORITHM);
        cipher.init(2, this.privateKey);
        byte[] encryptedData = Base64.decode((String)encrypted, (int)0);
        byte[] decodedData = cipher.doFinal(encryptedData);
        Intrinsics.checkExpressionValueIsNotNull((Object)decodedData, (String)"decodedData");
        byte[] byArray = decodedData;
        return new String(byArray, Charsets.UTF_8);
    }

    private final void certVerify() {
        if (!this.loadCert()) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.setupPassphrase((Function0<? extends AlgorithmParameterSpec>)((Function0)new Function0<KeyGenParameterSpec>(this){

                    @NotNull
                    public final KeyGenParameterSpec invoke() {
                        return CertCrypto.access$marshmallowKeyGen((CertCrypto)this.receiver);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(CertCrypto.class);
                    }

                    public final String getName() {
                        return "marshmallowKeyGen";
                    }

                    public final String getSignature() {
                        return "marshmallowKeyGen()Landroid/security/keystore/KeyGenParameterSpec;";
                    }
                }));
            } else {
                this.setupPassphrase((Function0<? extends AlgorithmParameterSpec>)((Function0)new Function0<KeyPairGeneratorSpec>(this){

                    @NotNull
                    public final KeyPairGeneratorSpec invoke() {
                        return CertCrypto.access$preMarshmallowKeyGen((CertCrypto)this.receiver);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(CertCrypto.class);
                    }

                    public final String getName() {
                        return "preMarshmallowKeyGen";
                    }

                    public final String getSignature() {
                        return "preMarshmallowKeyGen()Landroid/security/KeyPairGeneratorSpec;";
                    }
                }));
            }
        }
    }

    @Override
    public void verify() {
        this.internalCrypto.setPassphrase(this.getPassphrase());
        this.internalCrypto.verify();
    }

    @Override
    public void reset() {
        new File(this.keyDir, this.keyFilename).delete();
        this.internalCrypto.reset();
    }

    private final void setupPassphrase(Function0<? extends AlgorithmParameterSpec> gen) {
        KeyPair keyPair;
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.KEYSTORE_ALGORITM, this.KEYSTORE_TYPE);
        keyPairGenerator.initialize((AlgorithmParameterSpec)gen.invoke());
        KeyPair keyPair2 = keyPair = keyPairGenerator.generateKeyPair();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyPair2, (String)"keyPair");
        this.privateKey = keyPair2.getPrivate();
        this.publicKey = keyPair.getPublic();
    }

    @TargetApi(value=23)
    private final KeyGenParameterSpec marshmallowKeyGen() {
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.alias, 3).setBlockModes(new String[]{"ECB"}).setEncryptionPaddings(new String[]{"PKCS1Padding"}).setUserAuthenticationRequired(this.options.getUserAuth$core_release()).setUserAuthenticationValidityDurationSeconds(this.options.getLoginSeconds$core_release());
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"KeyGenParameterSpec.Buil\u2026nds(options.loginSeconds)");
        KeyGenParameterSpec keyGenParameterSpec = this.setupBiometrics(builder).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyGenParameterSpec, (String)"KeyGenParameterSpec.Buil\u2026\n                .build()");
        return keyGenParameterSpec;
    }

    private final KeyPairGeneratorSpec preMarshmallowKeyGen() {
        Calendar calendar;
        Calendar calendar2 = Calendar.getInstance();
        KeyPairGeneratorSpec.Builder builder = new KeyPairGeneratorSpec.Builder(this.context).setAlias(this.alias).setSerialNumber(BigInteger.valueOf(32945367343536L)).setSubject(new X500Principal("CN=" + this.alias + " Certificate, O=" + this.context.getPackageName()));
        Calendar it = calendar2;
        it.add(1, -1);
        Calendar calendar3 = calendar = calendar2;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar3, (String)"Calendar.getInstance().a\u2026.add(Calendar.YEAR, -1) }");
        calendar2 = Calendar.getInstance();
        builder = builder.setStartDate(calendar3.getTime());
        it = calendar2;
        it.add(1, 30);
        Calendar calendar4 = calendar = calendar2;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar4, (String)"Calendar.getInstance().a\u2026.add(Calendar.YEAR, 30) }");
        KeyPairGeneratorSpec keyPairGeneratorSpec = builder.setEndDate(calendar4.getTime()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyPairGeneratorSpec, (String)"KeyPairGeneratorSpec.Bui\u2026\n                .build()");
        return keyPairGeneratorSpec;
    }

    private final KeyGenParameterSpec.Builder setupBiometrics(@NotNull KeyGenParameterSpec.Builder $receiver) {
        if (Build.VERSION.SDK_INT >= 24) {
            $receiver.setInvalidatedByBiometricEnrollment(this.options.getInvalidate$core_release());
        }
        return $receiver;
    }

    public CertCrypto(@NotNull Context context, @NotNull String alias, @NotNull File saltDir, @NotNull String saltFilename, @NotNull File keyDir, @NotNull String keyFilename, @NotNull Options options) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        Intrinsics.checkParameterIsNotNull((Object)saltDir, (String)"saltDir");
        Intrinsics.checkParameterIsNotNull((Object)saltFilename, (String)"saltFilename");
        Intrinsics.checkParameterIsNotNull((Object)keyDir, (String)"keyDir");
        Intrinsics.checkParameterIsNotNull((Object)keyFilename, (String)"keyFilename");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.context = context;
        this.alias = alias;
        this.keyDir = keyDir;
        this.keyFilename = keyFilename;
        this.options = options;
        this.KEYSTORE_TYPE = "AndroidKeyStore";
        this.KEYSTORE_ALGORITM = "RSA";
        this.ENCRYPT_ALGORITHM = "RSA/ECB/PKCS1Padding";
        this.internalCrypto = new PassphraseCrypto(saltDir, saltFilename);
        this.passphrase$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ CertCrypto this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                String string;
                CertCrypto.access$certVerify(this.this$0);
                File passphraseFile = new File(CertCrypto.access$getKeyDir$p(this.this$0), CertCrypto.access$getKeyFilename$p(this.this$0));
                if (passphraseFile.exists()) {
                    string = CertCrypto.access$certDecrypt(this.this$0, (String)FilesKt.readLines$default((File)passphraseFile, null, (int)1, null).get(0));
                } else {
                    void var2_2;
                    String newPassphrase = UUID.randomUUID().toString() + UUID.randomUUID().toString() + UUID.randomUUID().toString() + UUID.randomUUID().toString();
                    FilesKt.writeText$default((File)passphraseFile, (String)CertCrypto.access$certEncrypt(this.this$0, newPassphrase), null, (int)2, null);
                    string = var2_2;
                }
                return string;
            }
            {
                this.this$0 = certCrypto;
                super(0);
            }
        }));
    }

    public /* synthetic */ CertCrypto(Context context, String string, File file, String string2, File file2, String string3, Options options, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = context.getPackageName() + "_tokens";
        }
        if ((n & 4) != 0) {
            File file3 = context.getFilesDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"context.filesDir");
            file = file3;
        }
        if ((n & 8) != 0) {
            string2 = "cert-crypto-salt";
        }
        if ((n & 0x10) != 0) {
            File file4 = context.getFilesDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"context.filesDir");
            file2 = file4;
        }
        if ((n & 0x20) != 0) {
            string3 = "cert-crypto-key";
        }
        if ((n & 0x40) != 0) {
            options = new Options.NO_AUTH();
        }
        this(context, string, file, string2, file2, string3, options);
    }

    @NotNull
    public static final /* synthetic */ KeyGenParameterSpec access$marshmallowKeyGen(CertCrypto $this) {
        return $this.marshmallowKeyGen();
    }

    @NotNull
    public static final /* synthetic */ KeyPairGeneratorSpec access$preMarshmallowKeyGen(CertCrypto $this) {
        return $this.preMarshmallowKeyGen();
    }

    public static final /* synthetic */ void access$certVerify(CertCrypto $this) {
        $this.certVerify();
    }

    @NotNull
    public static final /* synthetic */ File access$getKeyDir$p(CertCrypto $this) {
        return $this.keyDir;
    }

    @NotNull
    public static final /* synthetic */ String access$getKeyFilename$p(CertCrypto $this) {
        return $this.keyFilename;
    }

    @NotNull
    public static final /* synthetic */ String access$certDecrypt(CertCrypto $this, @NotNull String encrypted) {
        return $this.certDecrypt(encrypted);
    }

    @NotNull
    public static final /* synthetic */ String access$certEncrypt(CertCrypto $this, @NotNull String plaintext) {
        return $this.certEncrypt(plaintext);
    }

    @JvmStatic
    @NotNull
    public static final CertCrypto defaults(@NotNull Context context) {
        return Companion.defaults(context);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u0082\u0001\u0003\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options;", "", "userAuth", "", "invalidate", "loginSeconds", "", "(ZZI)V", "getInvalidate$core_release", "()Z", "getLoginSeconds$core_release", "()I", "getUserAuth$core_release", "KEYGUARD_REQUIRED", "LOGGED_IN", "NO_AUTH", "Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options$NO_AUTH;", "Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options$KEYGUARD_REQUIRED;", "Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options$LOGGED_IN;", "core_release"})
    public static abstract class Options {
        private final boolean userAuth;
        private final boolean invalidate;
        private final int loginSeconds;

        public final boolean getUserAuth$core_release() {
            return this.userAuth;
        }

        public final boolean getInvalidate$core_release() {
            return this.invalidate;
        }

        public final int getLoginSeconds$core_release() {
            return this.loginSeconds;
        }

        private Options(boolean userAuth, boolean invalidate, int loginSeconds) {
            this.userAuth = userAuth;
            this.invalidate = invalidate;
            this.loginSeconds = loginSeconds;
        }

        public /* synthetic */ Options(boolean userAuth, boolean invalidate, int loginSeconds, DefaultConstructorMarker $constructor_marker) {
            this(userAuth, invalidate, loginSeconds);
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options$NO_AUTH;", "Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options;", "()V", "core_release"})
        public static final class NO_AUTH
        extends Options {
            public NO_AUTH() {
                super(false, false, 0, null);
            }
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options$KEYGUARD_REQUIRED;", "Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options;", "invalidateOnChange", "", "(Z)V", "core_release"})
        public static final class KEYGUARD_REQUIRED
        extends Options {
            public KEYGUARD_REQUIRED(boolean invalidateOnChange) {
                super(true, invalidateOnChange, 0, null);
            }
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options$LOGGED_IN;", "Lapp/raybritton/tokenstorage/crypto/CertCrypto$Options;", "invalidateOnChange", "", "maxSecondsSinceUnlock", "", "(ZI)V", "core_release"})
        public static final class LOGGED_IN
        extends Options {
            public LOGGED_IN(boolean invalidateOnChange, int maxSecondsSinceUnlock) {
                super(true, invalidateOnChange, maxSecondsSinceUnlock, null);
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lapp/raybritton/tokenstorage/crypto/CertCrypto$Companion;", "", "()V", "defaults", "Lapp/raybritton/tokenstorage/crypto/CertCrypto;", "context", "Landroid/content/Context;", "core_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final CertCrypto defaults(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            String string = context.getPackageName() + "_tokens";
            File file = context.getFilesDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.filesDir");
            File file2 = context.getFilesDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"context.filesDir");
            return new CertCrypto(context, string, file, "cert-crypto-salt", file2, "cert-crypto-key", new Options.NO_AUTH());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

