package app.raybritton.tokenstorage.keyCrypto

/**
 * Used by TokenStorage to encrypt and decrypt keys, as such it must produce the same encrypted string for a plaintext
 */
interface KeyCrypto {
    /**
     * Called on every call to TokenStorage so this class can
     * check that the crypto is setup
     *
     * If not it should throw an exception
     */
    fun verify()

    fun encrypt(plaintext: String): String
    fun decrypt(encrypted: String): String

    fun scramblesKeys() = false
}
