/*
 * Decompiled with CFR 0.152.
 */
package app.raybritton.tokenstorage;

import app.raybritton.tokenstorage.TokenWrapper;
import app.raybritton.tokenstorage.crypto.Crypto;
import app.raybritton.tokenstorage.keyCrypto.KeyCrypto;
import app.raybritton.tokenstorage.persistence.Persistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u00020\u0007B\u001d\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00028\u0001\u0012\u0006\u0010\n\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0018J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\n\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\t\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lapp/raybritton/tokenstorage/TokenStorage;", "C", "Lapp/raybritton/tokenstorage/crypto/Crypto;", "P", "Lapp/raybritton/tokenstorage/persistence/Persistence;", "KC", "Lapp/raybritton/tokenstorage/keyCrypto/KeyCrypto;", "", "crypto", "persistence", "keyCrypto", "(Lapp/raybritton/tokenstorage/crypto/Crypto;Lapp/raybritton/tokenstorage/persistence/Persistence;Lapp/raybritton/tokenstorage/keyCrypto/KeyCrypto;)V", "getCrypto", "()Lapp/raybritton/tokenstorage/crypto/Crypto;", "Lapp/raybritton/tokenstorage/crypto/Crypto;", "getKeyCrypto", "()Lapp/raybritton/tokenstorage/keyCrypto/KeyCrypto;", "Lapp/raybritton/tokenstorage/keyCrypto/KeyCrypto;", "getPersistence", "()Lapp/raybritton/tokenstorage/persistence/Persistence;", "Lapp/raybritton/tokenstorage/persistence/Persistence;", "clear", "", "key", "", "clearAll", "contains", "", "keys", "", "load", "save", "plaintext", "wrap", "Lapp/raybritton/tokenstorage/TokenWrapper;", "core_release"})
public class TokenStorage<C extends Crypto, P extends Persistence, KC extends KeyCrypto> {
    @NotNull
    private final C crypto;
    @NotNull
    private final P persistence;
    @NotNull
    private final KC keyCrypto;

    public final void clearAll() {
        this.crypto.verify();
        this.keyCrypto.verify();
        this.persistence.clearAll();
    }

    public final void clear(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.crypto.verify();
        this.keyCrypto.verify();
        this.persistence.clear(this.keyCrypto.encrypt(key));
    }

    public final void save(@NotNull String key, @NotNull String plaintext) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)plaintext, (String)"plaintext");
        this.crypto.verify();
        this.keyCrypto.verify();
        this.persistence.save(this.keyCrypto.encrypt(key), this.crypto.encrypt(plaintext));
    }

    @Nullable
    public final String load(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.crypto.verify();
        this.keyCrypto.verify();
        String encrypted = this.persistence.load(this.keyCrypto.encrypt(key));
        if (encrypted == null) {
            return null;
        }
        return this.crypto.decrypt(encrypted);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> keys() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        this.crypto.verify();
        this.keyCrypto.verify();
        Iterable iterable = $receiver$iv = (Iterable)this.persistence.keys();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string2 = this.keyCrypto.decrypt((String)it);
            collection.add(string2);
        }
        return (List)var3_3;
    }

    public final boolean contains(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.crypto.verify();
        this.keyCrypto.verify();
        return this.persistence.contains(this.keyCrypto.encrypt(key));
    }

    @NotNull
    public final TokenWrapper wrap(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return new TokenWrapper(this, key);
    }

    @NotNull
    public final C getCrypto() {
        return this.crypto;
    }

    @NotNull
    public final P getPersistence() {
        return this.persistence;
    }

    @NotNull
    public final KC getKeyCrypto() {
        return this.keyCrypto;
    }

    public TokenStorage(@NotNull C crypto, @NotNull P persistence, @NotNull KC keyCrypto) {
        Intrinsics.checkParameterIsNotNull(crypto, (String)"crypto");
        Intrinsics.checkParameterIsNotNull(persistence, (String)"persistence");
        Intrinsics.checkParameterIsNotNull(keyCrypto, (String)"keyCrypto");
        this.crypto = crypto;
        this.persistence = persistence;
        this.keyCrypto = keyCrypto;
    }
}

